/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum ClientType {
    PUBLIC(1, "public"),
    CONFIDENTIAL(2, "confidential");

    private static final ClientType[] sValues;
    private static final Helper sHelper;
    private final short mValue;
    private final String mString;

    private ClientType(short value, String string2) {
        this.mValue = value;
        this.mString = string2;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public static ClientType getByValue(short value) {
        if (value < 1 || sValues.length < value) {
            return null;
        }
        return sValues[value - 1];
    }

    public static ClientType parse(String clientType) {
        if (clientType == null) {
            return null;
        }
        for (ClientType entry : sValues) {
            if (!entry.mString.equals(clientType)) continue;
            return entry;
        }
        return null;
    }

    public static int toBits(EnumSet<ClientType> set) {
        return sHelper.toBits(set);
    }

    public static ClientType[] toArray(int bits) {
        return (ClientType[])sHelper.toArray(bits);
    }

    public static EnumSet<ClientType> toSet(int bits) {
        return sHelper.toSet(bits);
    }

    public static EnumSet<ClientType> toSet(ClientType[] array) {
        return sHelper.toSet(array);
    }

    static {
        sValues = ClientType.values();
        sHelper = new Helper(sValues);
    }

    private static class Helper
    extends EnumHelper<ClientType> {
        public Helper(ClientType[] values) {
            super(ClientType.class, (Enum[])values);
        }

        @Override
        protected short getValue(ClientType entry) {
            return entry.getValue();
        }

        protected ClientType[] newArray(int size) {
            return new ClientType[size];
        }
    }
}

