/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

public enum CodeChallengeMethod {
    PLAIN(1, "plain"),
    S256(2, "S256");

    private static final CodeChallengeMethod[] sValues;
    private final short mValue;
    private final String mString;

    private CodeChallengeMethod(short value, String string2) {
        this.mValue = value;
        this.mString = string2;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public static CodeChallengeMethod getByValue(short value) {
        if (value < 1 || sValues.length < value) {
            return null;
        }
        return sValues[value - 1];
    }

    public static CodeChallengeMethod parse(String method) {
        if (method == null) {
            return null;
        }
        for (CodeChallengeMethod value : sValues) {
            if (!value.mString.equals(method)) continue;
            return value;
        }
        return null;
    }

    static {
        sValues = CodeChallengeMethod.values();
    }
}

