/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum DeliveryMode {
    POLL(1, "poll"),
    PING(2, "ping"),
    PUSH(3, "push");

    private static final DeliveryMode[] sValues;
    private static final Helper sHelper;
    private final short mValue;
    private final String mString;

    private DeliveryMode(short value, String string2) {
        this.mValue = value;
        this.mString = string2;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public static DeliveryMode getByValue(short value) {
        if (value < 1 || sValues.length < value) {
            return null;
        }
        return sValues[value - 1];
    }

    public static DeliveryMode parse(String grantType) {
        if (grantType == null) {
            return null;
        }
        for (DeliveryMode entry : sValues) {
            if (!entry.mString.equals(grantType)) continue;
            return entry;
        }
        return null;
    }

    public static int toBits(EnumSet<DeliveryMode> set) {
        return sHelper.toBits(set);
    }

    public static DeliveryMode[] toArray(int bits) {
        return (DeliveryMode[])sHelper.toArray(bits);
    }

    public static EnumSet<DeliveryMode> toSet(int bits) {
        return sHelper.toSet(bits);
    }

    public static EnumSet<DeliveryMode> toSet(DeliveryMode[] array) {
        return sHelper.toSet(array);
    }

    static {
        sValues = DeliveryMode.values();
        sHelper = new Helper(sValues);
    }

    private static class Helper
    extends EnumHelper<DeliveryMode> {
        public Helper(DeliveryMode[] values) {
            super(DeliveryMode.class, (Enum[])values);
        }

        @Override
        protected short getValue(DeliveryMode entry) {
            return entry.getValue();
        }

        protected DeliveryMode[] newArray(int size) {
            return new DeliveryMode[size];
        }
    }
}

