/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter.converters;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.utils.DateUtil;
import java.util.Date;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ExtentHtmlLogConverter {
    private static final String DATE_FORMAT = "hh:mm:ss a";
    private Element testElement;
    private Test test;

    public ExtentHtmlLogConverter(Test test, Element testElement) {
        this.test = test;
        this.testElement = testElement;
    }

    public void parseAndAddLogsToTest() {
        if (this.test.getLevel() == 0) {
            this.addHtmlLogsToParent();
            return;
        }
        this.addHtmlLogsToNode();
    }

    private void addHtmlLogsToParent() {
        Elements testSteps = this.testElement.select(":root > .test-content > .test-steps");
        if (!testSteps.isEmpty()) {
            Elements logs = testSteps.first().select(".log");
            this.addLogsFromPreExistingMarkup(logs);
        }
    }

    private void addHtmlLogsToNode() {
        Elements nodeSteps = this.testElement.select(":root > .collapsible-body > .node-steps");
        if (!nodeSteps.isEmpty()) {
            Elements logs = nodeSteps.first().select(".log");
            this.addLogsFromPreExistingMarkup(logs);
        }
    }

    private void addLogsFromPreExistingMarkup(Elements logs) {
        for (Element log : logs) {
            Status status = this.getStatus(log);
            Date timestamp = this.getTimestamp(log.select(".timestamp").first());
            String details = this.getDetails(log.select(".step-details").first());
            Log logModel = new Log(this.test);
            logModel.setStatus(status);
            logModel.setDetails(details);
            logModel.setTimestamp(timestamp);
            this.test.getLogContext().add(logModel);
        }
    }

    private Status getStatus(Element trLog) {
        String status = trLog.attr("status").toUpperCase();
        return Status.valueOf(status);
    }

    private Date getTimestamp(Element tdTimestamp) {
        String timestamp = tdTimestamp.text();
        return DateUtil.parse(timestamp, DATE_FORMAT);
    }

    private String getDetails(Element tdDetails) {
        String details = tdDetails.html();
        return details;
    }
}

