/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.model.context;

import com.aventstack.extentreports.model.Attribute;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.model.context.TestAttributeTestContext;
import com.aventstack.extentreports.model.context.helpers.TestRemover;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class TestAttributeTestContextStore<T extends Attribute> {
    private List<TestAttributeTestContext<T>> testAttrTestContext = new ArrayList<TestAttributeTestContext<T>>();

    public void setAttributeContext(T attr, Test test) {
        Optional<TestAttributeTestContext> optTestContext = this.testAttrTestContext.stream().filter(x -> x.getName().equals(attr.getName())).findFirst();
        if (optTestContext.isPresent()) {
            List<Test> tests = optTestContext.get().getTests();
            boolean b = tests.stream().anyMatch(t -> t.getId() == test.getId());
            if (!b) {
                optTestContext.get().setTest(test);
            }
            optTestContext.get().refreshTestStatusCounts();
        } else {
            TestAttributeTestContext<T> testAttrContext = new TestAttributeTestContext<T>(attr);
            testAttrContext.setTest(test);
            this.testAttrTestContext.add(testAttrContext);
        }
    }

    public synchronized void removeTest(Test test) {
        Iterator<TestAttributeTestContext<T>> iter = this.testAttrTestContext.iterator();
        while (iter.hasNext()) {
            TestAttributeTestContext<T> context = iter.next();
            TestRemover.remove(context.getTests(), test);
            if (!context.isEmpty()) continue;
            iter.remove();
        }
    }

    public List<TestAttributeTestContext<T>> getTestAttributeTestContext() {
        return this.testAttrTestContext;
    }
}

