/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpRetryPolicy;
import com.azure.core.amqp.ExponentialAmqpRetryPolicy;
import com.azure.core.amqp.FixedAmqpRetryPolicy;
import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.util.logging.ClientLogger;
import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.TimeoutException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

public final class RetryUtil {
    private static final double JITTER_FACTOR = 0.08;
    private static final Duration SERVER_BUSY_WAIT_TIME = Duration.ofSeconds(4L);
    private static final ClientLogger LOGGER = new ClientLogger(RetryUtil.class);

    private RetryUtil() {
    }

    public static AmqpRetryPolicy getRetryPolicy(AmqpRetryOptions options) {
        switch (options.getMode()) {
            case FIXED: {
                return new FixedAmqpRetryPolicy(options);
            }
            case EXPONENTIAL: {
                return new ExponentialAmqpRetryPolicy(options);
            }
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Mode is not supported: %s", new Object[]{options.getMode()}));
    }

    public static <T> Mono<T> withRetry(Mono<T> source, AmqpRetryOptions retryOptions, String errorMessage, boolean allowsLongOperation) {
        if (!allowsLongOperation) {
            source = source.timeout(retryOptions.getTryTimeout());
        }
        return source.retryWhen(RetryUtil.createRetry(retryOptions)).doOnError(error -> LOGGER.error(errorMessage, new Object[]{error}));
    }

    public static <T> Flux<T> withRetry(Flux<T> source, AmqpRetryOptions retryOptions, String timeoutMessage) {
        return source.timeout(retryOptions.getTryTimeout()).retryWhen(RetryUtil.createRetry(retryOptions)).doOnError(error -> LOGGER.error(timeoutMessage, new Object[]{error}));
    }

    public static <T> Mono<T> withRetry(Mono<T> source, AmqpRetryOptions retryOptions, String timeoutMessage) {
        return RetryUtil.withRetry(source, retryOptions, timeoutMessage, false);
    }

    static Retry createRetry(AmqpRetryOptions options) {
        RetryBackoffSpec retrySpec;
        Duration delay = options.getDelay().plus(SERVER_BUSY_WAIT_TIME);
        switch (options.getMode()) {
            case FIXED: {
                retrySpec = Retry.fixedDelay((long)options.getMaxRetries(), (Duration)delay);
                break;
            }
            case EXPONENTIAL: {
                retrySpec = Retry.backoff((long)options.getMaxRetries(), (Duration)delay);
                break;
            }
            default: {
                LOGGER.warning("Unknown: '{}'. Using exponential delay. Delay: {}. Max Delay: {}. Max Retries: {}.", new Object[]{options.getMode(), options.getDelay(), options.getMaxDelay(), options.getMaxRetries()});
                retrySpec = Retry.backoff((long)options.getMaxRetries(), (Duration)delay);
            }
        }
        return retrySpec.jitter(0.08).maxBackoff(options.getMaxDelay()).filter(error -> error instanceof TimeoutException || error instanceof AmqpException && ((AmqpException)((Object)((Object)error))).isTransient());
    }
}

