/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation.handler;

import com.azure.core.util.logging.ClientLogger;
import java.security.KeyManagementException;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.stream.Stream;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

class StrictTlsContextSpi
extends SSLContextSpi {
    private static final String SSL_V2_HELLO = "SSLv2Hello";
    private static final ClientLogger LOGGER = new ClientLogger(StrictTlsContextSpi.class);
    private final SSLContext sslContext;

    StrictTlsContextSpi(SSLContext sslContext) {
        this.sslContext = Objects.requireNonNull(sslContext, "'sslContext' cannot be null.");
    }

    @Override
    protected void engineInit(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom) throws KeyManagementException {
        this.sslContext.init(keyManagers, trustManagers, secureRandom);
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        return this.sslContext.getSocketFactory();
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        return this.sslContext.getServerSocketFactory();
    }

    @Override
    protected SSLEngine engineCreateSSLEngine() {
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        String[] protocols = this.getAllowedProtocols(sslEngine.getEnabledProtocols());
        sslEngine.setEnabledProtocols(protocols);
        return sslEngine;
    }

    @Override
    protected SSLEngine engineCreateSSLEngine(String host, int port) {
        SSLEngine sslEngine = this.sslContext.createSSLEngine(host, port);
        String[] protocols = this.getAllowedProtocols(sslEngine.getEnabledProtocols());
        sslEngine.setEnabledProtocols(protocols);
        return sslEngine;
    }

    @Override
    protected SSLSessionContext engineGetServerSessionContext() {
        return this.sslContext.getServerSessionContext();
    }

    @Override
    protected SSLSessionContext engineGetClientSessionContext() {
        return this.sslContext.getClientSessionContext();
    }

    private String[] getAllowedProtocols(String[] protocols) {
        return (String[])Stream.of(protocols).filter(protocol -> {
            boolean isSSLv2Hello = protocol.equalsIgnoreCase(SSL_V2_HELLO);
            if (isSSLv2Hello) {
                LOGGER.info("{} was an enabled protocol. Filtering out.", new Object[]{SSL_V2_HELLO});
            }
            return !isSSLv2Hello;
        }).toArray(String[]::new);
    }
}

