/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.jdk.httpclient.implementation;

import com.azure.core.http.HttpHeaders;
import com.azure.core.implementation.util.HttpHeadersAccessHelper;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.SharedExecutorService;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class JdkHttpUtils {
    public static HttpHeaders fromJdkHttpHeaders(java.net.http.HttpHeaders headers) {
        HttpHeaders httpHeaders = new HttpHeaders((int)((float)headers.map().size() / 0.75f));
        for (Map.Entry<String, List<String>> kvp : headers.map().entrySet()) {
            if (CoreUtils.isNullOrEmpty((Collection)kvp.getValue())) continue;
            HttpHeadersAccessHelper.setInternal((HttpHeaders)httpHeaders, (String)kvp.getKey(), (String)kvp.getKey(), kvp.getValue());
        }
        return httpHeaders;
    }

    public static int getSizeOfBuffers(List<ByteBuffer> buffers) {
        long size = 0L;
        for (ByteBuffer buffer : buffers) {
            if ((size += (long)buffer.remaining()) <= Integer.MAX_VALUE) continue;
            throw new IllegalStateException("The size of the buffers is greater than Integer.MAX_VALUE.");
        }
        return (int)size;
    }

    public static ScheduledFuture<?> scheduleTimeoutTask(Runnable task, long timeoutMillis) {
        return SharedExecutorService.getInstance().schedule(task, timeoutMillis, TimeUnit.MILLISECONDS);
    }

    private JdkHttpUtils() {
    }
}

