/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.serializer;

import com.azure.core.http.HttpResponse;
import com.azure.core.implementation.serializer.HttpResponseBodyDecoder;
import com.azure.core.implementation.serializer.HttpResponseDecodeData;
import com.azure.core.implementation.serializer.HttpResponseHeaderDecoder;
import com.azure.core.util.serializer.SerializerAdapter;
import java.io.Closeable;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Mono;

public final class HttpResponseDecoder {
    private final SerializerAdapter serializer;

    public HttpResponseDecoder(SerializerAdapter serializer) {
        this.serializer = serializer;
    }

    public Mono<HttpDecodedResponse> decode(Mono<HttpResponse> response, HttpResponseDecodeData decodeData) {
        return response.map(r -> new HttpDecodedResponse((HttpResponse)r, this.serializer, decodeData));
    }

    public static final class HttpDecodedResponse
    implements Closeable {
        private final HttpResponse response;
        private final SerializerAdapter serializer;
        private final HttpResponseDecodeData decodeData;
        private Mono<Object> bodyCached;
        private Mono<Object> headersCached;

        HttpDecodedResponse(HttpResponse response, SerializerAdapter serializer, HttpResponseDecodeData decodeData) {
            this.response = response;
            this.serializer = serializer;
            this.decodeData = decodeData;
        }

        public HttpResponse getSourceResponse() {
            return this.response;
        }

        public Mono<Object> getDecodedBody(String body) {
            return this.getDecodedBody(body.getBytes(StandardCharsets.UTF_8));
        }

        public Mono<Object> getDecodedBody(byte[] body) {
            if (this.bodyCached == null) {
                this.bodyCached = HttpResponseBodyDecoder.decodeByteArray(body, this.response, this.serializer, this.decodeData).cache();
            }
            return this.bodyCached;
        }

        public Mono<Object> getDecodedHeaders() {
            if (this.headersCached == null) {
                this.headersCached = HttpResponseHeaderDecoder.decode(this.response, this.serializer, this.decodeData).cache();
            }
            return this.headersCached;
        }

        public Type getDecodedType() {
            return HttpResponseBodyDecoder.decodedType(this.response, this.decodeData);
        }

        public boolean isErrorStatus() {
            return HttpResponseBodyDecoder.isErrorStatus(this.response, this.decodeData);
        }

        @Override
        public void close() {
            this.response.close();
        }
    }
}

