/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AadCredentialBuilderBase;
import com.azure.identity.AuthorizationCodeCredential;
import com.azure.identity.implementation.util.ValidationUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public class AuthorizationCodeCredentialBuilder
extends AadCredentialBuilderBase<AuthorizationCodeCredentialBuilder> {
    private final ClientLogger logger = new ClientLogger(AuthorizationCodeCredentialBuilder.class);
    private String authCode;
    private String redirectUrl;

    public AuthorizationCodeCredentialBuilder authorizationCode(String authCode) {
        this.authCode = authCode;
        return this;
    }

    public AuthorizationCodeCredentialBuilder redirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    public AuthorizationCodeCredential build() {
        ValidationUtil.validate(this.getClass().getSimpleName(), (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("clientId", AuthorizationCodeCredentialBuilder.this.clientId);
                this.put("authorizationCode", AuthorizationCodeCredentialBuilder.this.authCode);
                this.put("redirectUrl", AuthorizationCodeCredentialBuilder.this.redirectUrl);
            }
        });
        try {
            return new AuthorizationCodeCredential(this.clientId, this.tenantId, this.authCode, new URI(this.redirectUrl), this.identityClientOptions);
        }
        catch (URISyntaxException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e));
        }
    }
}

