/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation.util;

import com.azure.core.util.Base64Util;
import com.azure.core.util.logging.ClientLogger;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CertificateUtil {
    private static final ClientLogger LOGGER = new ClientLogger(CertificateUtil.class);

    public static PrivateKey privateKeyFromPem(byte[] pem) {
        Pattern pattern = Pattern.compile("(?s)-----BEGIN PRIVATE KEY-----.*-----END PRIVATE KEY-----");
        Matcher matcher = pattern.matcher(new String(pem, StandardCharsets.UTF_8));
        if (!matcher.find()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Certificate file provided is not a valid PEM file."));
        }
        String base64 = matcher.group().replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replace("\n", "").replace("\r", "");
        byte[] key = Base64Util.decode((byte[])base64.getBytes(StandardCharsets.UTF_8));
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(key);
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePrivate(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(e));
        }
    }

    public static X509Certificate publicKeyFromPem(byte[] pem) {
        Pattern pattern = Pattern.compile("(?s)-----BEGIN CERTIFICATE-----.*-----END CERTIFICATE-----");
        Matcher matcher = pattern.matcher(new String(pem, StandardCharsets.UTF_8));
        if (!matcher.find()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("PEM certificate provided does not contain -----BEGIN CERTIFICATE-----END CERTIFICATE----- block"));
        }
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream stream = new ByteArrayInputStream(matcher.group().getBytes(StandardCharsets.UTF_8));
            return (X509Certificate)factory.generateCertificate(stream);
        }
        catch (CertificateException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(e));
        }
    }

    private CertificateUtil() {
    }
}

