/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AuthenticationRequiredException;
import com.azure.identity.AzureAuthorityHosts;
import com.azure.identity.CredentialUnavailableException;
import com.azure.identity.DeviceCodeInfo;
import com.azure.identity.implementation.AuthenticationRecord;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.MsalAuthenticationAccount;
import com.azure.identity.implementation.MsalToken;
import com.azure.identity.implementation.util.LoggingUtil;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;

public class DeviceCodeCredential
implements TokenCredential {
    private final Consumer<DeviceCodeInfo> challengeConsumer;
    private final IdentityClient identityClient;
    private final AtomicReference<MsalAuthenticationAccount> cachedToken;
    private final String authorityHost;
    private final boolean automaticAuthentication;
    private final ClientLogger logger = new ClientLogger(DeviceCodeCredential.class);

    DeviceCodeCredential(String clientId, String tenantId, Consumer<DeviceCodeInfo> challengeConsumer, boolean automaticAuthentication, IdentityClientOptions identityClientOptions) {
        this.challengeConsumer = challengeConsumer;
        this.identityClient = new IdentityClientBuilder().tenantId(tenantId).clientId(clientId).identityClientOptions(identityClientOptions).build();
        this.cachedToken = new AtomicReference();
        this.authorityHost = identityClientOptions.getAuthorityHost();
        this.automaticAuthentication = automaticAuthentication;
        if (identityClientOptions.getAuthenticationRecord() != null) {
            this.cachedToken.set(new MsalAuthenticationAccount(identityClientOptions.getAuthenticationRecord()));
        }
    }

    public Mono<AccessToken> getToken(TokenRequestContext request) {
        return Mono.defer(() -> {
            if (this.cachedToken.get() != null) {
                return this.identityClient.authenticateWithPublicClientCache(request, this.cachedToken.get()).onErrorResume(t -> Mono.empty());
            }
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> {
            if (!this.automaticAuthentication) {
                return Mono.error((Throwable)this.logger.logExceptionAsError((RuntimeException)((Object)new AuthenticationRequiredException("Interactive authentication is needed to acquire token. Call Authenticate to initiate the device code authentication.", request))));
            }
            return this.identityClient.authenticateWithDeviceCode(request, this.challengeConsumer);
        })).map(this::updateCache).doOnNext(token -> LoggingUtil.logTokenSuccess(this.logger, request)).doOnError(error -> LoggingUtil.logTokenError(this.logger, request, error));
    }

    Mono<AuthenticationRecord> authenticate(TokenRequestContext request) {
        return Mono.defer(() -> this.identityClient.authenticateWithDeviceCode(request, this.challengeConsumer)).map(this::updateCache).map(msalToken -> this.cachedToken.get().getAuthenticationRecord());
    }

    Mono<AuthenticationRecord> authenticate() {
        String defaultScope = AzureAuthorityHosts.getDefaultScope(this.authorityHost);
        if (defaultScope == null) {
            return Mono.error((Throwable)this.logger.logExceptionAsError((RuntimeException)((Object)new CredentialUnavailableException("Authenticating in this environment requires specifying a TokenRequestContext."))));
        }
        return this.authenticate(new TokenRequestContext().addScopes(new String[]{defaultScope}));
    }

    private AccessToken updateCache(MsalToken msalToken) {
        this.cachedToken.set(new MsalAuthenticationAccount(new AuthenticationRecord(msalToken.getAuthenticationResult(), this.identityClient.getTenantId(), this.identityClient.getClientId()), msalToken.getAccount().getTenantProfiles()));
        return msalToken;
    }
}

