/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.messaging.servicebus.administration.implementation.models.ResponseLinkImpl;
import com.azure.messaging.servicebus.administration.implementation.models.SubscriptionDescriptionEntryImpl;
import com.azure.messaging.servicebus.administration.implementation.models.TitleImpl;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class SubscriptionDescriptionFeedImpl
implements XmlSerializable<SubscriptionDescriptionFeedImpl> {
    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM = "http://www.w3.org/2005/Atom";
    private String id;
    private TitleImpl title;
    private OffsetDateTime updated;
    private List<ResponseLinkImpl> link = new ArrayList<ResponseLinkImpl>();
    private List<SubscriptionDescriptionEntryImpl> entry = new ArrayList<SubscriptionDescriptionEntryImpl>();

    public String getId() {
        return this.id;
    }

    public SubscriptionDescriptionFeedImpl setId(String id) {
        this.id = id;
        return this;
    }

    public TitleImpl getTitle() {
        return this.title;
    }

    public SubscriptionDescriptionFeedImpl setTitle(TitleImpl title) {
        this.title = title;
        return this;
    }

    public OffsetDateTime getUpdated() {
        return this.updated;
    }

    public SubscriptionDescriptionFeedImpl setUpdated(OffsetDateTime updated) {
        this.updated = updated;
        return this;
    }

    public List<ResponseLinkImpl> getLink() {
        return this.link;
    }

    public SubscriptionDescriptionFeedImpl setLink(List<ResponseLinkImpl> link) {
        this.link = link;
        return this;
    }

    public List<SubscriptionDescriptionEntryImpl> getEntry() {
        return this.entry;
    }

    public SubscriptionDescriptionFeedImpl setEntry(List<SubscriptionDescriptionEntryImpl> entry) {
        this.entry = entry;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "feed" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM);
        xmlWriter.writeStringElement(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "id", this.id);
        xmlWriter.writeXml((XmlSerializable)this.title, "title");
        xmlWriter.writeStringElement(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "updated", this.updated == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.updated));
        if (this.link != null) {
            for (ResponseLinkImpl responseLinkImpl : this.link) {
                xmlWriter.writeXml((XmlSerializable)responseLinkImpl, "link");
            }
        }
        if (this.entry != null) {
            for (SubscriptionDescriptionEntryImpl subscriptionDescriptionEntryImpl : this.entry) {
                xmlWriter.writeXml((XmlSerializable)subscriptionDescriptionEntryImpl, "entry");
            }
        }
        return xmlWriter.writeEndElement();
    }

    public static SubscriptionDescriptionFeedImpl fromXml(XmlReader xmlReader) throws XMLStreamException {
        return SubscriptionDescriptionFeedImpl.fromXml(xmlReader, null);
    }

    public static SubscriptionDescriptionFeedImpl fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "feed" : rootElementName;
        return (SubscriptionDescriptionFeedImpl)xmlReader.readObject(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, finalRootElementName, reader -> {
            SubscriptionDescriptionFeedImpl deserializedSubscriptionDescriptionFeed = new SubscriptionDescriptionFeedImpl();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("id".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescriptionFeed.id = reader.getStringElement();
                    continue;
                }
                if ("title".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescriptionFeed.title = TitleImpl.fromXml(reader, "title");
                    continue;
                }
                if ("updated".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescriptionFeed.updated = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("link".equals(elementName.getLocalPart())) {
                    deserializedSubscriptionDescriptionFeed.link.add(ResponseLinkImpl.fromXml(reader, "link"));
                    continue;
                }
                if ("entry".equals(elementName.getLocalPart())) {
                    deserializedSubscriptionDescriptionFeed.entry.add(SubscriptionDescriptionEntryImpl.fromXml(reader, "entry"));
                    continue;
                }
                reader.skipElement();
            }
            return deserializedSubscriptionDescriptionFeed;
        });
    }
}

