/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation;

import com.azure.messaging.servicebus.implementation.ServiceBusConstants;
import com.azure.messaging.servicebus.implementation.ServiceBusDescribedType;
import java.time.Duration;

public class DurationDescribedType
extends ServiceBusDescribedType {
    public DurationDescribedType(Duration duration) {
        super(ServiceBusConstants.DURATION_SYMBOL, DurationDescribedType.convertToTickTime(duration));
    }

    private static Long convertToTickTime(Duration described) {
        return described.toNanos() / ServiceBusConstants.TIME_LENGTH_DELTA;
    }

    @Override
    public int size() {
        return ServiceBusConstants.DURATION_SYMBOL.length() + 8;
    }
}

