/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography.models;

import com.azure.core.util.CoreUtils;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;

public final class EncryptResult {
    private final byte[] cipherText;
    private final EncryptionAlgorithm algorithm;
    private final String keyId;

    public EncryptResult(byte[] cipherText, EncryptionAlgorithm algorithm, String keyId) {
        this.cipherText = CoreUtils.clone((byte[])cipherText);
        this.algorithm = algorithm;
        this.keyId = keyId;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public byte[] getCipherText() {
        return CoreUtils.clone((byte[])this.cipherText);
    }

    public EncryptionAlgorithm getAlgorithm() {
        return this.algorithm;
    }
}

