/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.secrets.implementation.models.SecretAttributes;
import java.io.IOException;
import java.util.Map;

public final class SecretSetParameters
implements JsonSerializable<SecretSetParameters> {
    private String value;
    private Map<String, String> tags;
    private String secretContentType;
    private SecretAttributes secretAttributes;

    public String getValue() {
        return this.value;
    }

    public SecretSetParameters setValue(String value) {
        this.value = value;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public SecretSetParameters setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String getSecretContentType() {
        return this.secretContentType;
    }

    public SecretSetParameters setSecretContentType(String secretContentType) {
        this.secretContentType = secretContentType;
        return this;
    }

    public SecretAttributes getSecretAttributes() {
        return this.secretAttributes;
    }

    public SecretSetParameters setSecretAttributes(SecretAttributes secretAttributes) {
        this.secretAttributes = secretAttributes;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("contentType", this.secretContentType);
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.secretAttributes);
        return jsonWriter.writeEndObject();
    }

    public static SecretSetParameters fromJson(JsonReader jsonReader) throws IOException {
        return (SecretSetParameters)jsonReader.readObject(reader -> {
            SecretSetParameters deserializedSecretSetParameters = new SecretSetParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deserializedSecretSetParameters.value = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedSecretSetParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    deserializedSecretSetParameters.secretContentType = reader.getString();
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedSecretSetParameters.secretAttributes = SecretAttributes.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretSetParameters;
        });
    }
}

