/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common;

import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.io.OutputStream;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.NonNull;

public abstract class StorageOutputStream
extends OutputStream {
    final ClientLogger logger = new ClientLogger(StorageOutputStream.class);
    private final int writeThreshold;
    protected volatile IOException lastError;

    protected abstract Mono<Void> dispatchWrite(byte[] var1, int var2, long var3);

    protected StorageOutputStream(int writeThreshold) {
        this.writeThreshold = writeThreshold;
    }

    private void writeInternal(byte[] data, int offset, int length) {
        int chunks = (int)Math.ceil((double)length / (double)this.writeThreshold);
        Flux.range((int)0, (int)chunks).map(c -> offset + c * this.writeThreshold).concatMap(pos -> this.processChunk(data, (int)pos, offset, length)).then().block();
    }

    private Mono<Void> processChunk(byte[] data, int position, int offset, int length) {
        int chunkLength = this.writeThreshold;
        if (position + chunkLength > offset + length) {
            chunkLength = offset + length - position;
        }
        return this.dispatchWrite(data, chunkLength, position).doOnError(t -> {
            this.lastError = t instanceof IOException ? (IOException)t : new IOException((Throwable)t);
        });
    }

    protected void checkStreamState() {
        if (this.lastError != null) {
            throw this.logger.logExceptionAsError(new RuntimeException(this.lastError.getMessage()));
        }
    }

    @Override
    public void flush() {
        this.checkStreamState();
    }

    @Override
    public void write(@NonNull byte[] data) {
        this.write(data, 0, data.length);
    }

    @Override
    public void write(@NonNull byte[] data, int offset, int length) {
        if (offset < 0 || length < 0 || length > data.length - offset) {
            throw this.logger.logExceptionAsError((RuntimeException)new IndexOutOfBoundsException());
        }
        this.writeInternal(data, offset, length);
    }

    @Override
    public void write(int byteVal) {
        this.write(new byte[]{(byte)(byteVal & 0xFF)});
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            this.checkStreamState();
            this.flush();
        }
        finally {
            this.lastError = new IOException("Stream is already closed.");
        }
    }
}

