/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.implementation.credentials;

import com.azure.core.implementation.util.ImplUtils;
import java.util.Map;

public final class SasTokenCredential {
    private static final String SIGNATURE = "sig";
    private final String sasToken;

    public SasTokenCredential(String sasToken) {
        this.sasToken = sasToken;
    }

    public String getSasToken() {
        return this.sasToken;
    }

    public static SasTokenCredential fromSasTokenString(String sasToken) {
        if (ImplUtils.isNullOrEmpty((CharSequence)sasToken)) {
            return null;
        }
        if (sasToken.charAt(0) == '?') {
            sasToken = sasToken.substring(1);
        }
        return new SasTokenCredential(sasToken);
    }

    public static SasTokenCredential fromQueryParameters(Map<String, String> queryParameters) {
        if (ImplUtils.isNullOrEmpty(queryParameters) || !queryParameters.containsKey(SIGNATURE)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> kvp : queryParameters.entrySet()) {
            if (sb.length() != 0) {
                sb.append("&");
            }
            sb.append(kvp.getKey()).append("=").append(kvp.getValue());
        }
        return new SasTokenCredential(sb.toString());
    }
}

