/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.queue.implementation.AzureQueueStorageImpl;
import com.azure.storage.queue.implementation.SignedIdentifiersWrapper;
import com.azure.storage.queue.implementation.models.QueuesCreateHeaders;
import com.azure.storage.queue.implementation.models.QueuesDeleteHeaders;
import com.azure.storage.queue.implementation.models.QueuesGetAccessPolicyHeaders;
import com.azure.storage.queue.implementation.models.QueuesGetPropertiesHeaders;
import com.azure.storage.queue.implementation.models.QueuesSetAccessPolicyHeaders;
import com.azure.storage.queue.implementation.models.QueuesSetMetadataHeaders;
import com.azure.storage.queue.models.QueueSignedIdentifier;
import com.azure.storage.queue.models.QueueStorageException;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class QueuesImpl {
    private final QueuesService service;
    private final AzureQueueStorageImpl client;

    QueuesImpl(AzureQueueStorageImpl client) {
        this.service = (QueuesService)RestProxy.create(QueuesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesCreateHeaders, Void>> createWithResponseAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.create(this.client.getUrl(), queueName, timeout, metadata, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesCreateHeaders, Void>> createWithResponseAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.create(this.client.getUrl(), queueName, timeout, metadata, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId) {
        return this.createWithResponseAsync(queueName, timeout, metadata, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId, Context context) {
        return this.createWithResponseAsync(queueName, timeout, metadata, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesDeleteHeaders, Void>> deleteWithResponseAsync(String queueName, Integer timeout, String requestId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getUrl(), queueName, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesDeleteHeaders, Void>> deleteWithResponseAsync(String queueName, Integer timeout, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.delete(this.client.getUrl(), queueName, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String queueName, Integer timeout, String requestId) {
        return this.deleteWithResponseAsync(queueName, timeout, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String queueName, Integer timeout, String requestId, Context context) {
        return this.deleteWithResponseAsync(queueName, timeout, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String queueName, Integer timeout, String requestId) {
        String comp = "metadata";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getProperties(this.client.getUrl(), queueName, "metadata", timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String queueName, Integer timeout, String requestId, Context context) {
        String comp = "metadata";
        String accept = "application/xml";
        return this.service.getProperties(this.client.getUrl(), queueName, "metadata", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String queueName, Integer timeout, String requestId) {
        return this.getPropertiesWithResponseAsync(queueName, timeout, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String queueName, Integer timeout, String requestId, Context context) {
        return this.getPropertiesWithResponseAsync(queueName, timeout, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesSetMetadataHeaders, Void>> setMetadataWithResponseAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId) {
        String comp = "metadata";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.setMetadata(this.client.getUrl(), queueName, "metadata", timeout, metadata, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesSetMetadataHeaders, Void>> setMetadataWithResponseAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId, Context context) {
        String comp = "metadata";
        String accept = "application/xml";
        return this.service.setMetadata(this.client.getUrl(), queueName, "metadata", timeout, metadata, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setMetadataAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId) {
        return this.setMetadataWithResponseAsync(queueName, timeout, metadata, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setMetadataAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId, Context context) {
        return this.setMetadataWithResponseAsync(queueName, timeout, metadata, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesGetAccessPolicyHeaders, List<QueueSignedIdentifier>>> getAccessPolicyWithResponseAsync(String queueName, Integer timeout, String requestId) {
        String comp = "acl";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getAccessPolicy(this.client.getUrl(), queueName, "acl", timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesGetAccessPolicyHeaders, List<QueueSignedIdentifier>>> getAccessPolicyWithResponseAsync(String queueName, Integer timeout, String requestId, Context context) {
        String comp = "acl";
        String accept = "application/xml";
        return this.service.getAccessPolicy(this.client.getUrl(), queueName, "acl", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<QueueSignedIdentifier>> getAccessPolicyAsync(String queueName, Integer timeout, String requestId) {
        return this.getAccessPolicyWithResponseAsync(queueName, timeout, requestId).flatMap(res -> Mono.justOrEmpty((Object)((List)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<QueueSignedIdentifier>> getAccessPolicyAsync(String queueName, Integer timeout, String requestId, Context context) {
        return this.getAccessPolicyWithResponseAsync(queueName, timeout, requestId, context).flatMap(res -> Mono.justOrEmpty((Object)((List)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesSetAccessPolicyHeaders, Void>> setAccessPolicyWithResponseAsync(String queueName, Integer timeout, String requestId, List<QueueSignedIdentifier> queueAcl) {
        String comp = "acl";
        String accept = "application/xml";
        SignedIdentifiersWrapper queueAclConverted = new SignedIdentifiersWrapper(queueAcl);
        return FluxUtil.withContext(context -> this.service.setAccessPolicy(this.client.getUrl(), queueName, "acl", timeout, this.client.getVersion(), requestId, queueAclConverted, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesSetAccessPolicyHeaders, Void>> setAccessPolicyWithResponseAsync(String queueName, Integer timeout, String requestId, List<QueueSignedIdentifier> queueAcl, Context context) {
        String comp = "acl";
        String accept = "application/xml";
        SignedIdentifiersWrapper queueAclConverted = new SignedIdentifiersWrapper(queueAcl);
        return this.service.setAccessPolicy(this.client.getUrl(), queueName, "acl", timeout, this.client.getVersion(), requestId, queueAclConverted, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setAccessPolicyAsync(String queueName, Integer timeout, String requestId, List<QueueSignedIdentifier> queueAcl) {
        return this.setAccessPolicyWithResponseAsync(queueName, timeout, requestId, queueAcl).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setAccessPolicyAsync(String queueName, Integer timeout, String requestId, List<QueueSignedIdentifier> queueAcl, Context context) {
        return this.setAccessPolicyWithResponseAsync(queueName, timeout, requestId, queueAcl, context).flatMap(ignored -> Mono.empty());
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureQueueStorageQue")
    public static interface QueuesService {
        @Put(value="/{queueName}")
        @ExpectedResponses(value={201, 204})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<QueuesCreateHeaders, Void>> create(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-meta-") Map<String, String> var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Delete(value="/{queueName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<QueuesDeleteHeaders, Void>> delete(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/{queueName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<QueuesGetPropertiesHeaders, Void>> getProperties(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Put(value="/{queueName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<QueuesSetMetadataHeaders, Void>> setMetadata(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-meta-") Map<String, String> var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/{queueName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<QueuesGetAccessPolicyHeaders, List<QueueSignedIdentifier>>> getAccessPolicy(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Put(value="/{queueName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<QueuesSetAccessPolicyHeaders, Void>> setAccessPolicy(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") SignedIdentifiersWrapper var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

