/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation.models;

import com.azure.core.annotation.HeaderCollection;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

@JacksonXmlRootElement(localName="null")
public final class QueuesGetPropertiesHeaders {
    @JsonProperty(value="x-ms-version")
    private String xMsVersion;
    @JsonProperty(value="x-ms-approximate-messages-count")
    private Integer xMsApproximateMessagesCount;
    @HeaderCollection(value="x-ms-meta-")
    private Map<String, String> xMsMeta;
    @JsonProperty(value="x-ms-request-id")
    private String xMsRequestId;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 date;

    public QueuesGetPropertiesHeaders(HttpHeaders rawHeaders) {
        this.xMsVersion = rawHeaders.getValue("x-ms-version");
        String xMsApproximateMessagesCount = rawHeaders.getValue("x-ms-approximate-messages-count");
        if (xMsApproximateMessagesCount != null) {
            this.xMsApproximateMessagesCount = Integer.parseInt(xMsApproximateMessagesCount);
        }
        this.xMsRequestId = rawHeaders.getValue("x-ms-request-id");
        String date = rawHeaders.getValue("Date");
        if (date != null) {
            this.date = new DateTimeRfc1123(date);
        }
        HashMap<String, String> xMsMetaHeaderCollection = new HashMap<String, String>();
        for (HttpHeader header : rawHeaders) {
            String headerName = header.getName();
            if (!headerName.startsWith("x-ms-meta-")) continue;
            xMsMetaHeaderCollection.put(headerName.substring(10), header.getValue());
        }
        this.xMsMeta = xMsMetaHeaderCollection;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public QueuesGetPropertiesHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public Integer getXMsApproximateMessagesCount() {
        return this.xMsApproximateMessagesCount;
    }

    public QueuesGetPropertiesHeaders setXMsApproximateMessagesCount(Integer xMsApproximateMessagesCount) {
        this.xMsApproximateMessagesCount = xMsApproximateMessagesCount;
        return this;
    }

    public Map<String, String> getXMsMeta() {
        return this.xMsMeta;
    }

    public QueuesGetPropertiesHeaders setXMsMeta(Map<String, String> xMsMeta) {
        this.xMsMeta = xMsMeta;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public QueuesGetPropertiesHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public QueuesGetPropertiesHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }
}

