/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.sas;

import java.util.Locale;

public final class QueueSasPermission {
    private boolean readPermission;
    private boolean addPermission;
    private boolean updatePermission;
    private boolean processPermission;

    public static QueueSasPermission parse(String permissionString) {
        QueueSasPermission permissions = new QueueSasPermission();
        block6: for (int i = 0; i < permissionString.length(); ++i) {
            char c = permissionString.charAt(i);
            switch (c) {
                case 'r': {
                    permissions.readPermission = true;
                    continue block6;
                }
                case 'a': {
                    permissions.addPermission = true;
                    continue block6;
                }
                case 'u': {
                    permissions.updatePermission = true;
                    continue block6;
                }
                case 'p': {
                    permissions.processPermission = true;
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "%s could not be parsed from '%s' due to invalid value %s.", "Permissions", permissionString, Character.valueOf(c)));
                }
            }
        }
        return permissions;
    }

    public boolean hasReadPermission() {
        return this.readPermission;
    }

    public QueueSasPermission setReadPermission(boolean hasReadPermission) {
        this.readPermission = hasReadPermission;
        return this;
    }

    public boolean hasAddPermission() {
        return this.addPermission;
    }

    public QueueSasPermission setAddPermission(boolean hasAddPermission) {
        this.addPermission = hasAddPermission;
        return this;
    }

    public boolean hasUpdatePermission() {
        return this.updatePermission;
    }

    public QueueSasPermission setUpdatePermission(boolean hasUpdatePermission) {
        this.updatePermission = hasUpdatePermission;
        return this;
    }

    public boolean hasProcessPermission() {
        return this.processPermission;
    }

    public QueueSasPermission setProcessPermission(boolean hasProcessPermission) {
        this.processPermission = hasProcessPermission;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.readPermission) {
            builder.append('r');
        }
        if (this.addPermission) {
            builder.append('a');
        }
        if (this.updatePermission) {
            builder.append('u');
        }
        if (this.processPermission) {
            builder.append('p');
        }
        return builder.toString();
    }
}

