// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Url signing key. */
@Fluent
public final class UrlSigningKey {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(UrlSigningKey.class);

    /*
     * Defines the customer defined key Id. This id will exist in the incoming
     * request to indicate the key used to form the hash.
     */
    @JsonProperty(value = "keyId", required = true)
    private String keyId;

    /*
     * Defines the parameters for using customer key vault for Url Signing Key.
     */
    @JsonProperty(value = "keySourceParameters", required = true)
    private KeyVaultSigningKeyParameters keySourceParameters;

    /**
     * Get the keyId property: Defines the customer defined key Id. This id will exist in the incoming request to
     * indicate the key used to form the hash.
     *
     * @return the keyId value.
     */
    public String keyId() {
        return this.keyId;
    }

    /**
     * Set the keyId property: Defines the customer defined key Id. This id will exist in the incoming request to
     * indicate the key used to form the hash.
     *
     * @param keyId the keyId value to set.
     * @return the UrlSigningKey object itself.
     */
    public UrlSigningKey withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    /**
     * Get the keySourceParameters property: Defines the parameters for using customer key vault for Url Signing Key.
     *
     * @return the keySourceParameters value.
     */
    public KeyVaultSigningKeyParameters keySourceParameters() {
        return this.keySourceParameters;
    }

    /**
     * Set the keySourceParameters property: Defines the parameters for using customer key vault for Url Signing Key.
     *
     * @param keySourceParameters the keySourceParameters value to set.
     * @return the UrlSigningKey object itself.
     */
    public UrlSigningKey withKeySourceParameters(KeyVaultSigningKeyParameters keySourceParameters) {
        this.keySourceParameters = keySourceParameters;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (keyId() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property keyId in model UrlSigningKey"));
        }
        if (keySourceParameters() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property keySourceParameters in model UrlSigningKey"));
        } else {
            keySourceParameters().validate();
        }
    }
}
