/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.OriginResourceState;
import com.azure.resourcemanager.cdn.models.PrivateEndpointStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonFlatten
public class OriginInner
extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(OriginInner.class);
    @JsonProperty(value="properties.hostName")
    private String hostname;
    @JsonProperty(value="properties.httpPort")
    private Integer httpPort;
    @JsonProperty(value="properties.httpsPort")
    private Integer httpsPort;
    @JsonProperty(value="properties.originHostHeader")
    private String originHostHeader;
    @JsonProperty(value="properties.priority")
    private Integer priority;
    @JsonProperty(value="properties.weight")
    private Integer weight;
    @JsonProperty(value="properties.enabled")
    private Boolean enabled;
    @JsonProperty(value="properties.privateLinkAlias")
    private String privateLinkAlias;
    @JsonProperty(value="properties.privateLinkResourceId")
    private String privateLinkResourceId;
    @JsonProperty(value="properties.privateLinkLocation")
    private String privateLinkLocation;
    @JsonProperty(value="properties.privateLinkApprovalMessage")
    private String privateLinkApprovalMessage;
    @JsonProperty(value="properties.resourceState", access=JsonProperty.Access.WRITE_ONLY)
    private OriginResourceState resourceState;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.privateEndpointStatus", access=JsonProperty.Access.WRITE_ONLY)
    private PrivateEndpointStatus privateEndpointStatus;

    public String hostname() {
        return this.hostname;
    }

    public OriginInner withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public Integer httpPort() {
        return this.httpPort;
    }

    public OriginInner withHttpPort(Integer httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    public Integer httpsPort() {
        return this.httpsPort;
    }

    public OriginInner withHttpsPort(Integer httpsPort) {
        this.httpsPort = httpsPort;
        return this;
    }

    public String originHostHeader() {
        return this.originHostHeader;
    }

    public OriginInner withOriginHostHeader(String originHostHeader) {
        this.originHostHeader = originHostHeader;
        return this;
    }

    public Integer priority() {
        return this.priority;
    }

    public OriginInner withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public Integer weight() {
        return this.weight;
    }

    public OriginInner withWeight(Integer weight) {
        this.weight = weight;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public OriginInner withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String privateLinkAlias() {
        return this.privateLinkAlias;
    }

    public OriginInner withPrivateLinkAlias(String privateLinkAlias) {
        this.privateLinkAlias = privateLinkAlias;
        return this;
    }

    public String privateLinkResourceId() {
        return this.privateLinkResourceId;
    }

    public OriginInner withPrivateLinkResourceId(String privateLinkResourceId) {
        this.privateLinkResourceId = privateLinkResourceId;
        return this;
    }

    public String privateLinkLocation() {
        return this.privateLinkLocation;
    }

    public OriginInner withPrivateLinkLocation(String privateLinkLocation) {
        this.privateLinkLocation = privateLinkLocation;
        return this;
    }

    public String privateLinkApprovalMessage() {
        return this.privateLinkApprovalMessage;
    }

    public OriginInner withPrivateLinkApprovalMessage(String privateLinkApprovalMessage) {
        this.privateLinkApprovalMessage = privateLinkApprovalMessage;
        return this;
    }

    public OriginResourceState resourceState() {
        return this.resourceState;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public PrivateEndpointStatus privateEndpointStatus() {
        return this.privateEndpointStatus;
    }

    public void validate() {
    }
}

