/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.ProfileResourceState;
import com.azure.resourcemanager.cdn.models.Sku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

@JsonFlatten
public class ProfileInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ProfileInner.class);
    @JsonProperty(value="sku", required=true)
    private Sku sku;
    @JsonProperty(value="properties.resourceState", access=JsonProperty.Access.WRITE_ONLY)
    private ProfileResourceState resourceState;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;

    public Sku sku() {
        return this.sku;
    }

    public ProfileInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public ProfileResourceState resourceState() {
        return this.resourceState;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public ProfileInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ProfileInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.sku() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sku in model ProfileInner"));
        }
        this.sku().validate();
    }
}

