// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.compute.fluent.GalleryApplicationVersionsClient;
import com.azure.resourcemanager.compute.fluent.models.GalleryApplicationVersionInner;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.GalleryApplicationVersionList;
import com.azure.resourcemanager.compute.models.GalleryApplicationVersionUpdate;
import com.azure.resourcemanager.compute.models.ReplicationStatusTypes;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in GalleryApplicationVersionsClient. */
public final class GalleryApplicationVersionsClientImpl implements GalleryApplicationVersionsClient {
    private final ClientLogger logger = new ClientLogger(GalleryApplicationVersionsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final GalleryApplicationVersionsService service;

    /** The service client containing this operation class. */
    private final ComputeManagementClientImpl client;

    /**
     * Initializes an instance of GalleryApplicationVersionsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    GalleryApplicationVersionsClientImpl(ComputeManagementClientImpl client) {
        this.service =
            RestProxy
                .create(
                    GalleryApplicationVersionsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ComputeManagementClientGalleryApplicationVersions to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ComputeManagementCli")
    private interface GalleryApplicationVersionsService {
        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries"
                + "/{galleryName}/applications/{galleryApplicationName}/versions/{galleryApplicationVersionName}")
        @ExpectedResponses({200, 201, 202})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("galleryName") String galleryName,
            @PathParam("galleryApplicationName") String galleryApplicationName,
            @PathParam("galleryApplicationVersionName") String galleryApplicationVersionName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") GalleryApplicationVersionInner galleryApplicationVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Patch(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries"
                + "/{galleryName}/applications/{galleryApplicationName}/versions/{galleryApplicationVersionName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> update(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("galleryName") String galleryName,
            @PathParam("galleryApplicationName") String galleryApplicationName,
            @PathParam("galleryApplicationVersionName") String galleryApplicationVersionName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") GalleryApplicationVersionUpdate galleryApplicationVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries"
                + "/{galleryName}/applications/{galleryApplicationName}/versions/{galleryApplicationVersionName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<GalleryApplicationVersionInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("galleryName") String galleryName,
            @PathParam("galleryApplicationName") String galleryApplicationName,
            @PathParam("galleryApplicationVersionName") String galleryApplicationVersionName,
            @QueryParam("$expand") ReplicationStatusTypes expand,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries"
                + "/{galleryName}/applications/{galleryApplicationName}/versions/{galleryApplicationVersionName}")
        @ExpectedResponses({200, 202, 204})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("galleryName") String galleryName,
            @PathParam("galleryApplicationName") String galleryApplicationName,
            @PathParam("galleryApplicationVersionName") String galleryApplicationVersionName,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries"
                + "/{galleryName}/applications/{galleryApplicationName}/versions")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<GalleryApplicationVersionList>> listByGalleryApplication(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("galleryName") String galleryName,
            @PathParam("galleryApplicationName") String galleryApplicationName,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<GalleryApplicationVersionList>> listByGalleryApplicationNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);
    }

    /**
     * Create or update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is
     *     to be created.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be created. Needs to follow
     *     semantic version name pattern: The allowed characters are digit and period. Digits must be within the range
     *     of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryApplicationVersion Specifies information about the gallery Application Version that you want to
     *     create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        GalleryApplicationVersionInner galleryApplicationVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryApplicationName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null."));
        }
        if (galleryApplicationVersionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter galleryApplicationVersionName is required and cannot be null."));
        }
        if (galleryApplicationVersion == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter galleryApplicationVersion is required and cannot be null."));
        } else {
            galleryApplicationVersion.validate();
        }
        final String apiVersion = "2019-12-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdate(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            galleryName,
                            galleryApplicationName,
                            galleryApplicationVersionName,
                            apiVersion,
                            galleryApplicationVersion,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create or update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is
     *     to be created.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be created. Needs to follow
     *     semantic version name pattern: The allowed characters are digit and period. Digits must be within the range
     *     of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryApplicationVersion Specifies information about the gallery Application Version that you want to
     *     create or update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        GalleryApplicationVersionInner galleryApplicationVersion,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryApplicationName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null."));
        }
        if (galleryApplicationVersionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter galleryApplicationVersionName is required and cannot be null."));
        }
        if (galleryApplicationVersion == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter galleryApplicationVersion is required and cannot be null."));
        } else {
            galleryApplicationVersion.validate();
        }
        final String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return service
            .createOrUpdate(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                galleryName,
                galleryApplicationName,
                galleryApplicationVersionName,
                apiVersion,
                galleryApplicationVersion,
                context);
    }

    /**
     * Create or update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is
     *     to be created.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be created. Needs to follow
     *     semantic version name pattern: The allowed characters are digit and period. Digits must be within the range
     *     of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryApplicationVersion Specifies information about the gallery Application Version that you want to
     *     create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<GalleryApplicationVersionInner>, GalleryApplicationVersionInner>
        beginCreateOrUpdateAsync(
            String resourceGroupName,
            String galleryName,
            String galleryApplicationName,
            String galleryApplicationVersionName,
            GalleryApplicationVersionInner galleryApplicationVersion) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            createOrUpdateWithResponseAsync(
                resourceGroupName,
                galleryName,
                galleryApplicationName,
                galleryApplicationVersionName,
                galleryApplicationVersion);
        return this
            .client
            .<GalleryApplicationVersionInner, GalleryApplicationVersionInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                GalleryApplicationVersionInner.class,
                GalleryApplicationVersionInner.class,
                Context.NONE);
    }

    /**
     * Create or update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is
     *     to be created.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be created. Needs to follow
     *     semantic version name pattern: The allowed characters are digit and period. Digits must be within the range
     *     of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryApplicationVersion Specifies information about the gallery Application Version that you want to
     *     create or update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<GalleryApplicationVersionInner>, GalleryApplicationVersionInner>
        beginCreateOrUpdateAsync(
            String resourceGroupName,
            String galleryName,
            String galleryApplicationName,
            String galleryApplicationVersionName,
            GalleryApplicationVersionInner galleryApplicationVersion,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            createOrUpdateWithResponseAsync(
                resourceGroupName,
                galleryName,
                galleryApplicationName,
                galleryApplicationVersionName,
                galleryApplicationVersion,
                context);
        return this
            .client
            .<GalleryApplicationVersionInner, GalleryApplicationVersionInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                GalleryApplicationVersionInner.class,
                GalleryApplicationVersionInner.class,
                context);
    }

    /**
     * Create or update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is
     *     to be created.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be created. Needs to follow
     *     semantic version name pattern: The allowed characters are digit and period. Digits must be within the range
     *     of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryApplicationVersion Specifies information about the gallery Application Version that you want to
     *     create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<GalleryApplicationVersionInner>, GalleryApplicationVersionInner> beginCreateOrUpdate(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        GalleryApplicationVersionInner galleryApplicationVersion) {
        return beginCreateOrUpdateAsync(
                resourceGroupName,
                galleryName,
                galleryApplicationName,
                galleryApplicationVersionName,
                galleryApplicationVersion)
            .getSyncPoller();
    }

    /**
     * Create or update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is
     *     to be created.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be created. Needs to follow
     *     semantic version name pattern: The allowed characters are digit and period. Digits must be within the range
     *     of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryApplicationVersion Specifies information about the gallery Application Version that you want to
     *     create or update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<GalleryApplicationVersionInner>, GalleryApplicationVersionInner> beginCreateOrUpdate(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        GalleryApplicationVersionInner galleryApplicationVersion,
        Context context) {
        return beginCreateOrUpdateAsync(
                resourceGroupName,
                galleryName,
                galleryApplicationName,
                galleryApplicationVersionName,
                galleryApplicationVersion,
                context)
            .getSyncPoller();
    }

    /**
     * Create or update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is
     *     to be created.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be created. Needs to follow
     *     semantic version name pattern: The allowed characters are digit and period. Digits must be within the range
     *     of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryApplicationVersion Specifies information about the gallery Application Version that you want to
     *     create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GalleryApplicationVersionInner> createOrUpdateAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        GalleryApplicationVersionInner galleryApplicationVersion) {
        return beginCreateOrUpdateAsync(
                resourceGroupName,
                galleryName,
                galleryApplicationName,
                galleryApplicationVersionName,
                galleryApplicationVersion)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is
     *     to be created.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be created. Needs to follow
     *     semantic version name pattern: The allowed characters are digit and period. Digits must be within the range
     *     of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryApplicationVersion Specifies information about the gallery Application Version that you want to
     *     create or update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<GalleryApplicationVersionInner> createOrUpdateAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        GalleryApplicationVersionInner galleryApplicationVersion,
        Context context) {
        return beginCreateOrUpdateAsync(
                resourceGroupName,
                galleryName,
                galleryApplicationName,
                galleryApplicationVersionName,
                galleryApplicationVersion,
                context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is
     *     to be created.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be created. Needs to follow
     *     semantic version name pattern: The allowed characters are digit and period. Digits must be within the range
     *     of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryApplicationVersion Specifies information about the gallery Application Version that you want to
     *     create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryApplicationVersionInner createOrUpdate(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        GalleryApplicationVersionInner galleryApplicationVersion) {
        return createOrUpdateAsync(
                resourceGroupName,
                galleryName,
                galleryApplicationName,
                galleryApplicationVersionName,
                galleryApplicationVersion)
            .block();
    }

    /**
     * Create or update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is
     *     to be created.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be created. Needs to follow
     *     semantic version name pattern: The allowed characters are digit and period. Digits must be within the range
     *     of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryApplicationVersion Specifies information about the gallery Application Version that you want to
     *     create or update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryApplicationVersionInner createOrUpdate(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        GalleryApplicationVersionInner galleryApplicationVersion,
        Context context) {
        return createOrUpdateAsync(
                resourceGroupName,
                galleryName,
                galleryApplicationName,
                galleryApplicationVersionName,
                galleryApplicationVersion,
                context)
            .block();
    }

    /**
     * Update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is
     *     to be updated.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be updated. Needs to follow
     *     semantic version name pattern: The allowed characters are digit and period. Digits must be within the range
     *     of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryApplicationVersion Specifies information about the gallery Application Version that you want to
     *     update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        GalleryApplicationVersionUpdate galleryApplicationVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryApplicationName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null."));
        }
        if (galleryApplicationVersionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter galleryApplicationVersionName is required and cannot be null."));
        }
        if (galleryApplicationVersion == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter galleryApplicationVersion is required and cannot be null."));
        } else {
            galleryApplicationVersion.validate();
        }
        final String apiVersion = "2019-12-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .update(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            galleryName,
                            galleryApplicationName,
                            galleryApplicationVersionName,
                            apiVersion,
                            galleryApplicationVersion,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is
     *     to be updated.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be updated. Needs to follow
     *     semantic version name pattern: The allowed characters are digit and period. Digits must be within the range
     *     of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryApplicationVersion Specifies information about the gallery Application Version that you want to
     *     update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        GalleryApplicationVersionUpdate galleryApplicationVersion,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryApplicationName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null."));
        }
        if (galleryApplicationVersionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter galleryApplicationVersionName is required and cannot be null."));
        }
        if (galleryApplicationVersion == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter galleryApplicationVersion is required and cannot be null."));
        } else {
            galleryApplicationVersion.validate();
        }
        final String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return service
            .update(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                galleryName,
                galleryApplicationName,
                galleryApplicationVersionName,
                apiVersion,
                galleryApplicationVersion,
                context);
    }

    /**
     * Update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is
     *     to be updated.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be updated. Needs to follow
     *     semantic version name pattern: The allowed characters are digit and period. Digits must be within the range
     *     of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryApplicationVersion Specifies information about the gallery Application Version that you want to
     *     update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<GalleryApplicationVersionInner>, GalleryApplicationVersionInner> beginUpdateAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        GalleryApplicationVersionUpdate galleryApplicationVersion) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateWithResponseAsync(
                resourceGroupName,
                galleryName,
                galleryApplicationName,
                galleryApplicationVersionName,
                galleryApplicationVersion);
        return this
            .client
            .<GalleryApplicationVersionInner, GalleryApplicationVersionInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                GalleryApplicationVersionInner.class,
                GalleryApplicationVersionInner.class,
                Context.NONE);
    }

    /**
     * Update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is
     *     to be updated.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be updated. Needs to follow
     *     semantic version name pattern: The allowed characters are digit and period. Digits must be within the range
     *     of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryApplicationVersion Specifies information about the gallery Application Version that you want to
     *     update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<GalleryApplicationVersionInner>, GalleryApplicationVersionInner> beginUpdateAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        GalleryApplicationVersionUpdate galleryApplicationVersion,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateWithResponseAsync(
                resourceGroupName,
                galleryName,
                galleryApplicationName,
                galleryApplicationVersionName,
                galleryApplicationVersion,
                context);
        return this
            .client
            .<GalleryApplicationVersionInner, GalleryApplicationVersionInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                GalleryApplicationVersionInner.class,
                GalleryApplicationVersionInner.class,
                context);
    }

    /**
     * Update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is
     *     to be updated.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be updated. Needs to follow
     *     semantic version name pattern: The allowed characters are digit and period. Digits must be within the range
     *     of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryApplicationVersion Specifies information about the gallery Application Version that you want to
     *     update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<GalleryApplicationVersionInner>, GalleryApplicationVersionInner> beginUpdate(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        GalleryApplicationVersionUpdate galleryApplicationVersion) {
        return beginUpdateAsync(
                resourceGroupName,
                galleryName,
                galleryApplicationName,
                galleryApplicationVersionName,
                galleryApplicationVersion)
            .getSyncPoller();
    }

    /**
     * Update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is
     *     to be updated.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be updated. Needs to follow
     *     semantic version name pattern: The allowed characters are digit and period. Digits must be within the range
     *     of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryApplicationVersion Specifies information about the gallery Application Version that you want to
     *     update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<GalleryApplicationVersionInner>, GalleryApplicationVersionInner> beginUpdate(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        GalleryApplicationVersionUpdate galleryApplicationVersion,
        Context context) {
        return beginUpdateAsync(
                resourceGroupName,
                galleryName,
                galleryApplicationName,
                galleryApplicationVersionName,
                galleryApplicationVersion,
                context)
            .getSyncPoller();
    }

    /**
     * Update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is
     *     to be updated.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be updated. Needs to follow
     *     semantic version name pattern: The allowed characters are digit and period. Digits must be within the range
     *     of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryApplicationVersion Specifies information about the gallery Application Version that you want to
     *     update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GalleryApplicationVersionInner> updateAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        GalleryApplicationVersionUpdate galleryApplicationVersion) {
        return beginUpdateAsync(
                resourceGroupName,
                galleryName,
                galleryApplicationName,
                galleryApplicationVersionName,
                galleryApplicationVersion)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is
     *     to be updated.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be updated. Needs to follow
     *     semantic version name pattern: The allowed characters are digit and period. Digits must be within the range
     *     of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryApplicationVersion Specifies information about the gallery Application Version that you want to
     *     update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<GalleryApplicationVersionInner> updateAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        GalleryApplicationVersionUpdate galleryApplicationVersion,
        Context context) {
        return beginUpdateAsync(
                resourceGroupName,
                galleryName,
                galleryApplicationName,
                galleryApplicationVersionName,
                galleryApplicationVersion,
                context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is
     *     to be updated.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be updated. Needs to follow
     *     semantic version name pattern: The allowed characters are digit and period. Digits must be within the range
     *     of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryApplicationVersion Specifies information about the gallery Application Version that you want to
     *     update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryApplicationVersionInner update(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        GalleryApplicationVersionUpdate galleryApplicationVersion) {
        return updateAsync(
                resourceGroupName,
                galleryName,
                galleryApplicationName,
                galleryApplicationVersionName,
                galleryApplicationVersion)
            .block();
    }

    /**
     * Update a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version is
     *     to be updated.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be updated. Needs to follow
     *     semantic version name pattern: The allowed characters are digit and period. Digits must be within the range
     *     of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryApplicationVersion Specifies information about the gallery Application Version that you want to
     *     update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryApplicationVersionInner update(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        GalleryApplicationVersionUpdate galleryApplicationVersion,
        Context context) {
        return updateAsync(
                resourceGroupName,
                galleryName,
                galleryApplicationName,
                galleryApplicationVersionName,
                galleryApplicationVersion,
                context)
            .block();
    }

    /**
     * Retrieves information about a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version
     *     resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be retrieved.
     * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<GalleryApplicationVersionInner>> getWithResponseAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        ReplicationStatusTypes expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryApplicationName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null."));
        }
        if (galleryApplicationVersionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter galleryApplicationVersionName is required and cannot be null."));
        }
        final String apiVersion = "2019-12-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            galleryName,
                            galleryApplicationName,
                            galleryApplicationVersionName,
                            expand,
                            apiVersion,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Retrieves information about a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version
     *     resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be retrieved.
     * @param expand The expand expression to apply on the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<GalleryApplicationVersionInner>> getWithResponseAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        ReplicationStatusTypes expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryApplicationName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null."));
        }
        if (galleryApplicationVersionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter galleryApplicationVersionName is required and cannot be null."));
        }
        final String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                galleryName,
                galleryApplicationName,
                galleryApplicationVersionName,
                expand,
                apiVersion,
                context);
    }

    /**
     * Retrieves information about a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version
     *     resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be retrieved.
     * @param expand The expand expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GalleryApplicationVersionInner> getAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        ReplicationStatusTypes expand) {
        return getWithResponseAsync(
                resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, expand)
            .flatMap(
                (Response<GalleryApplicationVersionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Retrieves information about a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version
     *     resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GalleryApplicationVersionInner> getAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName) {
        final ReplicationStatusTypes expand = null;
        return getWithResponseAsync(
                resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, expand)
            .flatMap(
                (Response<GalleryApplicationVersionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Retrieves information about a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version
     *     resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryApplicationVersionInner get(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName) {
        final ReplicationStatusTypes expand = null;
        return getAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, expand)
            .block();
    }

    /**
     * Retrieves information about a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version
     *     resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be retrieved.
     * @param expand The expand expression to apply on the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<GalleryApplicationVersionInner> getWithResponse(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        ReplicationStatusTypes expand,
        Context context) {
        return getWithResponseAsync(
                resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, expand, context)
            .block();
    }

    /**
     * Delete a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version
     *     resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryApplicationName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null."));
        }
        if (galleryApplicationVersionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter galleryApplicationVersionName is required and cannot be null."));
        }
        final String apiVersion = "2019-12-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            galleryName,
                            galleryApplicationName,
                            galleryApplicationVersionName,
                            apiVersion,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version
     *     resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryApplicationName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null."));
        }
        if (galleryApplicationVersionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter galleryApplicationVersionName is required and cannot be null."));
        }
        final String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                galleryName,
                galleryApplicationName,
                galleryApplicationVersionName,
                apiVersion,
                context);
    }

    /**
     * Delete a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version
     *     resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(
                resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, Context.NONE);
    }

    /**
     * Delete a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version
     *     resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(
                resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Delete a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version
     *     resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName) {
        return beginDeleteAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName)
            .getSyncPoller();
    }

    /**
     * Delete a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version
     *     resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        Context context) {
        return beginDeleteAsync(
                resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, context)
            .getSyncPoller();
    }

    /**
     * Delete a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version
     *     resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName) {
        return beginDeleteAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version
     *     resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        Context context) {
        return beginDeleteAsync(
                resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version
     *     resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName) {
        deleteAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName).block();
    }

    /**
     * Delete a gallery Application Version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the gallery Application Definition in which the Application Version
     *     resides.
     * @param galleryApplicationVersionName The name of the gallery Application Version to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        String galleryApplicationVersionName,
        Context context) {
        deleteAsync(resourceGroupName, galleryName, galleryApplicationName, galleryApplicationVersionName, context)
            .block();
    }

    /**
     * List gallery Application Versions in a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the Shared Application Gallery Application Definition from which the
     *     Application Versions are to be listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Application version operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryApplicationVersionInner>> listByGalleryApplicationSinglePageAsync(
        String resourceGroupName, String galleryName, String galleryApplicationName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryApplicationName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null."));
        }
        final String apiVersion = "2019-12-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByGalleryApplication(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            galleryName,
                            galleryApplicationName,
                            apiVersion,
                            context))
            .<PagedResponse<GalleryApplicationVersionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * List gallery Application Versions in a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the Shared Application Gallery Application Definition from which the
     *     Application Versions are to be listed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Application version operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryApplicationVersionInner>> listByGalleryApplicationSinglePageAsync(
        String resourceGroupName, String galleryName, String galleryApplicationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryApplicationName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter galleryApplicationName is required and cannot be null."));
        }
        final String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return service
            .listByGalleryApplication(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                galleryName,
                galleryApplicationName,
                apiVersion,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * List gallery Application Versions in a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the Shared Application Gallery Application Definition from which the
     *     Application Versions are to be listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Application version operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<GalleryApplicationVersionInner> listByGalleryApplicationAsync(
        String resourceGroupName, String galleryName, String galleryApplicationName) {
        return new PagedFlux<>(
            () -> listByGalleryApplicationSinglePageAsync(resourceGroupName, galleryName, galleryApplicationName),
            nextLink -> listByGalleryApplicationNextSinglePageAsync(nextLink));
    }

    /**
     * List gallery Application Versions in a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the Shared Application Gallery Application Definition from which the
     *     Application Versions are to be listed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Application version operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<GalleryApplicationVersionInner> listByGalleryApplicationAsync(
        String resourceGroupName, String galleryName, String galleryApplicationName, Context context) {
        return new PagedFlux<>(
            () ->
                listByGalleryApplicationSinglePageAsync(
                    resourceGroupName, galleryName, galleryApplicationName, context),
            nextLink -> listByGalleryApplicationNextSinglePageAsync(nextLink, context));
    }

    /**
     * List gallery Application Versions in a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the Shared Application Gallery Application Definition from which the
     *     Application Versions are to be listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Application version operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GalleryApplicationVersionInner> listByGalleryApplication(
        String resourceGroupName, String galleryName, String galleryApplicationName) {
        return new PagedIterable<>(
            listByGalleryApplicationAsync(resourceGroupName, galleryName, galleryApplicationName));
    }

    /**
     * List gallery Application Versions in a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition resides.
     * @param galleryApplicationName The name of the Shared Application Gallery Application Definition from which the
     *     Application Versions are to be listed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Application version operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GalleryApplicationVersionInner> listByGalleryApplication(
        String resourceGroupName, String galleryName, String galleryApplicationName, Context context) {
        return new PagedIterable<>(
            listByGalleryApplicationAsync(resourceGroupName, galleryName, galleryApplicationName, context));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Application version operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryApplicationVersionInner>> listByGalleryApplicationNextSinglePageAsync(
        String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listByGalleryApplicationNext(nextLink, context))
            .<PagedResponse<GalleryApplicationVersionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Application version operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryApplicationVersionInner>> listByGalleryApplicationNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listByGalleryApplicationNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
