// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Key Vault Secret Url and vault id of the encryption key. */
@Fluent
public final class KeyVaultAndSecretReference {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(KeyVaultAndSecretReference.class);

    /*
     * Resource id of the KeyVault containing the key or secret
     */
    @JsonProperty(value = "sourceVault", required = true)
    private SourceVault sourceVault;

    /*
     * Url pointing to a key or secret in KeyVault
     */
    @JsonProperty(value = "secretUrl", required = true)
    private String secretUrl;

    /**
     * Get the sourceVault property: Resource id of the KeyVault containing the key or secret.
     *
     * @return the sourceVault value.
     */
    public SourceVault sourceVault() {
        return this.sourceVault;
    }

    /**
     * Set the sourceVault property: Resource id of the KeyVault containing the key or secret.
     *
     * @param sourceVault the sourceVault value to set.
     * @return the KeyVaultAndSecretReference object itself.
     */
    public KeyVaultAndSecretReference withSourceVault(SourceVault sourceVault) {
        this.sourceVault = sourceVault;
        return this;
    }

    /**
     * Get the secretUrl property: Url pointing to a key or secret in KeyVault.
     *
     * @return the secretUrl value.
     */
    public String secretUrl() {
        return this.secretUrl;
    }

    /**
     * Set the secretUrl property: Url pointing to a key or secret in KeyVault.
     *
     * @param secretUrl the secretUrl value to set.
     * @return the KeyVaultAndSecretReference object itself.
     */
    public KeyVaultAndSecretReference withSecretUrl(String secretUrl) {
        this.secretUrl = secretUrl;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sourceVault() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property sourceVault in model KeyVaultAndSecretReference"));
        } else {
            sourceVault().validate();
        }
        if (secretUrl() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property secretUrl in model KeyVaultAndSecretReference"));
        }
    }
}
