/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.azure.resourcemanager.compute.fluent.GalleriesClient;
import com.azure.resourcemanager.compute.fluent.models.GalleryInner;
import com.azure.resourcemanager.compute.implementation.GalleryImpl;
import com.azure.resourcemanager.compute.models.Galleries;
import com.azure.resourcemanager.compute.models.Gallery;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.BatchDeletionImpl;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GalleriesImpl
extends GroupableResourcesImpl<Gallery, GalleryImpl, GalleryInner, GalleriesClient, ComputeManager>
implements Galleries {
    public GalleriesImpl(ComputeManager manager) {
        super((Object)((ComputeManagementClient)manager.serviceClient()).getGalleries(), (Manager)manager);
    }

    protected Mono<GalleryInner> getInnerAsync(String resourceGroupName, String name) {
        return ((GalleriesClient)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    protected Mono<Void> deleteInnerAsync(String resourceGroupName, String name) {
        return ((GalleriesClient)this.inner()).deleteAsync(resourceGroupName, name);
    }

    public Flux<String> deleteByIdsAsync(Collection<String> ids) {
        return BatchDeletionImpl.deleteByIdsAsync(ids, this::deleteInnerAsync);
    }

    public Flux<String> deleteByIdsAsync(String ... ids) {
        return this.deleteByIdsAsync(new ArrayList<String>(Arrays.asList(ids)));
    }

    public void deleteByIds(Collection<String> ids) {
        if (ids != null && !ids.isEmpty()) {
            this.deleteByIdsAsync(ids).last().block();
        }
    }

    public void deleteByIds(String ... ids) {
        this.deleteByIds(new ArrayList<String>(Arrays.asList(ids)));
    }

    public PagedIterable<Gallery> listByResourceGroup(String resourceGroupName) {
        return this.wrapList(((GalleriesClient)this.inner()).listByResourceGroup(resourceGroupName));
    }

    public PagedFlux<Gallery> listByResourceGroupAsync(String resourceGroupName) {
        return ((GalleriesClient)this.inner()).listByResourceGroupAsync(resourceGroupName).mapPage(this::wrapModel);
    }

    public PagedIterable<Gallery> list() {
        return this.wrapList(((GalleriesClient)this.inner()).list());
    }

    public PagedFlux<Gallery> listAsync() {
        return ((GalleriesClient)this.inner()).listAsync().mapPage(this::wrapModel);
    }

    public GalleryImpl define(String name) {
        return this.wrapModel(name);
    }

    protected GalleryImpl wrapModel(GalleryInner inner) {
        return new GalleryImpl(inner.name(), inner, (ComputeManager)this.manager());
    }

    protected GalleryImpl wrapModel(String name) {
        return new GalleryImpl(name, new GalleryInner(), (ComputeManager)this.manager());
    }
}

