/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineExtensionInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineInner;
import com.azure.resourcemanager.compute.implementation.EncryptionExtensionIdentifier;
import com.azure.resourcemanager.compute.implementation.LinuxDiskVolumeLegacyEncryptionMonitorImpl;
import com.azure.resourcemanager.compute.implementation.LinuxDiskVolumeNoAADEncryptionMonitorImpl;
import com.azure.resourcemanager.compute.implementation.WindowsVolumeLegacyEncryptionMonitorImpl;
import com.azure.resourcemanager.compute.implementation.WindowsVolumeNoAADEncryptionMonitorImpl;
import com.azure.resourcemanager.compute.models.DiskVolumeEncryptionMonitor;
import com.azure.resourcemanager.compute.models.EncryptionStatus;
import com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.VirtualMachine;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import java.util.HashMap;
import java.util.Map;
import reactor.core.publisher.Mono;

class ProxyEncryptionMonitorImpl
implements DiskVolumeEncryptionMonitor {
    private final String vmId;
    private final OperatingSystemTypes osType;
    private final ComputeManager computeManager;
    private DiskVolumeEncryptionMonitor resolvedEncryptionMonitor;

    ProxyEncryptionMonitorImpl(VirtualMachine virtualMachine) {
        this.vmId = virtualMachine.id();
        this.osType = virtualMachine.osType();
        this.computeManager = (ComputeManager)((Object)virtualMachine.manager());
    }

    @Override
    public OperatingSystemTypes osType() {
        return this.osType;
    }

    @Override
    public String progressMessage() {
        return this.resolvedEncryptionMonitor != null ? this.resolvedEncryptionMonitor.progressMessage() : null;
    }

    @Override
    public EncryptionStatus osDiskStatus() {
        return this.resolvedEncryptionMonitor != null ? this.resolvedEncryptionMonitor.osDiskStatus() : EncryptionStatus.NOT_ENCRYPTED;
    }

    @Override
    public EncryptionStatus dataDiskStatus() {
        return this.resolvedEncryptionMonitor != null ? this.resolvedEncryptionMonitor.dataDiskStatus() : EncryptionStatus.NOT_ENCRYPTED;
    }

    @Override
    public Map<String, InstanceViewStatus> diskInstanceViewEncryptionStatuses() {
        return this.resolvedEncryptionMonitor != null ? this.resolvedEncryptionMonitor.diskInstanceViewEncryptionStatuses() : new HashMap();
    }

    public DiskVolumeEncryptionMonitor refresh() {
        return (DiskVolumeEncryptionMonitor)this.refreshAsync().block();
    }

    @Override
    public Mono<DiskVolumeEncryptionMonitor> refreshAsync() {
        if (this.resolvedEncryptionMonitor != null) {
            return this.resolvedEncryptionMonitor.refreshAsync();
        }
        ProxyEncryptionMonitorImpl self = this;
        return this.retrieveVirtualMachineAsync().flatMap(virtualMachine -> {
            VirtualMachineExtensionInner extension = this.encryptionExtension((VirtualMachineInner)((Object)virtualMachine));
            self.resolvedEncryptionMonitor = EncryptionExtensionIdentifier.isNoAADVersion(this.osType(), extension.typeHandlerVersion()) ? (this.osType() == OperatingSystemTypes.LINUX ? new LinuxDiskVolumeNoAADEncryptionMonitorImpl(virtualMachine.id(), this.computeManager) : new WindowsVolumeNoAADEncryptionMonitorImpl(virtualMachine.id(), this.computeManager)) : (this.osType() == OperatingSystemTypes.LINUX ? new LinuxDiskVolumeLegacyEncryptionMonitorImpl(virtualMachine.id(), this.computeManager) : new WindowsVolumeLegacyEncryptionMonitorImpl(virtualMachine.id(), this.computeManager));
            return self.resolvedEncryptionMonitor.refreshAsync();
        }).switchIfEmpty(Mono.just((Object)self));
    }

    private Mono<VirtualMachineInner> retrieveVirtualMachineAsync() {
        return ((ComputeManagementClient)this.computeManager.serviceClient()).getVirtualMachines().getByResourceGroupAsync(ResourceUtils.groupFromResourceId((String)this.vmId), ResourceUtils.nameFromResourceId((String)this.vmId));
    }

    private VirtualMachineExtensionInner encryptionExtension(VirtualMachineInner vm) {
        if (vm.resources() != null) {
            for (VirtualMachineExtensionInner extension : vm.resources()) {
                if (!EncryptionExtensionIdentifier.isEncryptionPublisherName(extension.publisher()) || !EncryptionExtensionIdentifier.isEncryptionTypeName(extension.typePropertiesType(), this.osType())) continue;
                return extension;
            }
        }
        return null;
    }
}

