/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.resourcemanager.compute.implementation.ProxyEncryptionMonitorImpl;
import com.azure.resourcemanager.compute.implementation.VirtualMachineEncryptionHelper;
import com.azure.resourcemanager.compute.models.DiskVolumeEncryptionMonitor;
import com.azure.resourcemanager.compute.models.DiskVolumeType;
import com.azure.resourcemanager.compute.models.LinuxVMDiskEncryptionConfiguration;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.VirtualMachine;
import com.azure.resourcemanager.compute.models.VirtualMachineEncryption;
import com.azure.resourcemanager.compute.models.WindowsVMDiskEncryptionConfiguration;
import reactor.core.publisher.Mono;

class VirtualMachineEncryptionImpl
implements VirtualMachineEncryption {
    private final VirtualMachine virtualMachine;
    private final VirtualMachineEncryptionHelper virtualMachineEncryptionHelper;

    VirtualMachineEncryptionImpl(VirtualMachine virtualMachine) {
        this.virtualMachine = virtualMachine;
        this.virtualMachineEncryptionHelper = new VirtualMachineEncryptionHelper(virtualMachine);
    }

    @Override
    public Mono<DiskVolumeEncryptionMonitor> enableAsync(String keyVaultId, String aadClientId, String aadSecret) {
        if (this.virtualMachine.osType() == OperatingSystemTypes.LINUX) {
            return this.enableAsync(new LinuxVMDiskEncryptionConfiguration(keyVaultId, aadClientId, aadSecret));
        }
        return this.enableAsync(new WindowsVMDiskEncryptionConfiguration(keyVaultId, aadClientId, aadSecret));
    }

    @Override
    public Mono<DiskVolumeEncryptionMonitor> enableAsync(String keyVaultId) {
        if (this.virtualMachine.osType() == OperatingSystemTypes.LINUX) {
            return this.enableAsync(new LinuxVMDiskEncryptionConfiguration(keyVaultId));
        }
        return this.enableAsync(new WindowsVMDiskEncryptionConfiguration(keyVaultId));
    }

    @Override
    public Mono<DiskVolumeEncryptionMonitor> enableAsync(WindowsVMDiskEncryptionConfiguration encryptionSettings) {
        return this.virtualMachineEncryptionHelper.enableEncryptionAsync(encryptionSettings);
    }

    @Override
    public Mono<DiskVolumeEncryptionMonitor> enableAsync(LinuxVMDiskEncryptionConfiguration encryptionSettings) {
        return this.virtualMachineEncryptionHelper.enableEncryptionAsync(encryptionSettings);
    }

    @Override
    public Mono<DiskVolumeEncryptionMonitor> disableAsync(DiskVolumeType volumeType) {
        return this.virtualMachineEncryptionHelper.disableEncryptionAsync(volumeType);
    }

    @Override
    public Mono<DiskVolumeEncryptionMonitor> getMonitorAsync() {
        return new ProxyEncryptionMonitorImpl(this.virtualMachine).refreshAsync();
    }

    @Override
    public DiskVolumeEncryptionMonitor enable(String keyVaultId, String aadClientId, String aadSecret) {
        return (DiskVolumeEncryptionMonitor)this.enableAsync(keyVaultId, aadClientId, aadSecret).block();
    }

    @Override
    public DiskVolumeEncryptionMonitor enable(WindowsVMDiskEncryptionConfiguration encryptionSettings) {
        return (DiskVolumeEncryptionMonitor)this.enableAsync(encryptionSettings).block();
    }

    @Override
    public DiskVolumeEncryptionMonitor enable(LinuxVMDiskEncryptionConfiguration encryptionSettings) {
        return (DiskVolumeEncryptionMonitor)this.enableAsync(encryptionSettings).block();
    }

    @Override
    public DiskVolumeEncryptionMonitor disable(DiskVolumeType volumeType) {
        return (DiskVolumeEncryptionMonitor)this.disableAsync(volumeType).block();
    }

    @Override
    public DiskVolumeEncryptionMonitor getMonitor() {
        return (DiskVolumeEncryptionMonitor)this.getMonitorAsync().block();
    }
}

