/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.ContainerServiceVMSizeTypes;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ContainerServiceAgentPoolProfile {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ContainerServiceAgentPoolProfile.class);
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="count", required=true)
    private int count;
    @JsonProperty(value="vmSize", required=true)
    private ContainerServiceVMSizeTypes vmSize;
    @JsonProperty(value="dnsPrefix", required=true)
    private String dnsPrefix;
    @JsonProperty(value="fqdn", access=JsonProperty.Access.WRITE_ONLY)
    private String fqdn;

    public String name() {
        return this.name;
    }

    public ContainerServiceAgentPoolProfile withName(String name) {
        this.name = name;
        return this;
    }

    public int count() {
        return this.count;
    }

    public ContainerServiceAgentPoolProfile withCount(int count) {
        this.count = count;
        return this;
    }

    public ContainerServiceVMSizeTypes vmSize() {
        return this.vmSize;
    }

    public ContainerServiceAgentPoolProfile withVmSize(ContainerServiceVMSizeTypes vmSize) {
        this.vmSize = vmSize;
        return this;
    }

    public String dnsPrefix() {
        return this.dnsPrefix;
    }

    public ContainerServiceAgentPoolProfile withDnsPrefix(String dnsPrefix) {
        this.dnsPrefix = dnsPrefix;
        return this;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public void validate() {
        if (this.name() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model ContainerServiceAgentPoolProfile"));
        }
        if (this.vmSize() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property vmSize in model ContainerServiceAgentPoolProfile"));
        }
        if (this.dnsPrefix() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property dnsPrefix in model ContainerServiceAgentPoolProfile"));
        }
    }
}

