/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.DiskEncryptionSettings;
import com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class DiskInstanceView {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DiskInstanceView.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="encryptionSettings")
    private List<DiskEncryptionSettings> encryptionSettings;
    @JsonProperty(value="statuses")
    private List<InstanceViewStatus> statuses;

    public String name() {
        return this.name;
    }

    public DiskInstanceView withName(String name) {
        this.name = name;
        return this;
    }

    public List<DiskEncryptionSettings> encryptionSettings() {
        return this.encryptionSettings;
    }

    public DiskInstanceView withEncryptionSettings(List<DiskEncryptionSettings> encryptionSettings) {
        this.encryptionSettings = encryptionSettings;
        return this;
    }

    public List<InstanceViewStatus> statuses() {
        return this.statuses;
    }

    public DiskInstanceView withStatuses(List<InstanceViewStatus> statuses) {
        this.statuses = statuses;
        return this;
    }

    public void validate() {
        if (this.encryptionSettings() != null) {
            this.encryptionSettings().forEach(e -> e.validate());
        }
        if (this.statuses() != null) {
            this.statuses().forEach(e -> e.validate());
        }
    }
}

