/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.resourcemanager.compute.models.ImageReference;

public enum KnownWindowsVirtualMachineImage {
    WINDOWS_DESKTOP_10_20H1_PRO("MicrosoftWindowsDesktop", "Windows-10", "20h1-pro"),
    WINDOWS_SERVER_2019_DATACENTER("MicrosoftWindowsServer", "WindowsServer", "2019-Datacenter"),
    WINDOWS_SERVER_2019_DATACENTER_WITH_CONTAINERS("MicrosoftWindowsServer", "WindowsServer", "2019-Datacenter-with-Containers"),
    WINDOWS_SERVER_2016_DATACENTER("MicrosoftWindowsServer", "WindowsServer", "2016-Datacenter"),
    WINDOWS_SERVER_2012_R2_DATACENTER("MicrosoftWindowsServer", "WindowsServer", "2012-R2-Datacenter");

    private final String publisher;
    private final String offer;
    private final String sku;

    private KnownWindowsVirtualMachineImage(String publisher, String offer, String sku) {
        this.publisher = publisher;
        this.offer = offer;
        this.sku = sku;
    }

    public String publisher() {
        return this.publisher;
    }

    public String offer() {
        return this.offer;
    }

    public String sku() {
        return this.sku;
    }

    public ImageReference imageReference() {
        return new ImageReference().withPublisher(this.publisher()).withOffer(this.offer()).withSku(this.sku()).withVersion("latest");
    }
}

