/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.AdditionalCapabilities;
import com.azure.resourcemanager.compute.models.AutomaticRepairsPolicy;
import com.azure.resourcemanager.compute.models.Plan;
import com.azure.resourcemanager.compute.models.ScaleInPolicy;
import com.azure.resourcemanager.compute.models.Sku;
import com.azure.resourcemanager.compute.models.UpdateResource;
import com.azure.resourcemanager.compute.models.UpgradePolicy;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetIdentity;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetUpdateVMProfile;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonFlatten
public class VirtualMachineScaleSetUpdate
extends UpdateResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualMachineScaleSetUpdate.class);
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="plan")
    private Plan plan;
    @JsonProperty(value="identity")
    private VirtualMachineScaleSetIdentity identity;
    @JsonProperty(value="properties.upgradePolicy")
    private UpgradePolicy upgradePolicy;
    @JsonProperty(value="properties.automaticRepairsPolicy")
    private AutomaticRepairsPolicy automaticRepairsPolicy;
    @JsonProperty(value="properties.virtualMachineProfile")
    private VirtualMachineScaleSetUpdateVMProfile virtualMachineProfile;
    @JsonProperty(value="properties.overprovision")
    private Boolean overprovision;
    @JsonProperty(value="properties.doNotRunExtensionsOnOverprovisionedVMs")
    private Boolean doNotRunExtensionsOnOverprovisionedVMs;
    @JsonProperty(value="properties.singlePlacementGroup")
    private Boolean singlePlacementGroup;
    @JsonProperty(value="properties.additionalCapabilities")
    private AdditionalCapabilities additionalCapabilities;
    @JsonProperty(value="properties.scaleInPolicy")
    private ScaleInPolicy scaleInPolicy;
    @JsonProperty(value="properties.proximityPlacementGroup")
    private SubResource proximityPlacementGroup;

    public Sku sku() {
        return this.sku;
    }

    public VirtualMachineScaleSetUpdate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Plan plan() {
        return this.plan;
    }

    public VirtualMachineScaleSetUpdate withPlan(Plan plan) {
        this.plan = plan;
        return this;
    }

    public VirtualMachineScaleSetIdentity identity() {
        return this.identity;
    }

    public VirtualMachineScaleSetUpdate withIdentity(VirtualMachineScaleSetIdentity identity) {
        this.identity = identity;
        return this;
    }

    public UpgradePolicy upgradePolicy() {
        return this.upgradePolicy;
    }

    public VirtualMachineScaleSetUpdate withUpgradePolicy(UpgradePolicy upgradePolicy) {
        this.upgradePolicy = upgradePolicy;
        return this;
    }

    public AutomaticRepairsPolicy automaticRepairsPolicy() {
        return this.automaticRepairsPolicy;
    }

    public VirtualMachineScaleSetUpdate withAutomaticRepairsPolicy(AutomaticRepairsPolicy automaticRepairsPolicy) {
        this.automaticRepairsPolicy = automaticRepairsPolicy;
        return this;
    }

    public VirtualMachineScaleSetUpdateVMProfile virtualMachineProfile() {
        return this.virtualMachineProfile;
    }

    public VirtualMachineScaleSetUpdate withVirtualMachineProfile(VirtualMachineScaleSetUpdateVMProfile virtualMachineProfile) {
        this.virtualMachineProfile = virtualMachineProfile;
        return this;
    }

    public Boolean overprovision() {
        return this.overprovision;
    }

    public VirtualMachineScaleSetUpdate withOverprovision(Boolean overprovision) {
        this.overprovision = overprovision;
        return this;
    }

    public Boolean doNotRunExtensionsOnOverprovisionedVMs() {
        return this.doNotRunExtensionsOnOverprovisionedVMs;
    }

    public VirtualMachineScaleSetUpdate withDoNotRunExtensionsOnOverprovisionedVMs(Boolean doNotRunExtensionsOnOverprovisionedVMs) {
        this.doNotRunExtensionsOnOverprovisionedVMs = doNotRunExtensionsOnOverprovisionedVMs;
        return this;
    }

    public Boolean singlePlacementGroup() {
        return this.singlePlacementGroup;
    }

    public VirtualMachineScaleSetUpdate withSinglePlacementGroup(Boolean singlePlacementGroup) {
        this.singlePlacementGroup = singlePlacementGroup;
        return this;
    }

    public AdditionalCapabilities additionalCapabilities() {
        return this.additionalCapabilities;
    }

    public VirtualMachineScaleSetUpdate withAdditionalCapabilities(AdditionalCapabilities additionalCapabilities) {
        this.additionalCapabilities = additionalCapabilities;
        return this;
    }

    public ScaleInPolicy scaleInPolicy() {
        return this.scaleInPolicy;
    }

    public VirtualMachineScaleSetUpdate withScaleInPolicy(ScaleInPolicy scaleInPolicy) {
        this.scaleInPolicy = scaleInPolicy;
        return this;
    }

    public SubResource proximityPlacementGroup() {
        return this.proximityPlacementGroup;
    }

    public VirtualMachineScaleSetUpdate withProximityPlacementGroup(SubResource proximityPlacementGroup) {
        this.proximityPlacementGroup = proximityPlacementGroup;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.plan() != null) {
            this.plan().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.upgradePolicy() != null) {
            this.upgradePolicy().validate();
        }
        if (this.automaticRepairsPolicy() != null) {
            this.automaticRepairsPolicy().validate();
        }
        if (this.virtualMachineProfile() != null) {
            this.virtualMachineProfile().validate();
        }
        if (this.additionalCapabilities() != null) {
            this.additionalCapabilities().validate();
        }
        if (this.scaleInPolicy() != null) {
            this.scaleInPolicy().validate();
        }
    }
}

