// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.redis.fluent.models.NotificationListResponseInner;
import com.azure.resourcemanager.redis.fluent.models.RedisAccessKeysInner;
import com.azure.resourcemanager.redis.fluent.models.RedisForceRebootResponseInner;
import com.azure.resourcemanager.redis.fluent.models.RedisResourceInner;
import com.azure.resourcemanager.redis.models.CheckNameAvailabilityParameters;
import com.azure.resourcemanager.redis.models.ExportRdbParameters;
import com.azure.resourcemanager.redis.models.ImportRdbParameters;
import com.azure.resourcemanager.redis.models.RedisCreateParameters;
import com.azure.resourcemanager.redis.models.RedisKeyType;
import com.azure.resourcemanager.redis.models.RedisRebootParameters;
import com.azure.resourcemanager.redis.models.RedisUpdateParameters;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in RedisClient. */
public interface RedisClient
    extends InnerSupportsGet<RedisResourceInner>, InnerSupportsListing<RedisResourceInner>, InnerSupportsDelete<Void> {
    /**
     * Checks that the redis cache name is valid and is not already in use.
     *
     * @param parameters Parameters body to pass for resource name availability check.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> checkNameAvailabilityWithResponseAsync(CheckNameAvailabilityParameters parameters);

    /**
     * Checks that the redis cache name is valid and is not already in use.
     *
     * @param parameters Parameters body to pass for resource name availability check.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> checkNameAvailabilityAsync(CheckNameAvailabilityParameters parameters);

    /**
     * Checks that the redis cache name is valid and is not already in use.
     *
     * @param parameters Parameters body to pass for resource name availability check.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void checkNameAvailability(CheckNameAvailabilityParameters parameters);

    /**
     * Checks that the redis cache name is valid and is not already in use.
     *
     * @param parameters Parameters body to pass for resource name availability check.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> checkNameAvailabilityWithResponse(CheckNameAvailabilityParameters parameters, Context context);

    /**
     * Gets any upgrade notifications for a Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param history how many minutes in past to look for upgrade notifications.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any upgrade notifications for a Redis cache.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<NotificationListResponseInner>> listUpgradeNotificationsWithResponseAsync(
        String resourceGroupName, String name, double history);

    /**
     * Gets any upgrade notifications for a Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param history how many minutes in past to look for upgrade notifications.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any upgrade notifications for a Redis cache.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<NotificationListResponseInner> listUpgradeNotificationsAsync(
        String resourceGroupName, String name, double history);

    /**
     * Gets any upgrade notifications for a Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param history how many minutes in past to look for upgrade notifications.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any upgrade notifications for a Redis cache.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NotificationListResponseInner listUpgradeNotifications(String resourceGroupName, String name, double history);

    /**
     * Gets any upgrade notifications for a Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param history how many minutes in past to look for upgrade notifications.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any upgrade notifications for a Redis cache.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<NotificationListResponseInner> listUpgradeNotificationsWithResponse(
        String resourceGroupName, String name, double history, Context context);

    /**
     * Create or replace (overwrite/recreate, with potential downtime) an existing Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Parameters supplied to the Create Redis operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single Redis item in List or Get Operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(
        String resourceGroupName, String name, RedisCreateParameters parameters);

    /**
     * Create or replace (overwrite/recreate, with potential downtime) an existing Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Parameters supplied to the Create Redis operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single Redis item in List or Get Operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<RedisResourceInner>, RedisResourceInner> beginCreateAsync(
        String resourceGroupName, String name, RedisCreateParameters parameters);

    /**
     * Create or replace (overwrite/recreate, with potential downtime) an existing Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Parameters supplied to the Create Redis operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single Redis item in List or Get Operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<RedisResourceInner>, RedisResourceInner> beginCreate(
        String resourceGroupName, String name, RedisCreateParameters parameters);

    /**
     * Create or replace (overwrite/recreate, with potential downtime) an existing Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Parameters supplied to the Create Redis operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single Redis item in List or Get Operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<RedisResourceInner>, RedisResourceInner> beginCreate(
        String resourceGroupName, String name, RedisCreateParameters parameters, Context context);

    /**
     * Create or replace (overwrite/recreate, with potential downtime) an existing Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Parameters supplied to the Create Redis operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single Redis item in List or Get Operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RedisResourceInner> createAsync(String resourceGroupName, String name, RedisCreateParameters parameters);

    /**
     * Create or replace (overwrite/recreate, with potential downtime) an existing Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Parameters supplied to the Create Redis operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single Redis item in List or Get Operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RedisResourceInner create(String resourceGroupName, String name, RedisCreateParameters parameters);

    /**
     * Create or replace (overwrite/recreate, with potential downtime) an existing Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Parameters supplied to the Create Redis operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single Redis item in List or Get Operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RedisResourceInner create(String resourceGroupName, String name, RedisCreateParameters parameters, Context context);

    /**
     * Update an existing Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Parameters supplied to the Update Redis operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single Redis item in List or Get Operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RedisResourceInner>> updateWithResponseAsync(
        String resourceGroupName, String name, RedisUpdateParameters parameters);

    /**
     * Update an existing Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Parameters supplied to the Update Redis operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single Redis item in List or Get Operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RedisResourceInner> updateAsync(String resourceGroupName, String name, RedisUpdateParameters parameters);

    /**
     * Update an existing Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Parameters supplied to the Update Redis operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single Redis item in List or Get Operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RedisResourceInner update(String resourceGroupName, String name, RedisUpdateParameters parameters);

    /**
     * Update an existing Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Parameters supplied to the Update Redis operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single Redis item in List or Get Operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RedisResourceInner> updateWithResponse(
        String resourceGroupName, String name, RedisUpdateParameters parameters, Context context);

    /**
     * Deletes a Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String name);

    /**
     * Deletes a Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String name);

    /**
     * Deletes a Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String name);

    /**
     * Deletes a Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String name, Context context);

    /**
     * Deletes a Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String name);

    /**
     * Deletes a Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String name);

    /**
     * Deletes a Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String name, Context context);

    /**
     * Gets a Redis cache (resource description).
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Redis cache (resource description).
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RedisResourceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String name);

    /**
     * Gets a Redis cache (resource description).
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Redis cache (resource description).
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RedisResourceInner> getByResourceGroupAsync(String resourceGroupName, String name);

    /**
     * Gets a Redis cache (resource description).
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Redis cache (resource description).
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RedisResourceInner getByResourceGroup(String resourceGroupName, String name);

    /**
     * Gets a Redis cache (resource description).
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Redis cache (resource description).
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RedisResourceInner> getByResourceGroupWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Lists all Redis caches in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of list Redis operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RedisResourceInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * Lists all Redis caches in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of list Redis operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RedisResourceInner> listByResourceGroup(String resourceGroupName);

    /**
     * Lists all Redis caches in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of list Redis operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RedisResourceInner> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * Gets all Redis caches in the specified subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all Redis caches in the specified subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RedisResourceInner> listAsync();

    /**
     * Gets all Redis caches in the specified subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all Redis caches in the specified subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RedisResourceInner> list();

    /**
     * Gets all Redis caches in the specified subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all Redis caches in the specified subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RedisResourceInner> list(Context context);

    /**
     * Retrieve a Redis cache's access keys. This operation requires write permission to the cache resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return redis cache access keys.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RedisAccessKeysInner>> listKeysWithResponseAsync(String resourceGroupName, String name);

    /**
     * Retrieve a Redis cache's access keys. This operation requires write permission to the cache resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return redis cache access keys.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RedisAccessKeysInner> listKeysAsync(String resourceGroupName, String name);

    /**
     * Retrieve a Redis cache's access keys. This operation requires write permission to the cache resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return redis cache access keys.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RedisAccessKeysInner listKeys(String resourceGroupName, String name);

    /**
     * Retrieve a Redis cache's access keys. This operation requires write permission to the cache resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return redis cache access keys.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RedisAccessKeysInner> listKeysWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Regenerate Redis cache's access keys. This operation requires write permission to the cache resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param keyType The Redis access key to regenerate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return redis cache access keys.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RedisAccessKeysInner>> regenerateKeyWithResponseAsync(
        String resourceGroupName, String name, RedisKeyType keyType);

    /**
     * Regenerate Redis cache's access keys. This operation requires write permission to the cache resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param keyType The Redis access key to regenerate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return redis cache access keys.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RedisAccessKeysInner> regenerateKeyAsync(String resourceGroupName, String name, RedisKeyType keyType);

    /**
     * Regenerate Redis cache's access keys. This operation requires write permission to the cache resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param keyType The Redis access key to regenerate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return redis cache access keys.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RedisAccessKeysInner regenerateKey(String resourceGroupName, String name, RedisKeyType keyType);

    /**
     * Regenerate Redis cache's access keys. This operation requires write permission to the cache resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param keyType The Redis access key to regenerate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return redis cache access keys.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RedisAccessKeysInner> regenerateKeyWithResponse(
        String resourceGroupName, String name, RedisKeyType keyType, Context context);

    /**
     * Reboot specified Redis node(s). This operation requires write permission to the cache resource. There can be
     * potential data loss.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Specifies which Redis node(s) to reboot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response to force reboot for Redis cache.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RedisForceRebootResponseInner>> forceRebootWithResponseAsync(
        String resourceGroupName, String name, RedisRebootParameters parameters);

    /**
     * Reboot specified Redis node(s). This operation requires write permission to the cache resource. There can be
     * potential data loss.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Specifies which Redis node(s) to reboot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response to force reboot for Redis cache.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RedisForceRebootResponseInner> forceRebootAsync(
        String resourceGroupName, String name, RedisRebootParameters parameters);

    /**
     * Reboot specified Redis node(s). This operation requires write permission to the cache resource. There can be
     * potential data loss.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Specifies which Redis node(s) to reboot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response to force reboot for Redis cache.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RedisForceRebootResponseInner forceReboot(String resourceGroupName, String name, RedisRebootParameters parameters);

    /**
     * Reboot specified Redis node(s). This operation requires write permission to the cache resource. There can be
     * potential data loss.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Specifies which Redis node(s) to reboot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response to force reboot for Redis cache.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RedisForceRebootResponseInner> forceRebootWithResponse(
        String resourceGroupName, String name, RedisRebootParameters parameters, Context context);

    /**
     * Import data into Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Parameters for Redis import operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> importDataWithResponseAsync(
        String resourceGroupName, String name, ImportRdbParameters parameters);

    /**
     * Import data into Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Parameters for Redis import operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<Void>, Void> beginImportDataAsync(
        String resourceGroupName, String name, ImportRdbParameters parameters);

    /**
     * Import data into Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Parameters for Redis import operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginImportData(
        String resourceGroupName, String name, ImportRdbParameters parameters);

    /**
     * Import data into Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Parameters for Redis import operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginImportData(
        String resourceGroupName, String name, ImportRdbParameters parameters, Context context);

    /**
     * Import data into Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Parameters for Redis import operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> importDataAsync(String resourceGroupName, String name, ImportRdbParameters parameters);

    /**
     * Import data into Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Parameters for Redis import operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void importData(String resourceGroupName, String name, ImportRdbParameters parameters);

    /**
     * Import data into Redis cache.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Parameters for Redis import operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void importData(String resourceGroupName, String name, ImportRdbParameters parameters, Context context);

    /**
     * Export data from the redis cache to blobs in a container.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Parameters for Redis export operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> exportDataWithResponseAsync(
        String resourceGroupName, String name, ExportRdbParameters parameters);

    /**
     * Export data from the redis cache to blobs in a container.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Parameters for Redis export operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<Void>, Void> beginExportDataAsync(
        String resourceGroupName, String name, ExportRdbParameters parameters);

    /**
     * Export data from the redis cache to blobs in a container.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Parameters for Redis export operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginExportData(
        String resourceGroupName, String name, ExportRdbParameters parameters);

    /**
     * Export data from the redis cache to blobs in a container.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Parameters for Redis export operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginExportData(
        String resourceGroupName, String name, ExportRdbParameters parameters, Context context);

    /**
     * Export data from the redis cache to blobs in a container.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Parameters for Redis export operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> exportDataAsync(String resourceGroupName, String name, ExportRdbParameters parameters);

    /**
     * Export data from the redis cache to blobs in a container.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Parameters for Redis export operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void exportData(String resourceGroupName, String name, ExportRdbParameters parameters);

    /**
     * Export data from the redis cache to blobs in a container.
     *
     * @param resourceGroupName The name of the resource group.
     * @param name The name of the Redis cache.
     * @param parameters Parameters for Redis export operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void exportData(String resourceGroupName, String name, ExportRdbParameters parameters, Context context);
}
