// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A firewall rule on a redis cache has a name, and describes a contiguous range of IP addresses permitted to connect.
 */
@JsonFlatten
@Fluent
public class RedisFirewallRuleInner extends ProxyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(RedisFirewallRuleInner.class);

    /*
     * lowest IP address included in the range
     */
    @JsonProperty(value = "properties.startIP", required = true)
    private String startIp;

    /*
     * highest IP address included in the range
     */
    @JsonProperty(value = "properties.endIP", required = true)
    private String endIp;

    /**
     * Get the startIp property: lowest IP address included in the range.
     *
     * @return the startIp value.
     */
    public String startIp() {
        return this.startIp;
    }

    /**
     * Set the startIp property: lowest IP address included in the range.
     *
     * @param startIp the startIp value to set.
     * @return the RedisFirewallRuleInner object itself.
     */
    public RedisFirewallRuleInner withStartIp(String startIp) {
        this.startIp = startIp;
        return this;
    }

    /**
     * Get the endIp property: highest IP address included in the range.
     *
     * @return the endIp value.
     */
    public String endIp() {
        return this.endIp;
    }

    /**
     * Set the endIp property: highest IP address included in the range.
     *
     * @param endIp the endIp value to set.
     * @return the RedisFirewallRuleInner object itself.
     */
    public RedisFirewallRuleInner withEndIp(String endIp) {
        this.endIp = endIp;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (startIp() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property startIp in model RedisFirewallRuleInner"));
        }
        if (endIp() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property endIp in model RedisFirewallRuleInner"));
        }
    }
}
