// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.redis.models.ProvisioningState;
import com.azure.resourcemanager.redis.models.RedisCreateProperties;
import com.azure.resourcemanager.redis.models.RedisLinkedServer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Properties of the redis cache. */
@Immutable
public final class RedisPropertiesInner extends RedisCreateProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(RedisPropertiesInner.class);

    /*
     * Redis version.
     */
    @JsonProperty(value = "redisVersion", access = JsonProperty.Access.WRITE_ONLY)
    private String redisVersion;

    /*
     * Redis instance provisioning status.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /*
     * Redis host name.
     */
    @JsonProperty(value = "hostName", access = JsonProperty.Access.WRITE_ONLY)
    private String hostname;

    /*
     * Redis non-SSL port.
     */
    @JsonProperty(value = "port", access = JsonProperty.Access.WRITE_ONLY)
    private Integer port;

    /*
     * Redis SSL port.
     */
    @JsonProperty(value = "sslPort", access = JsonProperty.Access.WRITE_ONLY)
    private Integer sslPort;

    /*
     * The keys of the Redis cache - not set if this object is not the response
     * to Create or Update redis cache
     */
    @JsonProperty(value = "accessKeys", access = JsonProperty.Access.WRITE_ONLY)
    private RedisAccessKeysInner accessKeys;

    /*
     * List of the linked servers associated with the cache
     */
    @JsonProperty(value = "linkedServers", access = JsonProperty.Access.WRITE_ONLY)
    private List<RedisLinkedServer> linkedServers;

    /**
     * Get the redisVersion property: Redis version.
     *
     * @return the redisVersion value.
     */
    public String redisVersion() {
        return this.redisVersion;
    }

    /**
     * Get the provisioningState property: Redis instance provisioning status.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the hostname property: Redis host name.
     *
     * @return the hostname value.
     */
    public String hostname() {
        return this.hostname;
    }

    /**
     * Get the port property: Redis non-SSL port.
     *
     * @return the port value.
     */
    public Integer port() {
        return this.port;
    }

    /**
     * Get the sslPort property: Redis SSL port.
     *
     * @return the sslPort value.
     */
    public Integer sslPort() {
        return this.sslPort;
    }

    /**
     * Get the accessKeys property: The keys of the Redis cache - not set if this object is not the response to Create
     * or Update redis cache.
     *
     * @return the accessKeys value.
     */
    public RedisAccessKeysInner accessKeys() {
        return this.accessKeys;
    }

    /**
     * Get the linkedServers property: List of the linked servers associated with the cache.
     *
     * @return the linkedServers value.
     */
    public List<RedisLinkedServer> linkedServers() {
        return this.linkedServers;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (accessKeys() != null) {
            accessKeys().validate();
        }
        if (linkedServers() != null) {
            linkedServers().forEach(e -> e.validate());
        }
    }
}
