/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.redis.models.DayOfWeek;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;

public final class ScheduleEntry {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ScheduleEntry.class);
    @JsonProperty(value="dayOfWeek", required=true)
    private DayOfWeek dayOfWeek;
    @JsonProperty(value="startHourUtc", required=true)
    private int startHourUtc;
    @JsonProperty(value="maintenanceWindow")
    private Duration maintenanceWindow;

    public DayOfWeek dayOfWeek() {
        return this.dayOfWeek;
    }

    public ScheduleEntry withDayOfWeek(DayOfWeek dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
        return this;
    }

    public int startHourUtc() {
        return this.startHourUtc;
    }

    public ScheduleEntry withStartHourUtc(int startHourUtc) {
        this.startHourUtc = startHourUtc;
        return this;
    }

    public Duration maintenanceWindow() {
        return this.maintenanceWindow;
    }

    public ScheduleEntry withMaintenanceWindow(Duration maintenanceWindow) {
        this.maintenanceWindow = maintenanceWindow;
        return this;
    }

    public void validate() {
        if (this.dayOfWeek() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property dayOfWeek in model ScheduleEntry"));
        }
    }
}

