/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Region;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.servicebus.ServiceBusManager;
import com.azure.resourcemanager.servicebus.fluent.NamespacesClient;
import com.azure.resourcemanager.servicebus.fluent.ServiceBusManagementClient;
import com.azure.resourcemanager.servicebus.fluent.models.SharedAccessAuthorizationRuleResourceInner;
import com.azure.resourcemanager.servicebus.implementation.NamespaceAuthorizationRuleImpl;
import com.azure.resourcemanager.servicebus.implementation.ServiceBusChildResourcesImpl;
import com.azure.resourcemanager.servicebus.models.NamespaceAuthorizationRule;
import com.azure.resourcemanager.servicebus.models.NamespaceAuthorizationRules;
import com.azure.resourcemanager.servicebus.models.ServiceBusNamespace;
import reactor.core.publisher.Mono;

class NamespaceAuthorizationRulesImpl
extends ServiceBusChildResourcesImpl<NamespaceAuthorizationRule, NamespaceAuthorizationRuleImpl, SharedAccessAuthorizationRuleResourceInner, NamespacesClient, ServiceBusManager, ServiceBusNamespace>
implements NamespaceAuthorizationRules {
    private final String resourceGroupName;
    private final String namespaceName;
    private final Region region;
    private final ClientLogger logger = new ClientLogger(NamespaceAuthorizationRulesImpl.class);

    NamespaceAuthorizationRulesImpl(String resourceGroupName, String namespaceName, Region region, ServiceBusManager manager) {
        super(((ServiceBusManagementClient)manager.serviceClient()).getNamespaces(), manager);
        this.resourceGroupName = resourceGroupName;
        this.namespaceName = namespaceName;
        this.region = region;
    }

    public NamespaceAuthorizationRuleImpl define(String name) {
        return this.wrapModel(name);
    }

    public Mono<Void> deleteByNameAsync(String name) {
        return ((NamespacesClient)this.innerModel()).deleteAuthorizationRuleAsync(this.resourceGroupName, this.namespaceName, name);
    }

    @Override
    protected Mono<SharedAccessAuthorizationRuleResourceInner> getInnerByNameAsync(String name) {
        return ((NamespacesClient)this.innerModel()).getAuthorizationRuleAsync(this.resourceGroupName, this.namespaceName, name);
    }

    @Override
    protected PagedFlux<SharedAccessAuthorizationRuleResourceInner> listInnerAsync() {
        return ((NamespacesClient)this.innerModel()).listAuthorizationRulesAsync(this.resourceGroupName, this.namespaceName);
    }

    @Override
    protected PagedIterable<SharedAccessAuthorizationRuleResourceInner> listInner() {
        return ((NamespacesClient)this.innerModel()).listAuthorizationRules(this.resourceGroupName, this.namespaceName);
    }

    protected NamespaceAuthorizationRuleImpl wrapModel(String name) {
        return new NamespaceAuthorizationRuleImpl(this.resourceGroupName, this.namespaceName, name, this.region, new SharedAccessAuthorizationRuleResourceInner(), (ServiceBusManager)this.manager());
    }

    protected NamespaceAuthorizationRuleImpl wrapModel(SharedAccessAuthorizationRuleResourceInner inner) {
        if (inner == null) {
            return null;
        }
        return new NamespaceAuthorizationRuleImpl(this.resourceGroupName, this.namespaceName, inner.name(), this.region, inner, (ServiceBusManager)this.manager());
    }

    public PagedIterable<NamespaceAuthorizationRule> listByParent(String resourceGroupName, String parentName) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException());
    }

    public Mono<Void> deleteByParentAsync(String groupName, String parentName, String name) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException());
    }

    public Mono<NamespaceAuthorizationRule> getByParentAsync(String resourceGroup, String parentName, String name) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException());
    }
}

