/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.Resource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.IndependentChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.servicebus.ServiceBusManager;
import com.azure.resourcemanager.servicebus.fluent.ServiceBusManagementClient;
import com.azure.resourcemanager.servicebus.fluent.models.SubscriptionResourceInner;
import com.azure.resourcemanager.servicebus.implementation.TimeSpan;
import com.azure.resourcemanager.servicebus.models.EntityStatus;
import com.azure.resourcemanager.servicebus.models.ServiceBusSubscription;
import com.azure.resourcemanager.servicebus.models.SubscriptionCreateOrUpdateParameters;
import com.azure.resourcemanager.servicebus.models.Topic;
import java.time.Duration;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

class ServiceBusSubscriptionImpl
extends IndependentChildResourceImpl<ServiceBusSubscription, Topic, SubscriptionResourceInner, ServiceBusSubscriptionImpl, ServiceBusManager>
implements ServiceBusSubscription,
ServiceBusSubscription.Definition,
ServiceBusSubscription.Update {
    private final String namespaceName;
    private final Region region;

    ServiceBusSubscriptionImpl(String resourceGroupName, String namespaceName, String topicName, String name, Region region, SubscriptionResourceInner inner, ServiceBusManager manager) {
        super(name, (Resource)inner, (Object)manager);
        this.namespaceName = namespaceName;
        this.region = region;
        this.withExistingParentResource(resourceGroupName, topicName);
        if (inner.location() == null) {
            inner.withLocation(this.region.toString());
        }
    }

    @Override
    public OffsetDateTime createdAt() {
        return ((SubscriptionResourceInner)((Object)this.innerModel())).createdAt();
    }

    @Override
    public OffsetDateTime accessedAt() {
        return ((SubscriptionResourceInner)((Object)this.innerModel())).accessedAt();
    }

    @Override
    public OffsetDateTime updatedAt() {
        return ((SubscriptionResourceInner)((Object)this.innerModel())).updatedAt();
    }

    @Override
    public boolean isBatchedOperationsEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((SubscriptionResourceInner)((Object)this.innerModel())).enableBatchedOperations());
    }

    @Override
    public boolean isDeadLetteringEnabledForExpiredMessages() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((SubscriptionResourceInner)((Object)this.innerModel())).deadLetteringOnMessageExpiration());
    }

    @Override
    public boolean isSessionEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((SubscriptionResourceInner)((Object)this.innerModel())).requiresSession());
    }

    @Override
    public long lockDurationInSeconds() {
        if (((SubscriptionResourceInner)((Object)this.innerModel())).lockDuration() == null) {
            return 0L;
        }
        TimeSpan timeSpan = TimeSpan.parse(((SubscriptionResourceInner)((Object)this.innerModel())).lockDuration());
        return (long)timeSpan.totalSeconds();
    }

    @Override
    public long deleteOnIdleDurationInMinutes() {
        if (((SubscriptionResourceInner)((Object)this.innerModel())).autoDeleteOnIdle() == null) {
            return 0L;
        }
        TimeSpan timeSpan = TimeSpan.parse(((SubscriptionResourceInner)((Object)this.innerModel())).autoDeleteOnIdle());
        return (long)timeSpan.totalMinutes();
    }

    @Override
    public Duration defaultMessageTtlDuration() {
        if (((SubscriptionResourceInner)((Object)this.innerModel())).defaultMessageTimeToLive() == null) {
            return null;
        }
        return TimeSpan.parse(((SubscriptionResourceInner)((Object)this.innerModel())).defaultMessageTimeToLive()).toDuration();
    }

    @Override
    public int maxDeliveryCountBeforeDeadLetteringMessage() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((SubscriptionResourceInner)((Object)this.innerModel())).maxDeliveryCount());
    }

    @Override
    public long messageCount() {
        return ResourceManagerUtils.toPrimitiveLong((Long)((SubscriptionResourceInner)((Object)this.innerModel())).messageCount());
    }

    @Override
    public long activeMessageCount() {
        if (((SubscriptionResourceInner)((Object)this.innerModel())).countDetails() == null || ((SubscriptionResourceInner)((Object)this.innerModel())).countDetails().activeMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong((Long)((SubscriptionResourceInner)((Object)this.innerModel())).countDetails().activeMessageCount());
    }

    @Override
    public long deadLetterMessageCount() {
        if (((SubscriptionResourceInner)((Object)this.innerModel())).countDetails() == null || ((SubscriptionResourceInner)((Object)this.innerModel())).countDetails().deadLetterMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong((Long)((SubscriptionResourceInner)((Object)this.innerModel())).countDetails().deadLetterMessageCount());
    }

    @Override
    public long scheduledMessageCount() {
        if (((SubscriptionResourceInner)((Object)this.innerModel())).countDetails() == null || ((SubscriptionResourceInner)((Object)this.innerModel())).countDetails().scheduledMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong((Long)((SubscriptionResourceInner)((Object)this.innerModel())).countDetails().scheduledMessageCount());
    }

    @Override
    public long transferDeadLetterMessageCount() {
        if (((SubscriptionResourceInner)((Object)this.innerModel())).countDetails() == null || ((SubscriptionResourceInner)((Object)this.innerModel())).countDetails().transferDeadLetterMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong((Long)((SubscriptionResourceInner)((Object)this.innerModel())).countDetails().transferDeadLetterMessageCount());
    }

    @Override
    public long transferMessageCount() {
        if (((SubscriptionResourceInner)((Object)this.innerModel())).countDetails() == null || ((SubscriptionResourceInner)((Object)this.innerModel())).countDetails().transferMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong((Long)((SubscriptionResourceInner)((Object)this.innerModel())).countDetails().transferMessageCount());
    }

    @Override
    public EntityStatus status() {
        return ((SubscriptionResourceInner)((Object)this.innerModel())).status();
    }

    @Override
    public boolean isDeadLetteringEnabledForFilterEvaluationFailedMessages() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((SubscriptionResourceInner)((Object)this.innerModel())).deadLetteringOnFilterEvaluationExceptions());
    }

    @Override
    public ServiceBusSubscriptionImpl withDeleteOnIdleDurationInMinutes(int durationInMinutes) {
        TimeSpan timeSpan = new TimeSpan().withMinutes(durationInMinutes);
        ((SubscriptionResourceInner)((Object)this.innerModel())).withAutoDeleteOnIdle(timeSpan.toString());
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withMessageLockDurationInSeconds(int durationInSeconds) {
        TimeSpan timeSpan = new TimeSpan().withSeconds(durationInSeconds);
        ((SubscriptionResourceInner)((Object)this.innerModel())).withLockDuration(timeSpan.toString());
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withDefaultMessageTTL(Duration ttl) {
        ((SubscriptionResourceInner)((Object)this.innerModel())).withDefaultMessageTimeToLive(TimeSpan.fromDuration(ttl).toString());
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withSession() {
        ((SubscriptionResourceInner)((Object)this.innerModel())).withRequiresSession(true);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withoutSession() {
        ((SubscriptionResourceInner)((Object)this.innerModel())).withRequiresSession(false);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withMessageBatching() {
        ((SubscriptionResourceInner)((Object)this.innerModel())).withEnableBatchedOperations(true);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withoutMessageBatching() {
        ((SubscriptionResourceInner)((Object)this.innerModel())).withEnableBatchedOperations(false);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withMessageMovedToDeadLetterSubscriptionOnMaxDeliveryCount(int deliveryCount) {
        ((SubscriptionResourceInner)((Object)this.innerModel())).withMaxDeliveryCount(deliveryCount);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withMessageMovedToDeadLetterSubscriptionOnFilterEvaluationException() {
        ((SubscriptionResourceInner)((Object)this.innerModel())).withDeadLetteringOnFilterEvaluationExceptions(true);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withoutMessageMovedToDeadLetterSubscriptionOnFilterEvaluationException() {
        ((SubscriptionResourceInner)((Object)this.innerModel())).withDeadLetteringOnFilterEvaluationExceptions(false);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withExpiredMessageMovedToDeadLetterSubscription() {
        ((SubscriptionResourceInner)((Object)this.innerModel())).withDeadLetteringOnMessageExpiration(true);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withoutExpiredMessageMovedToDeadLetterSubscription() {
        ((SubscriptionResourceInner)((Object)this.innerModel())).withDeadLetteringOnMessageExpiration(false);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withMessageMovedToDeadLetterQueueOnMaxDeliveryCount(int deliveryCount) {
        ((SubscriptionResourceInner)((Object)this.innerModel())).withMaxDeliveryCount(deliveryCount);
        return this;
    }

    protected Mono<SubscriptionResourceInner> getInnerAsync() {
        return ((ServiceBusManagementClient)((ServiceBusManager)((Object)this.manager())).serviceClient()).getSubscriptions().getAsync(this.resourceGroupName(), this.namespaceName, this.parentName, this.name());
    }

    protected Mono<ServiceBusSubscription> createChildResourceAsync() {
        ServiceBusSubscriptionImpl self = this;
        return ((ServiceBusManagementClient)((ServiceBusManager)((Object)this.manager())).serviceClient()).getSubscriptions().createOrUpdateAsync(this.resourceGroupName(), this.namespaceName, this.parentName, this.name(), this.prepareForCreate((SubscriptionResourceInner)((Object)this.innerModel()))).map(inner -> {
            this.setInner(inner);
            return self;
        });
    }

    private SubscriptionCreateOrUpdateParameters prepareForCreate(SubscriptionResourceInner inner) {
        return new SubscriptionCreateOrUpdateParameters().withAutoDeleteOnIdle(inner.autoDeleteOnIdle()).withDefaultMessageTimeToLive(inner.defaultMessageTimeToLive()).withDeadLetteringOnFilterEvaluationExceptions(inner.deadLetteringOnFilterEvaluationExceptions()).withDeadLetteringOnMessageExpiration(inner.deadLetteringOnMessageExpiration()).withEnableBatchedOperations(inner.enableBatchedOperations()).withEntityAvailabilityStatus(inner.entityAvailabilityStatus()).withIsReadOnly(inner.isReadOnly()).withLockDuration(inner.lockDuration()).withMaxDeliveryCount(inner.maxDeliveryCount()).withRequiresSession(inner.requiresSession()).withStatus(inner.status()).withLocation(inner.location());
    }
}

