/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.servicebus.implementation.Token;
import com.azure.resourcemanager.servicebus.implementation.TokenParser;
import java.time.Duration;

public class TimeSpan {
    private static long ticksPerMillisecond = 10000L;
    private static long ticksPerSecond = ticksPerMillisecond * 1000L;
    private static long ticksPerMinute = ticksPerSecond * 60L;
    private static long ticksPerHour = ticksPerMinute * 60L;
    private static long ticksPerDay = ticksPerHour * 24L;
    private static double millisecondsPerTick = 1.0 / (double)ticksPerMillisecond;
    private static double secondsPerTick = 1.0 / (double)ticksPerSecond;
    private static double minutesPerTick = 1.0 / (double)ticksPerMinute;
    private long days;
    private long hours;
    private long minutes;
    private long seconds;
    private long milliseconds;

    public TimeSpan withDays(long days) {
        this.days = days;
        return this;
    }

    public TimeSpan withHours(long hours) {
        this.hours = hours;
        return this;
    }

    public TimeSpan withMinutes(long minutes) {
        this.minutes = minutes;
        return this;
    }

    public TimeSpan withSeconds(long seconds) {
        this.seconds = seconds;
        return this;
    }

    public TimeSpan withMilliseconds(long milliseconds) {
        this.milliseconds = milliseconds;
        return this;
    }

    public long days() {
        return this.days;
    }

    public long hours() {
        return this.hours;
    }

    public long minutes() {
        return this.minutes;
    }

    public long seconds() {
        return this.seconds;
    }

    public long milliseconds() {
        return this.milliseconds;
    }

    public double totalMilliseconds() {
        return (double)this.totalTicks() * millisecondsPerTick;
    }

    public Duration toDuration() {
        Double millis = this.totalMilliseconds();
        return Duration.ofMillis(millis.longValue());
    }

    public double totalSeconds() {
        return (double)this.totalTicks() * secondsPerTick;
    }

    public double totalMinutes() {
        return (double)this.totalTicks() * minutesPerTick;
    }

    public static TimeSpan fromDuration(Duration duration) {
        long totalTicks = duration.toMillis() * ticksPerMillisecond;
        long days = Math.abs(totalTicks / ticksPerDay);
        totalTicks = Math.abs(totalTicks % ticksPerDay);
        long hours = totalTicks / ticksPerHour % 24L;
        long minutes = totalTicks / ticksPerMinute % 60L;
        long seconds = totalTicks / ticksPerSecond % 60L;
        long milliseconds = duration.toMillis() - (days * 3600L * 24L + hours * 3600L + minutes * 60L + seconds) * 1000L;
        return new TimeSpan().withDays(days).withHours(hours).withMinutes(minutes).withSeconds(seconds).withMilliseconds(milliseconds);
    }

    public static TimeSpan parse(String input) {
        int sign;
        if (input == null) {
            throw new ClientLogger(TimeSpan.class).logExceptionAsError((RuntimeException)new IllegalArgumentException("input cannot be null"));
        }
        String str = input.trim();
        TimeSpan timeSpan = new TimeSpan();
        TokenParser parser = new TokenParser(str, str.charAt(0) == '-' ? 1 : 0);
        Token token = parser.nextToken();
        token.throwIfEmpty();
        int n = sign = str.charAt(0) == '-' ? -1 : 1;
        if (token.isTerminalCharNull()) {
            timeSpan.withDays(TimeSpan.toInt(token.getRawValue()) * sign);
            return timeSpan;
        }
        if (token.isTerminalMatched(Character.valueOf('.'))) {
            timeSpan.withDays(TimeSpan.toInt(token.getRawValue()) * sign);
            token = parser.nextToken();
            token.throwIfEmpty();
            timeSpan.withHours(TimeSpan.toInt(token.getRawValue()) * sign);
        } else {
            timeSpan.withDays(0L);
            timeSpan.withHours(TimeSpan.toInt(token.getRawValue()) * sign);
        }
        if (timeSpan.hours() > 23L) {
            TokenParser.throwOutOfRange();
        }
        token.throwIfTerminalCharNotMatch(Character.valueOf(':'));
        token = parser.nextToken();
        token.throwIfEmpty();
        timeSpan.withMinutes(TimeSpan.toInt(token.getRawValue()) * sign);
        if (timeSpan.minutes() > 59L) {
            TokenParser.throwOutOfRange();
        }
        if (token.isTerminalCharNull()) {
            return timeSpan;
        }
        token.throwIfTerminalCharNotMatch(Character.valueOf(':'));
        token = parser.nextToken();
        token.throwIfEmpty();
        timeSpan.withSeconds(TimeSpan.toInt(token.getRawValue()) * sign);
        if (timeSpan.seconds() > 59L) {
            TokenParser.throwOutOfRange();
        }
        if (token.isTerminalCharNull()) {
            return timeSpan;
        }
        token.throwIfTerminalCharNotMatch(Character.valueOf('.'));
        token = parser.nextToken();
        token.throwIfEmpty();
        String milliStr = "." + token.getRawValue();
        if (milliStr.length() > 8) {
            TokenParser.throwOutOfRange();
        }
        int milliSeconds = (int)(Double.parseDouble(milliStr) * 1000.0);
        timeSpan.withMilliseconds(milliSeconds * sign);
        if (!token.isTerminalCharNull()) {
            TokenParser.throwParseError();
        }
        return timeSpan;
    }

    public String toString() {
        long totalTicks = this.totalTicks();
        long days = Math.abs(totalTicks / ticksPerDay);
        StringBuilder stringBuilder = new StringBuilder();
        if (totalTicks < 0L) {
            stringBuilder.append("-");
        }
        if (days != 0L) {
            stringBuilder.append(String.format("%d.", days));
        }
        long remainingTicks = Math.abs(totalTicks % ticksPerDay);
        long hours = remainingTicks / ticksPerHour % 24L;
        long minutes = remainingTicks / ticksPerMinute % 60L;
        long seconds = remainingTicks / ticksPerSecond % 60L;
        stringBuilder.append(String.format("%02d:%02d:%02d", hours, minutes, seconds));
        int fraction = (int)(remainingTicks % ticksPerSecond);
        if (fraction != 0) {
            stringBuilder.append(String.format(".%07d", fraction));
        }
        return stringBuilder.toString();
    }

    private long totalTicks() {
        long totalMilliSeconds = (this.days * 3600L * 24L + this.hours * 3600L + this.minutes * 60L + this.seconds) * 1000L + this.milliseconds;
        return totalMilliSeconds * ticksPerMillisecond;
    }

    private static int toInt(String intStr) {
        return Integer.parseInt(intStr);
    }
}

