/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.implementation;

import com.azure.core.util.logging.ClientLogger;

class Token {
    private String rawValue;
    private Character terminalChar;
    private final ClientLogger logger = new ClientLogger(Token.class);

    Token(String rawValue, Character terminalChar) {
        this.rawValue = rawValue;
        this.terminalChar = terminalChar;
    }

    String getRawValue() {
        return this.rawValue;
    }

    boolean isTerminalMatched(Character charToMatch) {
        if (this.terminalChar == null && charToMatch == null) {
            return true;
        }
        return this.terminalChar != null && charToMatch != null && this.terminalChar.equals(charToMatch);
    }

    boolean isTerminalCharNull() {
        return this.isTerminalMatched(null);
    }

    void throwIfTerminalCharNotMatch(Character matchChar) {
        if (!this.isTerminalMatched(matchChar)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("String was not recognized as a valid TimeSpan"));
        }
    }

    void throwIfEmpty() {
        if (this.isEmpty()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("String was not recognized as a valid TimeSpan"));
        }
    }

    boolean isEmpty() {
        return this.rawValue == null && this.terminalChar == null;
    }
}

