/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.servicebus.implementation.Token;
import java.util.concurrent.Callable;

class TokenParser {
    private final String str;
    private final int startIndex;
    private Callable<Token> nextTokenProvider;
    private final ClientLogger logger = new ClientLogger(TokenParser.class);

    TokenParser(String str, int startIndex) {
        this.str = str;
        this.startIndex = startIndex;
        this.nextTokenProvider = this.nextTokenProvider();
    }

    Token nextToken() {
        try {
            return this.nextTokenProvider.call();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw this.logger.logExceptionAsError(new RuntimeException("TimeSpan::nextToken() failed."));
        }
    }

    static void throwParseError() {
        throw new ClientLogger(TokenParser.class).logExceptionAsError((RuntimeException)new IllegalArgumentException("String was not recognized as a valid TimeSpan"));
    }

    static void throwOutOfRange() {
        throw new ClientLogger(TokenParser.class).logExceptionAsError((RuntimeException)new IllegalArgumentException("The TimeSpan could not be parsed because at least one of the numeric components is out of range or contains too many digits"));
    }

    private Callable<Token> nextTokenProvider() {
        return new Callable<Token>(){
            int currentIndex;
            int length;
            {
                this.currentIndex = TokenParser.this.startIndex;
                this.length = TokenParser.this.str.length();
            }

            @Override
            public Token call() {
                if (this.currentIndex >= this.length) {
                    return new Token(null, null);
                }
                StringBuilder builder = new StringBuilder();
                while (this.currentIndex < this.length && Character.isDigit(TokenParser.this.str.charAt(this.currentIndex))) {
                    builder.append(TokenParser.this.str.charAt(this.currentIndex));
                    ++this.currentIndex;
                }
                String val = builder.toString();
                if (val.isEmpty()) {
                    TokenParser.throwParseError();
                }
                try {
                    Integer.parseInt(val);
                }
                catch (Exception ex) {
                    TokenParser.throwOutOfRange();
                }
                if (this.currentIndex < this.length) {
                    return new Token(val, Character.valueOf(TokenParser.this.str.charAt(this.currentIndex++)));
                }
                return new Token(val, null);
            }
        };
    }
}

