/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.models;

import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.servicebus.models.Sku;
import com.azure.resourcemanager.servicebus.models.SkuName;
import com.azure.resourcemanager.servicebus.models.SkuTier;

public final class NamespaceSku {
    public static final NamespaceSku BASIC = new NamespaceSku(new Sku().withName(SkuName.BASIC).withTier(SkuTier.BASIC));
    public static final NamespaceSku STANDARD = new NamespaceSku(new Sku().withName(SkuName.STANDARD).withTier(SkuTier.STANDARD));
    public static final NamespaceSku PREMIUM_CAPACITY1 = new NamespaceSku(new Sku().withCapacity(1).withName(SkuName.PREMIUM).withTier(SkuTier.PREMIUM));
    public static final NamespaceSku PREMIUM_CAPACITY2 = new NamespaceSku(new Sku().withCapacity(2).withName(SkuName.PREMIUM).withTier(SkuTier.PREMIUM));
    public static final NamespaceSku PREMIUM_CAPACITY4 = new NamespaceSku(new Sku().withCapacity(4).withName(SkuName.PREMIUM).withTier(SkuTier.PREMIUM));
    private final Sku sku;

    public NamespaceSku(String name, String tier) {
        this(new Sku().withCapacity(null).withName(SkuName.fromString(name)).withTier(SkuTier.fromString(tier)));
    }

    public NamespaceSku(String name, String tier, int capacity) {
        this(new Sku().withCapacity(capacity).withName(SkuName.fromString(name)).withTier(SkuTier.fromString(tier)));
    }

    public NamespaceSku(Sku sku) {
        this.sku = sku;
    }

    public SkuName name() {
        return this.sku.name();
    }

    public SkuTier tier() {
        return this.sku.tier();
    }

    public int capacity() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)this.sku.capacity());
    }

    public String toString() {
        if (this.sku.capacity() != null) {
            return String.format("%s_%s_%d", new Object[]{this.sku.name(), this.sku.tier(), this.sku.capacity()});
        }
        return String.format("%s_%s", new Object[]{this.sku.name(), this.sku.tier()});
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NamespaceSku)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        NamespaceSku rhs = (NamespaceSku)obj;
        if (this.sku == null) {
            return rhs.sku == null;
        }
        return this.toString().equalsIgnoreCase(rhs.toString());
    }
}

