/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.servicebus.models.EntityAvailabilityStatus;
import com.azure.resourcemanager.servicebus.models.EntityStatus;
import com.azure.resourcemanager.servicebus.models.MessageCountDetails;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

@JsonFlatten
public class QueueCreateOrUpdateParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(QueueCreateOrUpdateParameters.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="location", required=true)
    private String location;
    @JsonProperty(value="properties.lockDuration")
    private String lockDuration;
    @JsonProperty(value="properties.accessedAt", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime accessedAt;
    @JsonProperty(value="properties.autoDeleteOnIdle")
    private String autoDeleteOnIdle;
    @JsonProperty(value="properties.entityAvailabilityStatus")
    private EntityAvailabilityStatus entityAvailabilityStatus;
    @JsonProperty(value="properties.createdAt", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdAt;
    @JsonProperty(value="properties.defaultMessageTimeToLive")
    private String defaultMessageTimeToLive;
    @JsonProperty(value="properties.duplicateDetectionHistoryTimeWindow")
    private String duplicateDetectionHistoryTimeWindow;
    @JsonProperty(value="properties.enableBatchedOperations")
    private Boolean enableBatchedOperations;
    @JsonProperty(value="properties.deadLetteringOnMessageExpiration")
    private Boolean deadLetteringOnMessageExpiration;
    @JsonProperty(value="properties.enableExpress")
    private Boolean enableExpress;
    @JsonProperty(value="properties.enablePartitioning")
    private Boolean enablePartitioning;
    @JsonProperty(value="properties.isAnonymousAccessible")
    private Boolean isAnonymousAccessible;
    @JsonProperty(value="properties.maxDeliveryCount")
    private Integer maxDeliveryCount;
    @JsonProperty(value="properties.maxSizeInMegabytes")
    private Long maxSizeInMegabytes;
    @JsonProperty(value="properties.messageCount", access=JsonProperty.Access.WRITE_ONLY)
    private Long messageCount;
    @JsonProperty(value="properties.countDetails", access=JsonProperty.Access.WRITE_ONLY)
    private MessageCountDetails countDetails;
    @JsonProperty(value="properties.requiresDuplicateDetection")
    private Boolean requiresDuplicateDetection;
    @JsonProperty(value="properties.requiresSession")
    private Boolean requiresSession;
    @JsonProperty(value="properties.sizeInBytes", access=JsonProperty.Access.WRITE_ONLY)
    private Long sizeInBytes;
    @JsonProperty(value="properties.status")
    private EntityStatus status;
    @JsonProperty(value="properties.supportOrdering")
    private Boolean supportOrdering;
    @JsonProperty(value="properties.updatedAt", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime updatedAt;

    public String name() {
        return this.name;
    }

    public QueueCreateOrUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    public String location() {
        return this.location;
    }

    public QueueCreateOrUpdateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    public String lockDuration() {
        return this.lockDuration;
    }

    public QueueCreateOrUpdateParameters withLockDuration(String lockDuration) {
        this.lockDuration = lockDuration;
        return this;
    }

    public OffsetDateTime accessedAt() {
        return this.accessedAt;
    }

    public String autoDeleteOnIdle() {
        return this.autoDeleteOnIdle;
    }

    public QueueCreateOrUpdateParameters withAutoDeleteOnIdle(String autoDeleteOnIdle) {
        this.autoDeleteOnIdle = autoDeleteOnIdle;
        return this;
    }

    public EntityAvailabilityStatus entityAvailabilityStatus() {
        return this.entityAvailabilityStatus;
    }

    public QueueCreateOrUpdateParameters withEntityAvailabilityStatus(EntityAvailabilityStatus entityAvailabilityStatus) {
        this.entityAvailabilityStatus = entityAvailabilityStatus;
        return this;
    }

    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    public String defaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    public QueueCreateOrUpdateParameters withDefaultMessageTimeToLive(String defaultMessageTimeToLive) {
        this.defaultMessageTimeToLive = defaultMessageTimeToLive;
        return this;
    }

    public String duplicateDetectionHistoryTimeWindow() {
        return this.duplicateDetectionHistoryTimeWindow;
    }

    public QueueCreateOrUpdateParameters withDuplicateDetectionHistoryTimeWindow(String duplicateDetectionHistoryTimeWindow) {
        this.duplicateDetectionHistoryTimeWindow = duplicateDetectionHistoryTimeWindow;
        return this;
    }

    public Boolean enableBatchedOperations() {
        return this.enableBatchedOperations;
    }

    public QueueCreateOrUpdateParameters withEnableBatchedOperations(Boolean enableBatchedOperations) {
        this.enableBatchedOperations = enableBatchedOperations;
        return this;
    }

    public Boolean deadLetteringOnMessageExpiration() {
        return this.deadLetteringOnMessageExpiration;
    }

    public QueueCreateOrUpdateParameters withDeadLetteringOnMessageExpiration(Boolean deadLetteringOnMessageExpiration) {
        this.deadLetteringOnMessageExpiration = deadLetteringOnMessageExpiration;
        return this;
    }

    public Boolean enableExpress() {
        return this.enableExpress;
    }

    public QueueCreateOrUpdateParameters withEnableExpress(Boolean enableExpress) {
        this.enableExpress = enableExpress;
        return this;
    }

    public Boolean enablePartitioning() {
        return this.enablePartitioning;
    }

    public QueueCreateOrUpdateParameters withEnablePartitioning(Boolean enablePartitioning) {
        this.enablePartitioning = enablePartitioning;
        return this;
    }

    public Boolean isAnonymousAccessible() {
        return this.isAnonymousAccessible;
    }

    public QueueCreateOrUpdateParameters withIsAnonymousAccessible(Boolean isAnonymousAccessible) {
        this.isAnonymousAccessible = isAnonymousAccessible;
        return this;
    }

    public Integer maxDeliveryCount() {
        return this.maxDeliveryCount;
    }

    public QueueCreateOrUpdateParameters withMaxDeliveryCount(Integer maxDeliveryCount) {
        this.maxDeliveryCount = maxDeliveryCount;
        return this;
    }

    public Long maxSizeInMegabytes() {
        return this.maxSizeInMegabytes;
    }

    public QueueCreateOrUpdateParameters withMaxSizeInMegabytes(Long maxSizeInMegabytes) {
        this.maxSizeInMegabytes = maxSizeInMegabytes;
        return this;
    }

    public Long messageCount() {
        return this.messageCount;
    }

    public MessageCountDetails countDetails() {
        return this.countDetails;
    }

    public Boolean requiresDuplicateDetection() {
        return this.requiresDuplicateDetection;
    }

    public QueueCreateOrUpdateParameters withRequiresDuplicateDetection(Boolean requiresDuplicateDetection) {
        this.requiresDuplicateDetection = requiresDuplicateDetection;
        return this;
    }

    public Boolean requiresSession() {
        return this.requiresSession;
    }

    public QueueCreateOrUpdateParameters withRequiresSession(Boolean requiresSession) {
        this.requiresSession = requiresSession;
        return this;
    }

    public Long sizeInBytes() {
        return this.sizeInBytes;
    }

    public EntityStatus status() {
        return this.status;
    }

    public QueueCreateOrUpdateParameters withStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    public Boolean supportOrdering() {
        return this.supportOrdering;
    }

    public QueueCreateOrUpdateParameters withSupportOrdering(Boolean supportOrdering) {
        this.supportOrdering = supportOrdering;
        return this;
    }

    public OffsetDateTime updatedAt() {
        return this.updatedAt;
    }

    public void validate() {
        if (this.location() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property location in model QueueCreateOrUpdateParameters"));
        }
        if (this.countDetails() != null) {
            this.countDetails().validate();
        }
    }
}

