/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.blb;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.blb.BlbClientConfiguration;
import com.baidubce.services.blb.model.AppBackendPolicyRequest;
import com.baidubce.services.blb.model.AppBackendServer;
import com.baidubce.services.blb.model.AppIgRequest;
import com.baidubce.services.blb.model.AppIgResponse;
import com.baidubce.services.blb.model.AppIpGroupMember;
import com.baidubce.services.blb.model.AppIpGroupMemberRequest;
import com.baidubce.services.blb.model.AppPolicy;
import com.baidubce.services.blb.model.AppPolicyRequest;
import com.baidubce.services.blb.model.AppRsRequest;
import com.baidubce.services.blb.model.AppSgPortRequest;
import com.baidubce.services.blb.model.AppSgPortResponse;
import com.baidubce.services.blb.model.AppSgRequest;
import com.baidubce.services.blb.model.AppSgResponse;
import com.baidubce.services.blb.model.BlbListenerAction;
import com.baidubce.services.blb.model.BlbListenerRequest;
import com.baidubce.services.blb.model.CreateAppPolicyResponse;
import com.baidubce.services.blb.model.CreateBlbRequest;
import com.baidubce.services.blb.model.CreateBlbResponse;
import com.baidubce.services.blb.model.DeleteAppPolicyRequest;
import com.baidubce.services.blb.model.DeleteBlbRequest;
import com.baidubce.services.blb.model.DeleteListenerRequest;
import com.baidubce.services.blb.model.HttpListener;
import com.baidubce.services.blb.model.HttpsListener;
import com.baidubce.services.blb.model.ListAppIgRequest;
import com.baidubce.services.blb.model.ListAppIgResponse;
import com.baidubce.services.blb.model.ListAppIpGroupMemberRequest;
import com.baidubce.services.blb.model.ListAppIpGroupMemberResponse;
import com.baidubce.services.blb.model.ListAppPolicyRequest;
import com.baidubce.services.blb.model.ListAppPolicyResponse;
import com.baidubce.services.blb.model.ListAppRsRequest;
import com.baidubce.services.blb.model.ListAppRsResponse;
import com.baidubce.services.blb.model.ListAppSgRequest;
import com.baidubce.services.blb.model.ListAppSgResponse;
import com.baidubce.services.blb.model.ListBackendServerStatusRequest;
import com.baidubce.services.blb.model.ListBackendServerStatusResponse;
import com.baidubce.services.blb.model.ListBlbRequest;
import com.baidubce.services.blb.model.ListBlbResponse;
import com.baidubce.services.blb.model.ListListenerRequest;
import com.baidubce.services.blb.model.ListListenerResponse;
import com.baidubce.services.blb.model.ListenerConstant;
import com.baidubce.services.blb.model.ModifyBlbAttributesRequest;
import com.baidubce.services.blb.model.SslListener;
import com.baidubce.services.blb.model.TcpListener;
import com.baidubce.services.blb.model.UdpListener;
import com.baidubce.services.tag.model.Tag;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class AppBlbClient
extends AbstractBceClient {
    private static final String VERSION = "v1";
    private static final String PREFIX = "appblb";
    private static final String CLIENT_TOKEN_IDENTIFY = "clientToken";
    private static final HttpResponseHandler[] blbHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public AppBlbClient() {
        this(new BlbClientConfiguration());
    }

    public AppBlbClient(BlbClientConfiguration clientConfiguration) {
        super(clientConfiguration, blbHandlers);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    protected void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }

    public CreateBlbResponse createBlb(String name, String desc, String vpcId, String subnetId, List<Tag> tags) {
        return this.createBlb(new CreateBlbRequest().withName(name).withDesc(desc).withVpcId(vpcId).withSubnetId(subnetId).withTags(tags));
    }

    public CreateBlbResponse createBlb(CreateBlbRequest createBlbRequest) {
        Preconditions.checkNotNull((Object)createBlbRequest, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)createBlbRequest.getClientToken())) {
            createBlbRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(createBlbRequest, HttpMethodName.POST, PREFIX);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, createBlbRequest.getClientToken());
        this.fillPayload(internalRequest, createBlbRequest);
        return this.invokeHttpClient(internalRequest, CreateBlbResponse.class);
    }

    public ListBlbResponse listBlbs(String address, String name, String blbId, String bccId) {
        return this.listBlbs(new ListBlbRequest().withAddress(address).withName(name).withBlbId(blbId).withBccId(bccId));
    }

    public ListBlbResponse listBlbs(ListBlbRequest listBlbRequest) {
        Preconditions.checkNotNull((Object)listBlbRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(listBlbRequest, HttpMethodName.GET, PREFIX);
        if (StringUtils.isNotEmpty((CharSequence)listBlbRequest.getAddress())) {
            internalRequest.addParameter("address", listBlbRequest.getAddress());
        }
        if (StringUtils.isNotEmpty((CharSequence)listBlbRequest.getName())) {
            internalRequest.addParameter("name", listBlbRequest.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)listBlbRequest.getBlbId())) {
            internalRequest.addParameter("blbId", listBlbRequest.getBlbId());
        }
        if (StringUtils.isNotEmpty((CharSequence)listBlbRequest.getBccId())) {
            internalRequest.addParameter("bccId", listBlbRequest.getBccId());
        }
        if (listBlbRequest.getMarker() != null) {
            internalRequest.addParameter("marker", listBlbRequest.getMarker());
        }
        if (listBlbRequest.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(listBlbRequest.getMaxKeys()));
        }
        return this.invokeHttpClient(internalRequest, ListBlbResponse.class);
    }

    public void modifyBlbAttributes(String blbId, String name, String desc) {
        this.modifyBlbAttributes(new ModifyBlbAttributesRequest(blbId, name, desc));
    }

    public void modifyBlbAttributes(ModifyBlbAttributesRequest modifyBlbAttributesRequest) {
        Preconditions.checkNotNull((Object)modifyBlbAttributesRequest, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(modifyBlbAttributesRequest.getBlbId(), "request blbId should not be null.");
        if (Strings.isNullOrEmpty((String)modifyBlbAttributesRequest.getClientToken())) {
            modifyBlbAttributesRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(modifyBlbAttributesRequest, HttpMethodName.PUT, PREFIX, modifyBlbAttributesRequest.getBlbId());
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, modifyBlbAttributesRequest.getClientToken());
        this.fillPayload(internalRequest, modifyBlbAttributesRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteBlb(String blbId) {
        this.deleteBlb(new DeleteBlbRequest(blbId));
    }

    public void deleteBlb(DeleteBlbRequest deleteBlbRequest) {
        Preconditions.checkNotNull((Object)deleteBlbRequest, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)deleteBlbRequest.getClientToken())) {
            deleteBlbRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(deleteBlbRequest, HttpMethodName.DELETE, PREFIX, deleteBlbRequest.getBlbId());
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, deleteBlbRequest.getClientToken());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void createListener(BlbListenerRequest blbListenerRequest) {
        Preconditions.checkNotNull((Object)blbListenerRequest, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)blbListenerRequest.getClientToken())) {
            blbListenerRequest.setClientToken(this.generateClientToken());
        }
        Preconditions.checkNotNull((Object)blbListenerRequest.getType(), (Object)"listener type should not be null.");
        if (!ListenerConstant.LISTENER_SET.contains(blbListenerRequest.getType())) {
            throw new IllegalArgumentException("listener type is illegal.");
        }
        InternalRequest internalRequest = this.createRequest(blbListenerRequest, HttpMethodName.POST, PREFIX, blbListenerRequest.getBlbId(), blbListenerRequest.getType() + "listener");
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, blbListenerRequest.getClientToken());
        this.fillPayload(internalRequest, blbListenerRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListListenerResponse<TcpListener> listTcpListener(String blbId) {
        return this.listListener(new ListListenerRequest().withBlbId(blbId).withType("TCP"));
    }

    public ListListenerResponse<UdpListener> listUdpListener(String blbId) {
        return this.listListener(new ListListenerRequest().withBlbId(blbId).withType("UDP"));
    }

    public ListListenerResponse<HttpListener> listHttpListener(String blbId) {
        return this.listListener(new ListListenerRequest().withBlbId(blbId).withType("HTTP"));
    }

    public ListListenerResponse<HttpsListener> listHttpsListener(String blbId) {
        return this.listListener(new ListListenerRequest().withBlbId(blbId).withType("HTTPS"));
    }

    public ListListenerResponse<SslListener> listSslListener(String blbId) {
        return this.listListener(new ListListenerRequest().withBlbId(blbId).withType("SSL"));
    }

    public ListListenerResponse listListener(ListListenerRequest listListenerRequest) {
        Preconditions.checkNotNull((Object)listListenerRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)listListenerRequest.getType(), (Object)"listener type should not be null.");
        if (!ListenerConstant.LISTENER_SET.contains(listListenerRequest.getType())) {
            throw new IllegalArgumentException("listener type is illegal.");
        }
        InternalRequest internalRequest = this.createRequest(listListenerRequest, HttpMethodName.GET, PREFIX, listListenerRequest.getBlbId(), listListenerRequest.getType() + "listener");
        if (listListenerRequest.getListenerPort() != 0) {
            internalRequest.addParameter("listenerPort", String.valueOf(listListenerRequest.getListenerPort()));
        }
        if (listListenerRequest.getMarker() != null) {
            internalRequest.addParameter("marker", listListenerRequest.getMarker());
        }
        if (listListenerRequest.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(listListenerRequest.getMaxKeys()));
        }
        return this.invokeHttpClient(internalRequest, ListListenerResponse.class);
    }

    public void modifyListenerAttributes(BlbListenerRequest modifyListenerAttributesRequest) {
        Preconditions.checkNotNull((Object)modifyListenerAttributesRequest, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)modifyListenerAttributesRequest.getClientToken())) {
            modifyListenerAttributesRequest.setClientToken(this.generateClientToken());
        }
        Preconditions.checkNotNull((Object)modifyListenerAttributesRequest.getType(), (Object)"listener type should not be null.");
        if (!ListenerConstant.LISTENER_SET.contains(modifyListenerAttributesRequest.getType())) {
            throw new IllegalArgumentException("listener type is illegal.");
        }
        InternalRequest internalRequest = this.createRequest(modifyListenerAttributesRequest, HttpMethodName.PUT, PREFIX, modifyListenerAttributesRequest.getBlbId(), modifyListenerAttributesRequest.getType() + "listener");
        internalRequest.addParameter("listenerPort", String.valueOf(modifyListenerAttributesRequest.getListenerPort()));
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, modifyListenerAttributesRequest.getClientToken());
        this.fillPayload(internalRequest, modifyListenerAttributesRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteListener(String blbId, List<Integer> portList) {
        this.deleteListener(new DeleteListenerRequest(blbId, portList));
    }

    public void deleteListener(DeleteListenerRequest deleteListenerRequest) {
        Preconditions.checkNotNull((Object)deleteListenerRequest, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)deleteListenerRequest.getClientToken())) {
            deleteListenerRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(deleteListenerRequest, HttpMethodName.PUT, PREFIX, deleteListenerRequest.getBlbId(), "listener");
        internalRequest.addParameter(BlbListenerAction.batchdelete.name(), null);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, deleteListenerRequest.getClientToken());
        this.fillPayload(internalRequest, deleteListenerRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void createBlbRs(String blbId, String sgId, List<AppBackendServer> backendServerList) {
        this.createBlbRs(new AppSgRequest().withBlbId(blbId).withSgId(sgId).withBackendServerList(backendServerList));
    }

    public void createBlbRs(AppSgRequest appSgRequest) {
        Preconditions.checkNotNull((Object)appSgRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)appSgRequest.getBlbId(), (Object)"request blbId should not be null.");
        Preconditions.checkNotNull((Object)appSgRequest.getSgId(), (Object)"request sgId should not be null.");
        Preconditions.checkNotNull(appSgRequest.getBackendServerList(), (Object)"request backendServerList should not be null.");
        if (Strings.isNullOrEmpty((String)appSgRequest.getClientToken())) {
            appSgRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(appSgRequest, HttpMethodName.POST, PREFIX, appSgRequest.getBlbId(), "blbrs");
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, appSgRequest.getClientToken());
        this.fillPayload(internalRequest, appSgRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void createIpGroupMember(String blbId, String ipGroupId, List<AppIpGroupMember> memberList) {
        this.createIpGroupMember(new AppIgRequest().withBlbId(blbId).withIpGroupId(ipGroupId).withMemberList(memberList));
    }

    public void createIpGroupMember(AppIgRequest appIgRequest) {
        Preconditions.checkNotNull((Object)appIgRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)appIgRequest.getBlbId(), (Object)"request blbId should not be null.");
        Preconditions.checkNotNull((Object)appIgRequest.getIpGroupId(), (Object)"request ipGroupId should not be null.");
        Preconditions.checkNotNull(appIgRequest.getMemberList(), (Object)"request memberList should not be null.");
        if (Strings.isNullOrEmpty((String)appIgRequest.getClientToken())) {
            appIgRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(appIgRequest, HttpMethodName.POST, PREFIX, appIgRequest.getBlbId(), "ipgroup", "member");
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, appIgRequest.getClientToken());
        this.fillPayload(internalRequest, appIgRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListBackendServerStatusResponse listBackendServerStatus(String blbId, int listenerPort) {
        return this.listBackendServerStatus(new ListBackendServerStatusRequest(blbId, listenerPort));
    }

    public ListBackendServerStatusResponse listBackendServerStatus(ListBackendServerStatusRequest listBackendServerStatusRequest) {
        Preconditions.checkNotNull((Object)listBackendServerStatusRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(listBackendServerStatusRequest, HttpMethodName.GET, PREFIX, listBackendServerStatusRequest.getBlbId(), "backendserver");
        internalRequest.addParameter("listenerPort", String.valueOf(listBackendServerStatusRequest.getListenerPort()));
        if (listBackendServerStatusRequest.getMarker() != null) {
            internalRequest.addParameter("marker", listBackendServerStatusRequest.getMarker());
        }
        if (listBackendServerStatusRequest.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(listBackendServerStatusRequest.getMaxKeys()));
        }
        return this.invokeHttpClient(internalRequest, ListBackendServerStatusResponse.class);
    }

    public ListAppSgResponse listAppServerGroup(String blbId, String name) {
        return this.listAppServerGroup(new ListAppSgRequest(blbId).withName(name));
    }

    public ListAppSgResponse listAppServerGroup(ListAppSgRequest listAppSgRequest) {
        Preconditions.checkNotNull((Object)listAppSgRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(listAppSgRequest, HttpMethodName.GET, PREFIX, listAppSgRequest.getBlbId(), "appservergroup");
        if (StringUtils.isNotEmpty((CharSequence)listAppSgRequest.getName())) {
            internalRequest.addParameter("name", listAppSgRequest.getName());
        }
        if (listAppSgRequest.getMarker() != null) {
            internalRequest.addParameter("marker", listAppSgRequest.getMarker());
        }
        if (listAppSgRequest.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(listAppSgRequest.getMaxKeys()));
        }
        return this.invokeHttpClient(internalRequest, ListAppSgResponse.class);
    }

    public ListAppIgResponse listAppIpGroup(String blbId, String name) {
        return this.listAppIpGroup(new ListAppIgRequest(blbId).withName(name));
    }

    public ListAppIgResponse listAppIpGroup(ListAppIgRequest listAppIgRequest) {
        Preconditions.checkNotNull((Object)listAppIgRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(listAppIgRequest, HttpMethodName.GET, PREFIX, listAppIgRequest.getBlbId(), "ipgroup");
        if (StringUtils.isNotEmpty((CharSequence)listAppIgRequest.getName())) {
            internalRequest.addParameter("name", listAppIgRequest.getName());
        }
        if (listAppIgRequest.getMarker() != null) {
            internalRequest.addParameter("marker", listAppIgRequest.getMarker());
        }
        if (listAppIgRequest.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(listAppIgRequest.getMaxKeys()));
        }
        return this.invokeHttpClient(internalRequest, ListAppIgResponse.class);
    }

    public List<AppBackendServer> listBlbRsMount(String blbId, String sgId) {
        return this.listBlbRsMount(new ListAppRsRequest(blbId).withSgId(sgId));
    }

    public List<AppBackendServer> listBlbRsMount(ListAppRsRequest listAppRsRequest) {
        Preconditions.checkNotNull((Object)listAppRsRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)listAppRsRequest.getBlbId(), (Object)"request blbId should not be null.");
        Preconditions.checkNotNull((Object)listAppRsRequest.getSgId(), (Object)"request sgId should not be null.");
        InternalRequest internalRequest = this.createRequest(listAppRsRequest, HttpMethodName.GET, PREFIX, listAppRsRequest.getBlbId(), "blbrsmount");
        internalRequest.addParameter("sgId", listAppRsRequest.getSgId());
        return this.invokeHttpClient(internalRequest, ListAppRsResponse.class).getBackendServerList();
    }

    public List<AppBackendServer> listBlbRsUnMount(String blbId, String sgId) {
        return this.listBlbRsUnMount(new ListAppRsRequest(blbId).withSgId(sgId));
    }

    public List<AppBackendServer> listBlbRsUnMount(ListAppRsRequest listAppRsRequest) {
        Preconditions.checkNotNull((Object)listAppRsRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)listAppRsRequest.getBlbId(), (Object)"request blbId should not be null.");
        Preconditions.checkNotNull((Object)listAppRsRequest.getSgId(), (Object)"request sgId should not be null.");
        InternalRequest internalRequest = this.createRequest(listAppRsRequest, HttpMethodName.GET, PREFIX, listAppRsRequest.getBlbId(), "blbrsunmount");
        internalRequest.addParameter("sgId", listAppRsRequest.getSgId());
        return this.invokeHttpClient(internalRequest, ListAppRsResponse.class).getBackendServerList();
    }

    public ListAppRsResponse listBlbRs(String blbId, String sgId) {
        return this.listBlbRs(new ListAppRsRequest(blbId).withSgId(sgId));
    }

    public ListAppRsResponse listBlbRs(ListAppRsRequest listAppRsRequest) {
        Preconditions.checkNotNull((Object)listAppRsRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)listAppRsRequest.getBlbId(), (Object)"request blbId should not be null.");
        Preconditions.checkNotNull((Object)listAppRsRequest.getSgId(), (Object)"request sgId should not be null.");
        InternalRequest internalRequest = this.createRequest(listAppRsRequest, HttpMethodName.GET, PREFIX, listAppRsRequest.getBlbId(), "blbrs");
        internalRequest.addParameter("sgId", listAppRsRequest.getSgId());
        if (listAppRsRequest.getMarker() != null) {
            internalRequest.addParameter("marker", listAppRsRequest.getMarker());
        }
        if (listAppRsRequest.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(listAppRsRequest.getMaxKeys()));
        }
        return this.invokeHttpClient(internalRequest, ListAppRsResponse.class);
    }

    public ListAppIpGroupMemberResponse listIpGroupMember(String blbId, String ipGroupId) {
        return this.listIpGroupMember(new ListAppIpGroupMemberRequest(blbId).withIpGroupId(ipGroupId));
    }

    public ListAppIpGroupMemberResponse listIpGroupMember(ListAppIpGroupMemberRequest listAppIpGroupMemberRequest) {
        Preconditions.checkNotNull((Object)listAppIpGroupMemberRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)listAppIpGroupMemberRequest.getBlbId(), (Object)"request blbId should not be null.");
        Preconditions.checkNotNull((Object)listAppIpGroupMemberRequest.getIpGroupId(), (Object)"request ipGroupId should not be null.");
        InternalRequest internalRequest = this.createRequest(listAppIpGroupMemberRequest, HttpMethodName.GET, PREFIX, listAppIpGroupMemberRequest.getBlbId(), "ipgroup", "member");
        internalRequest.addParameter("ipGroupId", listAppIpGroupMemberRequest.getIpGroupId());
        if (listAppIpGroupMemberRequest.getMarker() != null) {
            internalRequest.addParameter("marker", listAppIpGroupMemberRequest.getMarker());
        }
        if (listAppIpGroupMemberRequest.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(listAppIpGroupMemberRequest.getMaxKeys()));
        }
        return this.invokeHttpClient(internalRequest, ListAppIpGroupMemberResponse.class);
    }

    public void modifyBlbRs(String blbId, String sgId, List<AppBackendServer> backendServerList) {
        this.modifyBlbRs(new AppSgRequest().withBlbId(blbId).withSgId(sgId).withBackendServerList(backendServerList));
    }

    public void modifyBlbRs(AppSgRequest appSgRequest) {
        Preconditions.checkNotNull((Object)appSgRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)appSgRequest.getBlbId(), (Object)"request blbId should not be null.");
        Preconditions.checkNotNull((Object)appSgRequest.getSgId(), (Object)"request sgId should not be null.");
        Preconditions.checkNotNull(appSgRequest.getBackendServerList(), (Object)"request backendServerList should not be null.");
        if (Strings.isNullOrEmpty((String)appSgRequest.getClientToken())) {
            appSgRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(appSgRequest, HttpMethodName.PUT, PREFIX, appSgRequest.getBlbId(), "blbrs");
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, appSgRequest.getClientToken());
        this.fillPayload(internalRequest, appSgRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void modifyIpGroupMember(String blbId, String ipGroupId, List<AppIpGroupMember> memberList) {
        this.modifyIpGroupMember(new AppIgRequest().withBlbId(blbId).withIpGroupId(ipGroupId).withMemberList(memberList));
    }

    public void modifyIpGroupMember(AppIgRequest appIgRequest) {
        Preconditions.checkNotNull((Object)appIgRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)appIgRequest.getBlbId(), (Object)"request blbId should not be null.");
        Preconditions.checkNotNull((Object)appIgRequest.getIpGroupId(), (Object)"request ipGroupId should not be null.");
        Preconditions.checkNotNull(appIgRequest.getMemberList(), (Object)"request memberList should not be null.");
        if (Strings.isNullOrEmpty((String)appIgRequest.getClientToken())) {
            appIgRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(appIgRequest, HttpMethodName.PUT, PREFIX, appIgRequest.getBlbId(), "ipgroup", "member");
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, appIgRequest.getClientToken());
        this.fillPayload(internalRequest, appIgRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteBlbRs(String blbId, String sgId, List<String> backendServerIdList) {
        this.deleteBlbRs(new AppRsRequest().withBlbId(blbId).withSgId(sgId).withBackendServerIdList(backendServerIdList));
    }

    public void deleteBlbRs(AppRsRequest appRsRequest) {
        Preconditions.checkNotNull((Object)appRsRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)appRsRequest.getBlbId(), (Object)"request blbId should not be null.");
        Preconditions.checkNotNull((Object)appRsRequest.getSgId(), (Object)"request sgId should not be null.");
        Preconditions.checkNotNull(appRsRequest.getBackendServerIdList(), (Object)"request backendServerIdList should not be null.");
        if (Strings.isNullOrEmpty((String)appRsRequest.getClientToken())) {
            appRsRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(appRsRequest, HttpMethodName.PUT, PREFIX, appRsRequest.getBlbId(), "blbrs");
        internalRequest.addParameter("batchdelete", null);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, appRsRequest.getClientToken());
        this.fillPayload(internalRequest, appRsRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteIpGroupMember(String blbId, String ipGroupId, List<String> memberIdList) {
        this.deleteIpGroupMember(new AppIpGroupMemberRequest().withBlbId(blbId).withIpGroupId(ipGroupId).withMemberIdList(memberIdList));
    }

    public void deleteIpGroupMember(AppIpGroupMemberRequest appIpGroupMemberRequest) {
        Preconditions.checkNotNull((Object)appIpGroupMemberRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)appIpGroupMemberRequest.getBlbId(), (Object)"request blbId should not be null.");
        Preconditions.checkNotNull((Object)appIpGroupMemberRequest.getIpGroupId(), (Object)"request ipGroupId should not be null.");
        Preconditions.checkNotNull(appIpGroupMemberRequest.getMemberIdList(), (Object)"request memberIdList should not be null.");
        if (Strings.isNullOrEmpty((String)appIpGroupMemberRequest.getClientToken())) {
            appIpGroupMemberRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(appIpGroupMemberRequest, HttpMethodName.PUT, PREFIX, appIpGroupMemberRequest.getBlbId(), "ipgroup", "member");
        internalRequest.addParameter("delete", null);
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, appIpGroupMemberRequest.getClientToken());
        this.fillPayload(internalRequest, appIpGroupMemberRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public AppSgResponse createAppServerGroup(String blbId, String name, String desc, List<AppBackendServer> backendServerList) {
        return this.createAppServerGroup(new AppSgRequest().withBlbId(blbId).withName(name).withDesc(desc).withBackendServerList(backendServerList));
    }

    public AppSgResponse createAppServerGroup(AppSgRequest appSgRequest) {
        Preconditions.checkNotNull((Object)appSgRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)appSgRequest.getBlbId(), (Object)"request blbId should not be null.");
        if (Strings.isNullOrEmpty((String)appSgRequest.getClientToken())) {
            appSgRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(appSgRequest, HttpMethodName.POST, PREFIX, appSgRequest.getBlbId(), "appservergroup");
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, appSgRequest.getClientToken());
        this.fillPayload(internalRequest, appSgRequest);
        return this.invokeHttpClient(internalRequest, AppSgResponse.class);
    }

    public AppIgResponse createAppIpGroup(AppIgRequest appIgRequest) {
        Preconditions.checkNotNull((Object)appIgRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)appIgRequest.getBlbId(), (Object)"request blbId should not be null.");
        if (Strings.isNullOrEmpty((String)appIgRequest.getClientToken())) {
            appIgRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(appIgRequest, HttpMethodName.POST, PREFIX, appIgRequest.getBlbId(), "ipgroup");
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, appIgRequest.getClientToken());
        this.fillPayload(internalRequest, appIgRequest);
        return this.invokeHttpClient(internalRequest, AppIgResponse.class);
    }

    public AppIgResponse createAppIpGroup(String blbId, String name, String desc, List<AppIpGroupMember> memberList) {
        return this.createAppIpGroup(new AppIgRequest().withBlbId(blbId).withName(name).withDesc(desc).withMemberList(memberList));
    }

    public void modifyAppServerGroupAttributes(String blbId, String sgId, String name, String desc) {
        this.modifyAppServerGroupAttributes(new AppSgRequest().withBlbId(blbId).withSgId(sgId).withName(name).withDesc(desc));
    }

    public void modifyAppServerGroupAttributes(AppSgRequest appSgRequest) {
        Preconditions.checkNotNull((Object)appSgRequest, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)appSgRequest.getClientToken())) {
            appSgRequest.setClientToken(this.generateClientToken());
        }
        Preconditions.checkNotNull((Object)appSgRequest.getBlbId(), (Object)"blbId should not be null.");
        Preconditions.checkNotNull((Object)appSgRequest.getSgId(), (Object)"sgId should not be null.");
        InternalRequest internalRequest = this.createRequest(appSgRequest, HttpMethodName.PUT, PREFIX, appSgRequest.getBlbId(), "appservergroup");
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, appSgRequest.getClientToken());
        this.fillPayload(internalRequest, appSgRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void modifyAppIpGroupAttributes(String blbId, String ipGroupId, String name, String desc) {
        this.modifyAppIpGroupAttributes(new AppIgRequest().withBlbId(blbId).withIpGroupId(ipGroupId).withName(name).withDesc(desc));
    }

    public void modifyAppIpGroupAttributes(AppIgRequest appIgRequest) {
        Preconditions.checkNotNull((Object)appIgRequest, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)appIgRequest.getClientToken())) {
            appIgRequest.setClientToken(this.generateClientToken());
        }
        Preconditions.checkNotNull((Object)appIgRequest.getBlbId(), (Object)"blbId should not be null.");
        Preconditions.checkNotNull((Object)appIgRequest.getIpGroupId(), (Object)"ipGroupId should not be null.");
        InternalRequest internalRequest = this.createRequest(appIgRequest, HttpMethodName.PUT, PREFIX, appIgRequest.getBlbId(), "ipgroup");
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, appIgRequest.getClientToken());
        this.fillPayload(internalRequest, appIgRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteAppServerGroup(String blbId, String sgId) {
        this.deleteAppServerGroup(new AppSgRequest().withBlbId(blbId).withSgId(sgId));
    }

    public void deleteAppServerGroup(AppSgRequest appSgRequest) {
        Preconditions.checkNotNull((Object)appSgRequest, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)appSgRequest.getClientToken())) {
            appSgRequest.setClientToken(this.generateClientToken());
        }
        Preconditions.checkNotNull((Object)appSgRequest.getBlbId(), (Object)"blbId should not be null.");
        Preconditions.checkNotNull((Object)appSgRequest.getSgId(), (Object)"sgId should not be null.");
        InternalRequest internalRequest = this.createRequest(appSgRequest, HttpMethodName.PUT, PREFIX, appSgRequest.getBlbId(), "appservergroup");
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, appSgRequest.getClientToken());
        internalRequest.addParameter("delete", null);
        this.fillPayload(internalRequest, appSgRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteAppIpGroup(String blbId, String ipGroupId) {
        this.deleteAppIpGroup(new AppIgRequest().withBlbId(blbId).withIpGroupId(ipGroupId));
    }

    public void deleteAppIpGroup(AppIgRequest appIgRequest) {
        Preconditions.checkNotNull((Object)appIgRequest, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)appIgRequest.getClientToken())) {
            appIgRequest.setClientToken(this.generateClientToken());
        }
        Preconditions.checkNotNull((Object)appIgRequest.getBlbId(), (Object)"blbId should not be null.");
        Preconditions.checkNotNull((Object)appIgRequest.getIpGroupId(), (Object)"ipGroupId should not be null.");
        InternalRequest internalRequest = this.createRequest(appIgRequest, HttpMethodName.PUT, PREFIX, appIgRequest.getBlbId(), "ipgroup");
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, appIgRequest.getClientToken());
        internalRequest.addParameter("delete", null);
        this.fillPayload(internalRequest, appIgRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void createAppIpGroupBackendPolicy(AppBackendPolicyRequest appBackendPolicyRequest) {
        Preconditions.checkNotNull((Object)appBackendPolicyRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)appBackendPolicyRequest.getBlbId(), (Object)"request blbId should not be null.");
        Preconditions.checkNotNull((Object)appBackendPolicyRequest.getIpGroupId(), (Object)"request ipGroupId should not be null.");
        Preconditions.checkNotNull((Object)appBackendPolicyRequest.getType(), (Object)"request type should not be null.");
        if (Strings.isNullOrEmpty((String)appBackendPolicyRequest.getClientToken())) {
            appBackendPolicyRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(appBackendPolicyRequest, HttpMethodName.POST, PREFIX, appBackendPolicyRequest.getBlbId(), "ipgroup", "backendpolicy");
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, appBackendPolicyRequest.getClientToken());
        this.fillPayload(internalRequest, appBackendPolicyRequest);
        this.invokeHttpClient(internalRequest, AppSgPortResponse.class);
    }

    public void modifyAppIpGroupBackendPolicyAttributes(AppBackendPolicyRequest appBackendPolicyRequest) {
        Preconditions.checkNotNull((Object)appBackendPolicyRequest, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)appBackendPolicyRequest.getClientToken())) {
            appBackendPolicyRequest.setClientToken(this.generateClientToken());
        }
        Preconditions.checkNotNull((Object)appBackendPolicyRequest.getBlbId(), (Object)"blbId should not be null.");
        Preconditions.checkNotNull((Object)appBackendPolicyRequest.getIpGroupId(), (Object)"ipGroupId should not be null.");
        Preconditions.checkNotNull((Object)appBackendPolicyRequest.getId(), (Object)"id should not be null.");
        InternalRequest internalRequest = this.createRequest(appBackendPolicyRequest, HttpMethodName.PUT, PREFIX, appBackendPolicyRequest.getBlbId(), "ipgroup", "backendpolicy");
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, appBackendPolicyRequest.getClientToken());
        this.fillPayload(internalRequest, appBackendPolicyRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteAppIpGroupBackendPolicy(String blbId, String ipGroupId, List<String> backendPolicyIdList) {
        this.deleteAppIpGroupBackendPolicy(new AppBackendPolicyRequest().withBlbId(blbId).withIpGroupId(ipGroupId).withBackendPolicyIdList(backendPolicyIdList));
    }

    public void deleteAppIpGroupBackendPolicy(AppBackendPolicyRequest appBackendPolicyRequest) {
        Preconditions.checkNotNull((Object)appBackendPolicyRequest, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)appBackendPolicyRequest.getClientToken())) {
            appBackendPolicyRequest.setClientToken(this.generateClientToken());
        }
        Preconditions.checkNotNull((Object)appBackendPolicyRequest.getBlbId(), (Object)"blbId should not be null.");
        Preconditions.checkNotNull((Object)appBackendPolicyRequest.getIpGroupId(), (Object)"ipGroupId should not be null.");
        Preconditions.checkNotNull(appBackendPolicyRequest.getBackendPolicyIdList(), (Object)"backendPolicyIdList should not be null.");
        InternalRequest internalRequest = this.createRequest(appBackendPolicyRequest, HttpMethodName.PUT, PREFIX, appBackendPolicyRequest.getBlbId(), "ipgroup", "backendpolicy");
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, appBackendPolicyRequest.getClientToken());
        internalRequest.addParameter("delete", null);
        this.fillPayload(internalRequest, appBackendPolicyRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public AppSgPortResponse createAppServerGroupPort(AppSgPortRequest appSgPortRequest) {
        Preconditions.checkNotNull((Object)appSgPortRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)appSgPortRequest.getBlbId(), (Object)"request blbId should not be null.");
        Preconditions.checkNotNull((Object)appSgPortRequest.getSgId(), (Object)"request sgId should not be null.");
        Preconditions.checkNotNull((Object)appSgPortRequest.getPort(), (Object)"request port should not be null.");
        Preconditions.checkNotNull((Object)appSgPortRequest.getType(), (Object)"request type should not be null.");
        if (Strings.isNullOrEmpty((String)appSgPortRequest.getClientToken())) {
            appSgPortRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(appSgPortRequest, HttpMethodName.POST, PREFIX, appSgPortRequest.getBlbId(), "appservergroupport");
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, appSgPortRequest.getClientToken());
        this.fillPayload(internalRequest, appSgPortRequest);
        return this.invokeHttpClient(internalRequest, AppSgPortResponse.class);
    }

    public void modifyAppServerGroupPortAttributes(AppSgPortRequest appSgPortRequest) {
        Preconditions.checkNotNull((Object)appSgPortRequest, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)appSgPortRequest.getClientToken())) {
            appSgPortRequest.setClientToken(this.generateClientToken());
        }
        Preconditions.checkNotNull((Object)appSgPortRequest.getBlbId(), (Object)"blbId should not be null.");
        Preconditions.checkNotNull((Object)appSgPortRequest.getSgId(), (Object)"sgId should not be null.");
        Preconditions.checkNotNull((Object)appSgPortRequest.getPortId(), (Object)"portId should not be null.");
        InternalRequest internalRequest = this.createRequest(appSgPortRequest, HttpMethodName.PUT, PREFIX, appSgPortRequest.getBlbId(), "appservergroupport");
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, appSgPortRequest.getClientToken());
        this.fillPayload(internalRequest, appSgPortRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteAppServerGroupPort(String blbId, String sgId, List<String> portIdList) {
        this.deleteAppServerGroupPort(new AppSgPortRequest().withBlbId(blbId).withSgId(sgId).withPortIdList(portIdList));
    }

    public void deleteAppServerGroupPort(AppSgPortRequest appSgPortRequest) {
        Preconditions.checkNotNull((Object)appSgPortRequest, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)appSgPortRequest.getClientToken())) {
            appSgPortRequest.setClientToken(this.generateClientToken());
        }
        Preconditions.checkNotNull((Object)appSgPortRequest.getBlbId(), (Object)"blbId should not be null.");
        Preconditions.checkNotNull((Object)appSgPortRequest.getSgId(), (Object)"sgId should not be null.");
        Preconditions.checkNotNull(appSgPortRequest.getPortIdList(), (Object)"portIdList should not be null.");
        InternalRequest internalRequest = this.createRequest(appSgPortRequest, HttpMethodName.PUT, PREFIX, appSgPortRequest.getBlbId(), "appservergroupport");
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, appSgPortRequest.getClientToken());
        internalRequest.addParameter("batchdelete", null);
        this.fillPayload(internalRequest, appSgPortRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public CreateAppPolicyResponse createPolicys(String blbId, Integer listenerPort, String type, List<AppPolicy> appPolicyVos) {
        return this.createPolicys(new AppPolicyRequest().withBlbId(blbId).withListenerPort(listenerPort).withType(type).withAppPolicyVos(appPolicyVos));
    }

    public CreateAppPolicyResponse createPolicys(AppPolicyRequest appPolicyRequest) {
        Preconditions.checkNotNull((Object)appPolicyRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)appPolicyRequest.getBlbId(), (Object)"request blbId should not be null.");
        Preconditions.checkNotNull((Object)appPolicyRequest.getListenerPort(), (Object)"request listenerPort should not be null.");
        Preconditions.checkNotNull(appPolicyRequest.getAppPolicyVos(), (Object)"request appPolicyVos should not be null.");
        if (Strings.isNullOrEmpty((String)appPolicyRequest.getClientToken())) {
            appPolicyRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(appPolicyRequest, HttpMethodName.POST, PREFIX, appPolicyRequest.getBlbId(), "policys");
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, appPolicyRequest.getClientToken());
        this.fillPayload(internalRequest, appPolicyRequest);
        return this.invokeHttpClient(internalRequest, CreateAppPolicyResponse.class);
    }

    public ListAppPolicyResponse listPolicys(String blbId, Integer port) {
        return this.listPolicys(new ListAppPolicyRequest().withBlbId(blbId).withPort(port));
    }

    public ListAppPolicyResponse listPolicys(ListAppPolicyRequest listAppPolicyRequest) {
        Preconditions.checkNotNull((Object)listAppPolicyRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)listAppPolicyRequest.getBlbId(), (Object)"request blbId should not be null.");
        Preconditions.checkNotNull((Object)listAppPolicyRequest.getPort(), (Object)"request port should not be null.");
        InternalRequest internalRequest = this.createRequest(listAppPolicyRequest, HttpMethodName.GET, PREFIX, listAppPolicyRequest.getBlbId(), "policys");
        internalRequest.addParameter("port", String.valueOf(listAppPolicyRequest.getPort()));
        if (listAppPolicyRequest.getMarker() != null) {
            internalRequest.addParameter("marker", listAppPolicyRequest.getMarker());
        }
        if (listAppPolicyRequest.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(listAppPolicyRequest.getMaxKeys()));
        }
        return this.invokeHttpClient(internalRequest, ListAppPolicyResponse.class);
    }

    public void deletePolicys(String blbId, Integer port, List<String> policyIdList) {
        this.deletePolicys(new DeleteAppPolicyRequest().withBlbId(blbId).withPort(port).withPolicyIdList(policyIdList));
    }

    public void deletePolicys(DeleteAppPolicyRequest deleteAppPolicyRequest) {
        Preconditions.checkNotNull((Object)deleteAppPolicyRequest, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)deleteAppPolicyRequest.getClientToken())) {
            deleteAppPolicyRequest.setClientToken(this.generateClientToken());
        }
        Preconditions.checkNotNull((Object)deleteAppPolicyRequest.getBlbId(), (Object)"blbId should not be null.");
        Preconditions.checkNotNull((Object)deleteAppPolicyRequest.getPort(), (Object)"port should not be null.");
        Preconditions.checkNotNull(deleteAppPolicyRequest.getPolicyIdList(), (Object)"policyIdList should not be null.");
        InternalRequest internalRequest = this.createRequest(deleteAppPolicyRequest, HttpMethodName.PUT, PREFIX, deleteAppPolicyRequest.getBlbId(), "policys");
        internalRequest.addParameter(CLIENT_TOKEN_IDENTIFY, deleteAppPolicyRequest.getClientToken());
        internalRequest.addParameter("batchdelete", null);
        this.fillPayload(internalRequest, deleteAppPolicyRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }
}

