/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.cdn;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.cdn.model.CdnRequest;
import com.baidubce.services.cdn.model.CdnResponse;
import com.baidubce.services.cdn.model.DescribeIpRequest;
import com.baidubce.services.cdn.model.DescribeIpResponse;
import com.baidubce.services.cdn.model.GetCacheQuotaRequest;
import com.baidubce.services.cdn.model.GetCacheQuotaResponse;
import com.baidubce.services.cdn.model.GetPrefetchStatusRequest;
import com.baidubce.services.cdn.model.GetPurgeStatusRequest;
import com.baidubce.services.cdn.model.GetPurgeStatusResponse;
import com.baidubce.services.cdn.model.GetStatAvgSpeedRequest;
import com.baidubce.services.cdn.model.GetStatAvgSpeedResponse;
import com.baidubce.services.cdn.model.GetStatFlowRequest;
import com.baidubce.services.cdn.model.GetStatFlowResponse;
import com.baidubce.services.cdn.model.GetStatHitRateRequest;
import com.baidubce.services.cdn.model.GetStatHitRateResponse;
import com.baidubce.services.cdn.model.GetStatHttpCodeRequest;
import com.baidubce.services.cdn.model.GetStatHttpCodeResponse;
import com.baidubce.services.cdn.model.GetStatMetricRequest;
import com.baidubce.services.cdn.model.GetStatMetricResponse;
import com.baidubce.services.cdn.model.GetStatPvRequest;
import com.baidubce.services.cdn.model.GetStatPvResponse;
import com.baidubce.services.cdn.model.GetStatSrcFlowRequest;
import com.baidubce.services.cdn.model.GetStatSrcFlowResponse;
import com.baidubce.services.cdn.model.GetStatTopRefererRequest;
import com.baidubce.services.cdn.model.GetStatTopRefererResponse;
import com.baidubce.services.cdn.model.GetStatTopUrlRequest;
import com.baidubce.services.cdn.model.GetStatTopUrlResponse;
import com.baidubce.services.cdn.model.GetStatUvRequest;
import com.baidubce.services.cdn.model.GetStatUvResponse;
import com.baidubce.services.cdn.model.ListDomainsRequest;
import com.baidubce.services.cdn.model.ListDomainsResponse;
import com.baidubce.services.cdn.model.OriginPeer;
import com.baidubce.services.cdn.model.PrefetchRequest;
import com.baidubce.services.cdn.model.PrefetchResponse;
import com.baidubce.services.cdn.model.PurgeRequest;
import com.baidubce.services.cdn.model.PurgeResponse;
import com.baidubce.services.cdn.model.PurgeTask;
import com.baidubce.services.cdn.model.SetDomainCacheTTLResponse;
import com.baidubce.services.cdn.model.SetDomainLimitRateRequest;
import com.baidubce.services.cdn.model.SetDomainOriginRequest;
import com.baidubce.services.cdn.model.SetHttpsConfigRequest;
import com.baidubce.services.cdn.model.cache.GetCacheDetailRequest;
import com.baidubce.services.cdn.model.cache.GetCacheRecordsResponse;
import com.baidubce.services.cdn.model.cache.GetPrefetchStatusResponse;
import com.baidubce.services.cdn.model.cache.PrefetchTask;
import com.baidubce.services.cdn.model.certificate.DelDomainCertResponse;
import com.baidubce.services.cdn.model.certificate.GetDomainCertResponse;
import com.baidubce.services.cdn.model.certificate.SetDomainCertRequest;
import com.baidubce.services.cdn.model.certificate.SetDomainCertResponse;
import com.baidubce.services.cdn.model.domain.CheckDomainValidResponse;
import com.baidubce.services.cdn.model.domain.CommonResponse;
import com.baidubce.services.cdn.model.domain.CreateDomainRequest;
import com.baidubce.services.cdn.model.domain.CreateDomainResponse;
import com.baidubce.services.cdn.model.domain.DeleteDomainRequest;
import com.baidubce.services.cdn.model.domain.DisableDomainRequest;
import com.baidubce.services.cdn.model.domain.DisableDomainResponse;
import com.baidubce.services.cdn.model.domain.DomainMiddleRequest;
import com.baidubce.services.cdn.model.domain.EnableDomainRequest;
import com.baidubce.services.cdn.model.domain.EnableDomainResponse;
import com.baidubce.services.cdn.model.domain.GetDomainAccessLimitResponse;
import com.baidubce.services.cdn.model.domain.GetDomainCacheFullUrlResponse;
import com.baidubce.services.cdn.model.domain.GetDomainCacheShareResponse;
import com.baidubce.services.cdn.model.domain.GetDomainCacheTTLRequest;
import com.baidubce.services.cdn.model.domain.GetDomainCacheTTLResponse;
import com.baidubce.services.cdn.model.domain.GetDomainClientIpResponse;
import com.baidubce.services.cdn.model.domain.GetDomainCompressResponse;
import com.baidubce.services.cdn.model.domain.GetDomainConfigRequest;
import com.baidubce.services.cdn.model.domain.GetDomainConfigResponse;
import com.baidubce.services.cdn.model.domain.GetDomainCorsResponse;
import com.baidubce.services.cdn.model.domain.GetDomainErrorPageResponse;
import com.baidubce.services.cdn.model.domain.GetDomainFileTrimResponse;
import com.baidubce.services.cdn.model.domain.GetDomainHSTSResponse;
import com.baidubce.services.cdn.model.domain.GetDomainHttpHeaderResponse;
import com.baidubce.services.cdn.model.domain.GetDomainIPv6DispatchResponse;
import com.baidubce.services.cdn.model.domain.GetDomainIpACLResponse;
import com.baidubce.services.cdn.model.domain.GetDomainLogRequest;
import com.baidubce.services.cdn.model.domain.GetDomainLogResponse;
import com.baidubce.services.cdn.model.domain.GetDomainMediaDragResponse;
import com.baidubce.services.cdn.model.domain.GetDomainMobileAccessResponse;
import com.baidubce.services.cdn.model.domain.GetDomainOCSPSwitchResponse;
import com.baidubce.services.cdn.model.domain.GetDomainOfflineModeSwitchResponse;
import com.baidubce.services.cdn.model.domain.GetDomainOriginProtocolRequest;
import com.baidubce.services.cdn.model.domain.GetDomainOriginProtocolResponse;
import com.baidubce.services.cdn.model.domain.GetDomainQUICSwitchResponse;
import com.baidubce.services.cdn.model.domain.GetDomainRangeSwitchResponse;
import com.baidubce.services.cdn.model.domain.GetDomainRefererACLResponse;
import com.baidubce.services.cdn.model.domain.GetDomainRetryOriginResponse;
import com.baidubce.services.cdn.model.domain.GetDomainSeoSwitchResponse;
import com.baidubce.services.cdn.model.domain.GetDomainTrafficLimitRequest;
import com.baidubce.services.cdn.model.domain.GetDomainTrafficLimitResponse;
import com.baidubce.services.cdn.model.domain.GetDomainUaAclRequest;
import com.baidubce.services.cdn.model.domain.GetDomainUaAclResponse;
import com.baidubce.services.cdn.model.domain.GetUserDomainResponse;
import com.baidubce.services.cdn.model.domain.GetUserDomainsRequest;
import com.baidubce.services.cdn.model.domain.HttpsConfig;
import com.baidubce.services.cdn.model.domain.RequestAuth;
import com.baidubce.services.cdn.model.domain.SetDomainAccessLimitRequest;
import com.baidubce.services.cdn.model.domain.SetDomainCacheFullUrlRequest;
import com.baidubce.services.cdn.model.domain.SetDomainCacheShareRequest;
import com.baidubce.services.cdn.model.domain.SetDomainCacheTTLRequest;
import com.baidubce.services.cdn.model.domain.SetDomainClientIpRequest;
import com.baidubce.services.cdn.model.domain.SetDomainCompressRequest;
import com.baidubce.services.cdn.model.domain.SetDomainCorsRequest;
import com.baidubce.services.cdn.model.domain.SetDomainErrorPageRequest;
import com.baidubce.services.cdn.model.domain.SetDomainFileTrimRequest;
import com.baidubce.services.cdn.model.domain.SetDomainFollowProtocolRequest;
import com.baidubce.services.cdn.model.domain.SetDomainHSTSRequest;
import com.baidubce.services.cdn.model.domain.SetDomainHttpHeaderRequest;
import com.baidubce.services.cdn.model.domain.SetDomainIPv6DispatchRequest;
import com.baidubce.services.cdn.model.domain.SetDomainIpACLRequest;
import com.baidubce.services.cdn.model.domain.SetDomainMediaDragRequest;
import com.baidubce.services.cdn.model.domain.SetDomainMobileAccessRequest;
import com.baidubce.services.cdn.model.domain.SetDomainOCSPRequest;
import com.baidubce.services.cdn.model.domain.SetDomainOfflineModeRequest;
import com.baidubce.services.cdn.model.domain.SetDomainOriginProtocolRequest;
import com.baidubce.services.cdn.model.domain.SetDomainQUICRequest;
import com.baidubce.services.cdn.model.domain.SetDomainRangeSwitchRequest;
import com.baidubce.services.cdn.model.domain.SetDomainRefererACLRequest;
import com.baidubce.services.cdn.model.domain.SetDomainRetryOriginRequest;
import com.baidubce.services.cdn.model.domain.SetDomainSeoSwitchRequest;
import com.baidubce.services.cdn.model.domain.SetDomainTrafficLimitRequest;
import com.baidubce.services.cdn.model.domain.SetDomainUaAclRequest;
import com.baidubce.services.cdn.model.domain.SetRequestAuthRequest;
import com.baidubce.services.cdn.model.dsa.GetDsaDomainListResponse;
import com.baidubce.services.cdn.model.dsa.SetDomainDsaRequest;
import com.baidubce.services.cdn.model.dsa.SetDsaRequest;
import com.baidubce.services.cdn.model.logmodel.GetDomainListLogRequest;
import com.baidubce.services.cdn.model.logmodel.GetDomainListLogResponse;
import com.baidubce.services.cdn.model.logmodel.GetDomainListLogTransRequest;
import com.baidubce.util.DateUtils;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;

public class CdnClient
extends AbstractBceClient {
    private static final String VERSION = "v2";
    private static final String DOMAIN = "domain";
    private static final String STAT = "stat";
    private static final String CACHE = "cache";
    private static final String LOG = "logmodel";
    private static final String UTILS = "utils";
    private static final String USER = "user";
    private static final String[] HEADERS_TO_SIGN = new String[]{"host", "x-bce-date"};
    private static final HttpResponseHandler[] cdnHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public CdnClient() {
        this(new BceClientConfiguration());
    }

    public CdnClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, cdnHandlers);
    }

    public CreateDomainResponse createDomain(CreateDomainRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain());
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CreateDomainResponse.class);
    }

    public void enableDomain(String domain) {
        this.enableDomain(new EnableDomainRequest().withDomain(domain));
    }

    public EnableDomainResponse enableDomain(EnableDomainRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DOMAIN, request.getDomain());
        internalRequest.addParameter("enable", "");
        return this.invokeHttpClient(internalRequest, EnableDomainResponse.class);
    }

    public void disableDomain(String domain) {
        this.disableDomain(new DisableDomainRequest().withDomain(domain));
    }

    public DisableDomainResponse disableDomain(DisableDomainRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DOMAIN, request.getDomain());
        internalRequest.addParameter("disable", "");
        return this.invokeHttpClient(internalRequest, DisableDomainResponse.class);
    }

    public void deleteDomain(String domain) {
        this.deleteDomain(new DeleteDomainRequest().withDomain(domain));
    }

    public CommonResponse deleteDomain(DeleteDomainRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, DOMAIN, request.getDomain());
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public ListDomainsResponse listDomains() {
        return this.listDomains(new ListDomainsRequest());
    }

    public ListDomainsResponse listDomains(ListDomainsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN);
        return this.invokeHttpClient(internalRequest, ListDomainsResponse.class);
    }

    public GetUserDomainResponse getUserDomains(String status) {
        return this.getUserDomains(new GetUserDomainsRequest().withStatus(status));
    }

    public GetUserDomainResponse getUserDomains(GetUserDomainsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, USER, "domains");
        internalRequest.addParameter("status", request.getStatus());
        if (request.getRule() != null) {
            internalRequest.addParameter("rule", request.getRule());
        }
        return this.invokeHttpClient(internalRequest, GetUserDomainResponse.class);
    }

    public CheckDomainValidResponse checkDomainValid(String domain) {
        return this.checkDomainValid(new DomainMiddleRequest().withDomain(domain));
    }

    public CheckDomainValidResponse checkDomainValid(DomainMiddleRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "valid");
        return this.invokeHttpClient(internalRequest, CheckDomainValidResponse.class);
    }

    public GetDomainConfigResponse getDomainConfig(String domain) {
        return this.getDomainConfig(new GetDomainConfigRequest().withDomain(domain));
    }

    public GetDomainConfigResponse getDomainConfig(GetDomainConfigRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        return this.invokeHttpClient(internalRequest, GetDomainConfigResponse.class);
    }

    public void setDomainOrigin(String domain, String peer) {
        ArrayList<OriginPeer> origin = new ArrayList<OriginPeer>();
        origin.add(new OriginPeer().withPeer(peer));
        SetDomainOriginRequest request = new SetDomainOriginRequest().withDomain(domain).withOrigin(origin);
        this.setDomainOrigin(request);
    }

    public CommonResponse setDomainOrigin(SetDomainOriginRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("origin", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public CommonResponse setDomainFollowProtocol(String domain, boolean followProtocol) {
        return this.setDomainFollowProtocol(new SetDomainFollowProtocolRequest().withDomain(domain).withFollowProtocol(followProtocol));
    }

    public CommonResponse setDomainFollowProtocol(SetDomainFollowProtocolRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("followProtocol", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public CommonResponse setDomainRangeSwitch(String domain, boolean rangeSwitch) {
        return this.setDomainRangeSwitch(new SetDomainRangeSwitchRequest().withDomain(domain).withRangeSwitch(rangeSwitch));
    }

    public CommonResponse setDomainRangeSwitch(SetDomainRangeSwitchRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("rangeSwitch", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainRangeSwitchResponse getDomainRangeSwitch(String domain) {
        return this.getDomainRangeSwitch(new DomainMiddleRequest().withDomain(domain));
    }

    public GetDomainRangeSwitchResponse getDomainRangeSwitch(DomainMiddleRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("rangeSwitch", "");
        return this.invokeHttpClient(internalRequest, GetDomainRangeSwitchResponse.class);
    }

    public CommonResponse setDomainMobileAccess(SetDomainMobileAccessRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("mobileAccess", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainMobileAccessResponse getDomainMobileAccess(String domain) {
        return this.getDomainMobileAccess(new DomainMiddleRequest().withDomain(domain));
    }

    public GetDomainMobileAccessResponse getDomainMobileAccess(DomainMiddleRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("mobileAccess", "");
        return this.invokeHttpClient(internalRequest, GetDomainMobileAccessResponse.class);
    }

    public CommonResponse setDomainHttpHeader(SetDomainHttpHeaderRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("httpHeader", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainHttpHeaderResponse getDomainHttpHeader(String domain) {
        return this.getDomainHttpHeader(new DomainMiddleRequest().withDomain(domain));
    }

    public GetDomainHttpHeaderResponse getDomainHttpHeader(DomainMiddleRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("httpHeader", "");
        return this.invokeHttpClient(internalRequest, GetDomainHttpHeaderResponse.class);
    }

    public CommonResponse setDomainSeoSwitch(SetDomainSeoSwitchRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("seoSwitch", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public CommonResponse setDomainOCSPSwitch(SetDomainOCSPRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("ocsp", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainOCSPSwitchResponse getDomainOCSPSwitch(String domain) {
        return this.getDomainOCSPSwitch(new DomainMiddleRequest().withDomain(domain));
    }

    public GetDomainOCSPSwitchResponse getDomainOCSPSwitch(DomainMiddleRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("ocsp", "");
        return this.invokeHttpClient(internalRequest, GetDomainOCSPSwitchResponse.class);
    }

    public CommonResponse setDomainQUICSwitch(String domain, SetDomainQUICRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, domain, "config");
        internalRequest.addParameter("quic", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainQUICSwitchResponse getDomainQUICSwitch(String domain) {
        return this.getDomainQUICSwitch(new DomainMiddleRequest().withDomain(domain));
    }

    public GetDomainQUICSwitchResponse getDomainQUICSwitch(DomainMiddleRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("quic", "");
        return this.invokeHttpClient(internalRequest, GetDomainQUICSwitchResponse.class);
    }

    public CommonResponse setDomainOfflineModeSwitch(String domain, SetDomainOfflineModeRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, domain, "config");
        internalRequest.addParameter("offlineMode", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainOfflineModeSwitchResponse getDomainOfflineModeSwitch(String domain) {
        return this.getDomainOfflineModeSwitch(new DomainMiddleRequest().withDomain(domain));
    }

    public GetDomainOfflineModeSwitchResponse getDomainOfflineModeSwitch(DomainMiddleRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("offlineMode", "");
        return this.invokeHttpClient(internalRequest, GetDomainOfflineModeSwitchResponse.class);
    }

    public GetDomainSeoSwitchResponse getDomainSeoSwitch(String domain) {
        return this.getDomainSeoSwitch(new DomainMiddleRequest().withDomain(domain));
    }

    public SetDomainCertResponse setDomainCert(String domain, SetDomainCertRequest request) {
        Validate.checkStringNotEmpty(domain, "The parameter domain should NOT be empty.");
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, domain, "certificates");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, SetDomainCertResponse.class);
    }

    public DelDomainCertResponse deleteDomainCert(String domain) {
        return this.deleteDomainCert(new DomainMiddleRequest().withDomain(domain));
    }

    public DelDomainCertResponse deleteDomainCert(DomainMiddleRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, request.getDomain(), "certificates");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, DelDomainCertResponse.class);
    }

    public GetDomainCertResponse getDomainCert(String domain) {
        return this.getDomainCert(new DomainMiddleRequest().withDomain(domain));
    }

    public GetDomainCertResponse getDomainCert(DomainMiddleRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, request.getDomain(), "certificates");
        return this.invokeHttpClient(internalRequest, GetDomainCertResponse.class);
    }

    public CommonResponse setDomainHSTS(String domain, SetDomainHSTSRequest request) {
        Validate.checkStringNotEmpty(domain, "The parameter domain should NOT be empty.");
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, domain, "config");
        internalRequest.addParameter("hsts", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainHSTSResponse getDomainHSTS(String domain) {
        return this.getDomainHSTS(new DomainMiddleRequest().withDomain(domain));
    }

    public GetDomainHSTSResponse getDomainHSTS(DomainMiddleRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("hsts", "");
        return this.invokeHttpClient(internalRequest, GetDomainHSTSResponse.class);
    }

    public CommonResponse setDomainIPv6Dispatch(String domain, SetDomainIPv6DispatchRequest request) {
        Validate.checkStringNotEmpty(domain, "The parameter domain should NOT be empty.");
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, domain, "config");
        internalRequest.addParameter("ipv6Dispatch", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainIPv6DispatchResponse getDomainIPv6Dispatch(String domain) {
        return this.getDomainIPv6Dispatch(new DomainMiddleRequest().withDomain(domain));
    }

    public GetDomainIPv6DispatchResponse getDomainIPv6Dispatch(DomainMiddleRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("ipv6Dispatch", "");
        return this.invokeHttpClient(internalRequest, GetDomainIPv6DispatchResponse.class);
    }

    public CommonResponse setDomainCacheShare(String domain, SetDomainCacheShareRequest request) {
        Validate.checkStringNotEmpty(domain, "The parameter domain should NOT be empty.");
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, domain, "config");
        internalRequest.addParameter("cacheShare", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainCacheShareResponse getDomainCacheShare(String domain) {
        return this.getDomainCacheShare(new DomainMiddleRequest().withDomain(domain));
    }

    public GetDomainCacheShareResponse getDomainCacheShare(DomainMiddleRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("cacheShare", "");
        return this.invokeHttpClient(internalRequest, GetDomainCacheShareResponse.class);
    }

    public GetDomainSeoSwitchResponse getDomainSeoSwitch(DomainMiddleRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("seoSwitch", "");
        return this.invokeHttpClient(internalRequest, GetDomainSeoSwitchResponse.class);
    }

    public void setDomainFileTrim(String domain, boolean fileTrim) {
        this.setDomainFileTrim(new SetDomainFileTrimRequest().withDomain(domain).withFileTrim(fileTrim));
    }

    public CommonResponse setDomainFileTrim(SetDomainFileTrimRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("fileTrim", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainFileTrimResponse getDomainFileTrim(String domain) {
        return this.getDomainFileTrim(new DomainMiddleRequest().withDomain(domain));
    }

    public GetDomainFileTrimResponse getDomainFileTrim(DomainMiddleRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("fileTrim", "");
        return this.invokeHttpClient(internalRequest, GetDomainFileTrimResponse.class);
    }

    public CommonResponse setDomainMediaDrag(SetDomainMediaDragRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("mediaDrag", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainMediaDragResponse getDomainMediaDrag(String domain) {
        return this.getDomainMediaDrag(new DomainMiddleRequest().withDomain(domain));
    }

    public GetDomainMediaDragResponse getDomainMediaDrag(DomainMiddleRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("mediaDrag", "");
        return this.invokeHttpClient(internalRequest, GetDomainMediaDragResponse.class);
    }

    public CommonResponse setDomainCompress(SetDomainCompressRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("compress", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainCompressResponse getDomainCompress(String domain) {
        return this.getDomainCompress(new DomainMiddleRequest().withDomain(domain));
    }

    public GetDomainCompressResponse getDomainCompress(DomainMiddleRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("compress", "");
        return this.invokeHttpClient(internalRequest, GetDomainCompressResponse.class);
    }

    public GetDomainCacheTTLResponse getDomainCacheTTL(String domain) {
        GetDomainCacheTTLRequest request = new GetDomainCacheTTLRequest().withDomain(domain);
        return this.getDomainCacheTTL(request);
    }

    public GetDomainCacheTTLResponse getDomainCacheTTL(GetDomainCacheTTLRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("cacheTTL", "");
        return this.invokeHttpClient(internalRequest, GetDomainCacheTTLResponse.class);
    }

    public SetDomainCacheTTLResponse setDomainCacheTTL(SetDomainCacheTTLRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("cacheTTL", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, SetDomainCacheTTLResponse.class);
    }

    public CommonResponse setDomainRetryOrigin(String domain, SetDomainRetryOriginRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, domain, "config");
        internalRequest.addParameter("retryOrigin", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainRetryOriginResponse getDomainRetryOrigin(String domain) {
        return this.getDomainRetryOrigin(new DomainMiddleRequest().withDomain(domain));
    }

    public GetDomainRetryOriginResponse getDomainRetryOrigin(DomainMiddleRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("retryOrigin", "");
        return this.invokeHttpClient(internalRequest, GetDomainRetryOriginResponse.class);
    }

    public void setDomainCacheFullUrl(String domain, boolean setting) {
        SetDomainCacheFullUrlRequest request = new SetDomainCacheFullUrlRequest().withDomain(domain);
        request.setCacheFullUrl(setting);
        this.setDomainCacheFullUrl(request);
    }

    public CommonResponse setDomainCacheFullUrl(SetDomainCacheFullUrlRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("cacheFullUrl", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainCacheFullUrlResponse getDomainCacheFullUrl(String domain) {
        return this.getDomainCacheFullUrl(new DomainMiddleRequest().withDomain(domain));
    }

    public GetDomainCacheFullUrlResponse getDomainCacheFullUrl(DomainMiddleRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("cacheFullUrl", "");
        return this.invokeHttpClient(internalRequest, GetDomainCacheFullUrlResponse.class);
    }

    public CommonResponse setDomainErrorPage(SetDomainErrorPageRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("errorPage", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainErrorPageResponse getDomainErrorPage(String domain) {
        return this.getDomainErrorPage(new DomainMiddleRequest().withDomain(domain));
    }

    public GetDomainErrorPageResponse getDomainErrorPage(DomainMiddleRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("errorPage", "");
        return this.invokeHttpClient(internalRequest, GetDomainErrorPageResponse.class);
    }

    public CommonResponse setDomainRefererACL(SetDomainRefererACLRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("refererACL", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainRefererACLResponse getDomainRefererACL(String domain) {
        return this.getDomainRefererACL(new DomainMiddleRequest().withDomain(domain));
    }

    public GetDomainRefererACLResponse getDomainRefererACL(DomainMiddleRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("refererACL", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, GetDomainRefererACLResponse.class);
    }

    public CommonResponse setDomainIpACL(SetDomainIpACLRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("ipACL", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainIpACLResponse getDomainIpACL(String domain) {
        return this.getDomainIpACL(new DomainMiddleRequest().withDomain(domain));
    }

    public GetDomainIpACLResponse getDomainIpACL(DomainMiddleRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("ipACL", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, GetDomainIpACLResponse.class);
    }

    public void setDomainLimitRate(String domain, int limitRate) {
        SetDomainLimitRateRequest request = new SetDomainLimitRateRequest().withDomain(domain).withLimitRate(limitRate);
        this.setDomainLimitRate(request);
    }

    public CommonResponse setDomainLimitRate(SetDomainLimitRateRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("limitRate", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public CommonResponse setDomainTrafficLimit(SetDomainTrafficLimitRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("trafficLimit", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainTrafficLimitResponse getDomainTrafficLimit(String domain) {
        GetDomainTrafficLimitRequest request = new GetDomainTrafficLimitRequest().withDomain(domain);
        return this.getTrafficLimit(request);
    }

    public GetDomainTrafficLimitResponse getTrafficLimit(GetDomainTrafficLimitRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("trafficLimit", "");
        return this.invokeHttpClient(internalRequest, GetDomainTrafficLimitResponse.class);
    }

    public CommonResponse setDomainUaAcl(SetDomainUaAclRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("uaAcl", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainUaAclResponse getDomainUaAcl(String domain) {
        GetDomainUaAclRequest request = new GetDomainUaAclRequest().withDomain(domain);
        return this.getDomainUaAcl(request);
    }

    public GetDomainUaAclResponse getDomainUaAcl(GetDomainUaAclRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("uaAcl", "");
        return this.invokeHttpClient(internalRequest, GetDomainUaAclResponse.class);
    }

    public CommonResponse setDomainCors(SetDomainCorsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("cors", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainCorsResponse getDomainCors(String domain) {
        return this.getDomainCors(new DomainMiddleRequest().withDomain(domain));
    }

    public GetDomainCorsResponse getDomainCors(DomainMiddleRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("cors", "");
        return this.invokeHttpClient(internalRequest, GetDomainCorsResponse.class);
    }

    public CommonResponse setDomainAccessLimit(SetDomainAccessLimitRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("accessLimit", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public CommonResponse setDomainOriginProtocol(SetDomainOriginProtocolRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("originProtocol", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainOriginProtocolResponse getDomainOriginProtocol(String domain) {
        GetDomainOriginProtocolRequest request = new GetDomainOriginProtocolRequest().withDomain(domain);
        return this.getDomainOriginProtocol(request);
    }

    public GetDomainOriginProtocolResponse getDomainOriginProtocol(GetDomainOriginProtocolRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("originProtocol", "");
        return this.invokeHttpClient(internalRequest, GetDomainOriginProtocolResponse.class);
    }

    public GetDomainAccessLimitResponse getDomainAccessLimit(String domain) {
        return this.getDomainAccessLimit(new DomainMiddleRequest().withDomain(domain));
    }

    public GetDomainAccessLimitResponse getDomainAccessLimit(DomainMiddleRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("accessLimit", "");
        return this.invokeHttpClient(internalRequest, GetDomainAccessLimitResponse.class);
    }

    public CommonResponse setDomainClientIp(SetDomainClientIpRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("clientIp", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDomainClientIpResponse getDomainClientIp(String domain) {
        return this.getDomainClientIp(new DomainMiddleRequest().withDomain(domain));
    }

    public GetDomainClientIpResponse getDomainClientIp(DomainMiddleRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("clientIp", "");
        return this.invokeHttpClient(internalRequest, GetDomainClientIpResponse.class);
    }

    public void setHttpsConfig(String domain, HttpsConfig https) {
        SetHttpsConfigRequest request = new SetHttpsConfigRequest().withDomain(domain).withHttps(https);
        this.setHttpsConfig(request);
    }

    public CommonResponse setHttpsConfig(SetHttpsConfigRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("https", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public void setRequestAuth(String domain, RequestAuth requestAuth) {
        SetRequestAuthRequest request = new SetRequestAuthRequest().withDomain(domain).withRequestAuth(requestAuth);
        this.setRequestAuth(request);
    }

    public CommonResponse setRequestAuth(SetRequestAuthRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("requestAuth", "");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public PrefetchResponse prefetch(String url) {
        return this.prefetch(new PrefetchRequest().addTask(new PrefetchTask().withUrl(url)));
    }

    public PrefetchResponse prefetch(PrefetchRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, CACHE, "prefetch");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, PrefetchResponse.class);
    }

    public PurgeResponse purge(String url) {
        return this.purge(new PurgeRequest().addTask(new PurgeTask().withUrl(url)));
    }

    public PurgeResponse purgeDirectory(String directory) {
        return this.purge(new PurgeRequest().addTask(new PurgeTask().withDirectory(directory)));
    }

    public PurgeResponse purge(PurgeRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, CACHE, "purge");
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, PurgeResponse.class);
    }

    public GetPurgeStatusResponse getPurgeStatus(GetPurgeStatusRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CACHE, "purge");
        if (request.getId() != null) {
            internalRequest.addParameter("id", request.getId());
        }
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        if (request.getMarker() != null) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getUrl() != null) {
            internalRequest.addParameter("url", request.getUrl());
        }
        return this.invokeHttpClient(internalRequest, GetPurgeStatusResponse.class);
    }

    public GetPrefetchStatusResponse getPrefetchStatus(GetPrefetchStatusRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CACHE, "prefetch");
        if (request.getId() != null) {
            internalRequest.addParameter("id", request.getId());
        }
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        if (request.getMarker() != null) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getUrl() != null) {
            internalRequest.addParameter("url", request.getUrl());
        }
        return this.invokeHttpClient(internalRequest, GetPrefetchStatusResponse.class);
    }

    public GetStatPvResponse getStatPv(GetStatPvRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, STAT, "pv");
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        if (request.getDomain() != null) {
            internalRequest.addParameter(DOMAIN, request.getDomain());
        }
        if (request.getPeriod() != null) {
            internalRequest.addParameter("period", String.valueOf(request.getPeriod()));
        }
        if (request.isWithRegion()) {
            internalRequest.addParameter("withRegion", String.valueOf(request.isWithRegion()));
        }
        return this.invokeHttpClient(internalRequest, GetStatPvResponse.class);
    }

    public GetStatFlowResponse getStatFlow(GetStatFlowRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, STAT, "flow");
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        if (request.getDomain() != null) {
            internalRequest.addParameter(DOMAIN, request.getDomain());
        }
        if (request.getPeriod() != null) {
            internalRequest.addParameter("period", String.valueOf(request.getPeriod()));
        }
        if (request.getLevel() != null) {
            internalRequest.addParameter("level", request.getLevel());
        }
        if (request.getProv() != null) {
            internalRequest.addParameter("prov", request.getProv());
        }
        if (request.getIsp() != null) {
            internalRequest.addParameter("isp", request.getIsp());
        }
        if (request.isWithRegion()) {
            internalRequest.addParameter("withRegion", String.valueOf(request.isWithRegion()));
        }
        return this.invokeHttpClient(internalRequest, GetStatFlowResponse.class);
    }

    public GetStatSrcFlowResponse getStatSrcFlow(GetStatSrcFlowRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, STAT, "srcflow");
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        if (request.getDomain() != null) {
            internalRequest.addParameter(DOMAIN, request.getDomain());
        }
        if (request.getPeriod() != null) {
            internalRequest.addParameter("period", String.valueOf(request.getPeriod()));
        }
        return this.invokeHttpClient(internalRequest, GetStatSrcFlowResponse.class);
    }

    public GetStatHitRateResponse getStatHitRate(GetStatHitRateRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, STAT, "hitrate");
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        if (request.getDomain() != null) {
            internalRequest.addParameter(DOMAIN, request.getDomain());
        }
        if (request.getPeriod() != null) {
            internalRequest.addParameter("period", String.valueOf(request.getPeriod()));
        }
        return this.invokeHttpClient(internalRequest, GetStatHitRateResponse.class);
    }

    public GetStatHttpCodeResponse getStatHttpCode(GetStatHttpCodeRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, STAT, "httpcode");
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        if (request.getDomain() != null) {
            internalRequest.addParameter(DOMAIN, request.getDomain());
        }
        if (request.getPeriod() != null) {
            internalRequest.addParameter("period", String.valueOf(request.getPeriod()));
        }
        if (request.isWithRegion()) {
            internalRequest.addParameter("withRegion", String.valueOf(request.isWithRegion()));
        }
        return this.invokeHttpClient(internalRequest, GetStatHttpCodeResponse.class);
    }

    public GetStatTopUrlResponse getStatTopUrl(GetStatTopUrlRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, STAT, "topn", "url");
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        if (request.getDomain() != null) {
            internalRequest.addParameter(DOMAIN, request.getDomain());
        }
        if (request.getPeriod() != null) {
            internalRequest.addParameter("period", String.valueOf(request.getPeriod()));
        }
        return this.invokeHttpClient(internalRequest, GetStatTopUrlResponse.class);
    }

    public GetStatTopRefererResponse getStatTopReferer(GetStatTopRefererRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, STAT, "topn", "referer");
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        if (request.getDomain() != null) {
            internalRequest.addParameter(DOMAIN, request.getDomain());
        }
        if (request.getPeriod() != null) {
            internalRequest.addParameter("period", String.valueOf(request.getPeriod()));
        }
        return this.invokeHttpClient(internalRequest, GetStatTopRefererResponse.class);
    }

    public GetStatUvResponse getStatUv(GetStatUvRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, STAT, "uv");
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        if (request.getDomain() != null) {
            internalRequest.addParameter(DOMAIN, request.getDomain());
        }
        if (request.getPeriod() != null) {
            internalRequest.addParameter("period", String.valueOf(request.getPeriod()));
        }
        return this.invokeHttpClient(internalRequest, GetStatUvResponse.class);
    }

    public GetStatAvgSpeedResponse getStatAvgSpeed(GetStatAvgSpeedRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, STAT, "avgspeed");
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        if (request.getDomain() != null) {
            internalRequest.addParameter(DOMAIN, request.getDomain());
        }
        if (request.getPeriod() != null) {
            internalRequest.addParameter("period", String.valueOf(request.getPeriod()));
        }
        return this.invokeHttpClient(internalRequest, GetStatAvgSpeedResponse.class);
    }

    public GetCacheQuotaResponse getCacheQuota() {
        GetCacheQuotaRequest request = new GetCacheQuotaRequest();
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CACHE, "quota");
        return this.invokeHttpClient(internalRequest, GetCacheQuotaResponse.class);
    }

    public GetCacheQuotaResponse getCacheQuota(GetCacheQuotaRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CACHE, "quota");
        return this.invokeHttpClient(internalRequest, GetCacheQuotaResponse.class);
    }

    public GetCacheRecordsResponse getCacheRecords(GetCacheDetailRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CACHE, "records");
        this.validateAndFillRequestUrl(internalRequest, request.getType(), request.getStartTime(), request.getEndTime(), request.getUrl(), request.getMarker());
        return this.invokeHttpClient(internalRequest, GetCacheRecordsResponse.class);
    }

    public void setDsa(SetDsaRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, "dsa");
        this.attachRequestToBody(request, internalRequest);
        this.invokeHttpClient(internalRequest, CommonResponse.class);
    }

    public GetDsaDomainListResponse getDsaDomainList() {
        CdnRequest request = new CdnRequest();
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, "dsa", DOMAIN);
        return this.invokeHttpClient(internalRequest, GetDsaDomainListResponse.class);
    }

    public void setDomainDsa(SetDomainDsaRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DOMAIN, request.getDomain(), "config");
        internalRequest.addParameter("dsa", "");
        this.attachRequestToBody(request, internalRequest);
        this.invokeHttpClient(internalRequest, CdnResponse.class);
    }

    public GetDomainLogResponse getDomainLog(GetDomainLogRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, LOG, request.getDomain(), LOG);
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        return this.invokeHttpClient(internalRequest, GetDomainLogResponse.class);
    }

    public GetDomainListLogResponse getDomainListLog(GetDomainListLogRequest request) {
        GetDomainListLogTransRequest transRequest = new GetDomainListLogTransRequest();
        if (request.getStartTime() != null) {
            transRequest.withStartTime(DateUtils.formatAlternateIso8601Date(request.getStartTime()));
        }
        if (request.getEndTime() != null) {
            transRequest.withEndTime(DateUtils.formatAlternateIso8601Date(request.getEndTime()));
        }
        transRequest.withDomains(request.getDomains()).withType(request.getType()).withPageNo(request.getPageNo()).withPageSize(request.getPageSize());
        InternalRequest internalRequest = this.createRequest(transRequest, HttpMethodName.POST, LOG, "list");
        this.attachRequestToBody(transRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, GetDomainListLogResponse.class);
    }

    public DescribeIpResponse describeIp(String ip) {
        DescribeIpRequest request = new DescribeIpRequest().withIp(ip);
        return this.describeIp(request);
    }

    public DescribeIpResponse describeIp(DescribeIpRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, UTILS);
        Preconditions.checkNotNull((Object)request.getIp());
        internalRequest.addParameter("action", request.getAction());
        internalRequest.addParameter("ip", request.getIp());
        return this.invokeHttpClient(internalRequest, DescribeIpResponse.class);
    }

    public GetStatMetricResponse getStatMetricData(GetStatMetricRequest request) {
        byte[] content;
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, STAT, "/query");
        try {
            Map<String, Object> params = request.toMap();
            params.put("key_type", request.getKeyType());
            content = JsonUtils.toJsonString(params).getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("utf-8 encoding not supported!", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(content.length));
        internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        internalRequest.setContent(RestartableInputStream.wrap(content));
        return this.invokeHttpClient(internalRequest, GetStatMetricResponse.class);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void attachRequestToBody(AbstractBceRequest request, InternalRequest httpRequest) {
        byte[] content;
        try {
            content = JsonUtils.toJsonString(request).getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("utf-8 encoding not supported!", e);
        }
        httpRequest.addHeader("Content-Length", String.valueOf(content.length));
        httpRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        httpRequest.setContent(RestartableInputStream.wrap(content));
    }

    private void validateAndFillRequestUrl(InternalRequest internalRequest, String type, Date startTime, Date endTime, String url, String marker) {
        if (type != null) {
            internalRequest.addParameter("type", type);
        }
        if (startTime != null) {
            internalRequest.addParameter("startTime", DateUtils.formatAlternateIso8601Date(startTime));
        }
        if (endTime != null) {
            internalRequest.addParameter("endTime", DateUtils.formatAlternateIso8601Date(endTime));
        }
        if (url != null) {
            internalRequest.addParameter("url", url);
        }
        if (marker != null) {
            internalRequest.addParameter("marker", String.valueOf(marker));
        }
    }
}

