/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.moladb.model.transform;

import com.baidubce.BceClientException;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.moladb.model.AttributeValue;
import com.baidubce.services.moladb.model.Key;
import com.baidubce.services.moladb.model.QueryResponse;
import com.baidubce.services.moladb.model.transform.ItemListUnmarshaller;
import com.baidubce.services.moladb.model.transform.KeyUnmarshaller;
import com.baidubce.services.moladb.model.transform.Unmarshaller;
import com.baidubce.services.moladb.model.transform.Unmarshallers;
import com.baidubce.util.JsonUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class QueryResponseUnmarshaller
implements Unmarshaller<QueryResponse, InputStream> {
    private QueryResponse result;

    public QueryResponseUnmarshaller(AbstractBceResponse response) {
        this.result = (QueryResponse)response;
    }

    @Override
    public QueryResponse unmarshall(InputStream inputStream) throws Exception {
        String streamContents = Unmarshallers.readStreamContents(inputStream);
        JsonNode root = JsonUtils.jsonNodeOf(streamContents);
        if (!root.isObject()) {
            throw new BceClientException("input json object:" + root.toString() + " is not an object");
        }
        JsonNode itemsObj = root.get("items");
        if (itemsObj == null) {
            throw new BceClientException("Invalid response:" + root.toString() + " items is not found");
        }
        ItemListUnmarshaller itemsHelper = new ItemListUnmarshaller();
        List<Map<String, AttributeValue>> items = itemsHelper.unmarshall(itemsObj);
        this.result.setItems(items);
        JsonNode lastKeyObj = root.get("lastEvaluatedKey");
        if (lastKeyObj != null) {
            KeyUnmarshaller keyHelper = new KeyUnmarshaller();
            Key lastKey = keyHelper.unmarshall(lastKeyObj);
            this.result.setLastEvaluatedKey(lastKey);
        }
        return this.result;
    }
}

