/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iothub;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.iothub.model.AccountMqttUsageRequest;
import com.baidubce.services.iothub.model.AttachPrincipalToPolicyRequest;
import com.baidubce.services.iothub.model.AttachThingToPrincipalRequest;
import com.baidubce.services.iothub.model.BaseRequest;
import com.baidubce.services.iothub.model.BaseResponse;
import com.baidubce.services.iothub.model.BatchGetMqttClientStatusRequest;
import com.baidubce.services.iothub.model.BatchGetMqttClientStatusResponse;
import com.baidubce.services.iothub.model.CreatePermissionRequest;
import com.baidubce.services.iothub.model.CreatePrincipalResponse;
import com.baidubce.services.iothub.model.DeleteThingRequest;
import com.baidubce.services.iothub.model.ListEndpointsRequest;
import com.baidubce.services.iothub.model.ListPermissionResponse;
import com.baidubce.services.iothub.model.ListPolicyRequest;
import com.baidubce.services.iothub.model.ListPrincipalsRequest;
import com.baidubce.services.iothub.model.ListResponse;
import com.baidubce.services.iothub.model.MqttClientStatusRequest;
import com.baidubce.services.iothub.model.MqttClientStatusResponse;
import com.baidubce.services.iothub.model.MqttUsageResponse;
import com.baidubce.services.iothub.model.Operation;
import com.baidubce.services.iothub.model.QueryEndpointDailyMqttUsageRequest;
import com.baidubce.services.iothub.model.QueryEndpointDailyMqttUsageResponse;
import com.baidubce.services.iothub.model.QueryEndpointRequest;
import com.baidubce.services.iothub.model.QueryEndpointResponse;
import com.baidubce.services.iothub.model.QueryPermissionRequest;
import com.baidubce.services.iothub.model.QueryPermissionResponse;
import com.baidubce.services.iothub.model.QueryPolicyRequest;
import com.baidubce.services.iothub.model.QueryPolicyResponse;
import com.baidubce.services.iothub.model.QueryPrincipalRequest;
import com.baidubce.services.iothub.model.QueryPrincipalResponse;
import com.baidubce.services.iothub.model.QueryThingRequest;
import com.baidubce.services.iothub.model.QueryThingResponse;
import com.baidubce.services.iothub.model.RegenerateCertRequest;
import com.baidubce.services.iothub.model.UpdatePermissionRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.joda.time.ReadablePartial;
import org.joda.time.format.ISODateTimeFormat;

public class IotHubClient
extends AbstractBceClient {
    private static final String ENDPOINT_HOST = "iot.gz.baidubce.com";
    private static final String VERSION = "v1";
    private static final String ENDPOINT = "endpoint";
    private static final String THING = "thing";
    private static final String PRINCIPAL = "principal";
    private static final String POLICY = "policy";
    private static final String PERMISSION = "permission";
    private static final String ACTION = "action";
    private static final String ATTACHTHINGPRINCIPAL = "attach-thing-principal";
    private static final String REMOVETHINGPRINCIPAL = "remove-thing-principal";
    private static final String ATTACHPRINCIPALPOLICY = "attach-principal-policy";
    private static final String REMOVEPRINCIPALPOLICY = "remove-principal-policy";
    private static final String CLIENT = "client";
    private static final String BATCH_CLIENT = "batch-client";
    private static final String STATUS = "status";
    private static final String USAGE = "usage";
    private static final String USAGE_QUERY = "usage-query";
    private static final String START = "start";
    private static final String END = "end";
    private static final String[] HEADERS_TO_SIGN = new String[]{"Host", "x-bce-date"};
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String CONTENT_TYPE = "application/json;charset=UTF-8";
    private static final String GZIP = "gzip";
    private static final String UTF8 = "UTF-8";
    private static final HttpResponseHandler[] IOTHUB_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public IotHubClient(BceClientConfiguration config) {
        super(config.getEndpoint() == null ? config.withEndpoint(ENDPOINT_HOST) : config, IOTHUB_HANDLERS);
    }

    public ListResponse listEndpoints() {
        return this.listEndpoints(new ListEndpointsRequest(), null, null, null, null, null);
    }

    public ListResponse listEndpoints(String order, String orderBy, String pageNo, String pageSize, String q) {
        return this.listEndpoints(new ListEndpointsRequest(), order, orderBy, pageNo, pageSize, q);
    }

    public ListResponse listEndpoints(ListEndpointsRequest listEndpointsRequest, String order, String orderBy, String pageNo, String pageSize, String q) {
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)listEndpointsRequest, HttpMethodName.GET, ENDPOINT);
        this.orderAndPagination(internalRequest, order, orderBy, pageNo, pageSize, q);
        this.fillInHeadAndBody(listEndpointsRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, ListResponse.class);
    }

    public QueryEndpointResponse queryEndpoint(String endpointName) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        return this.queryEndpoint(new QueryEndpointRequest().withEndpointName(endpointName));
    }

    public QueryEndpointResponse queryEndpoint(QueryEndpointRequest queryEndpointRequest) {
        Preconditions.checkNotNull((Object)queryEndpointRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)queryEndpointRequest, HttpMethodName.GET, ENDPOINT, queryEndpointRequest.getEndpointName());
        this.fillInHeadAndBody(queryEndpointRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, QueryEndpointResponse.class);
    }

    public QueryEndpointResponse createEndpoint(String endpointName) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        return this.createEndpoint(new BaseRequest().withEndpointName(endpointName));
    }

    public QueryEndpointResponse createEndpoint(BaseRequest createEndpointRequest) {
        Preconditions.checkNotNull((Object)createEndpointRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)createEndpointRequest, HttpMethodName.POST, ENDPOINT);
        this.fillInHeadAndBody(createEndpointRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, QueryEndpointResponse.class);
    }

    public BaseResponse deleteEndpoint(String endpointName) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        return this.deleteEndpoint(new BaseRequest().withEndpointName(endpointName));
    }

    public BaseResponse deleteEndpoint(BaseRequest deleteEndpointRequest) {
        Preconditions.checkNotNull((Object)deleteEndpointRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)deleteEndpointRequest, HttpMethodName.DELETE, ENDPOINT, deleteEndpointRequest.getEndpointName());
        this.fillInHeadAndBody(deleteEndpointRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, BaseResponse.class);
    }

    public ListResponse listThings(String endpointName) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        return this.listThings(new BaseRequest().withEndpointName(endpointName), null, null, null, null, null);
    }

    public ListResponse listThings(String endpointName, String order, String orderBy, String pageNo, String pageSize, String q) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        return this.listThings(new BaseRequest().withEndpointName(endpointName), order, orderBy, pageNo, pageSize, q);
    }

    public ListResponse listThings(BaseRequest listThingsRequest, String order, String orderBy, String pageNo, String pageSize, String q) {
        Preconditions.checkNotNull((Object)listThingsRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)listThingsRequest, HttpMethodName.GET, ENDPOINT, listThingsRequest.getEndpointName(), THING);
        this.orderAndPagination(internalRequest, order, orderBy, pageNo, pageSize, q);
        this.fillInHeadAndBody(listThingsRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, ListResponse.class);
    }

    public QueryThingResponse queryThing(String endpointName, String thingName) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        return this.queryThing(new QueryThingRequest().withEndpointName(endpointName).withThingName(thingName));
    }

    public QueryThingResponse queryThing(QueryThingRequest queryThingRequest) {
        Preconditions.checkNotNull((Object)queryThingRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)queryThingRequest, HttpMethodName.GET, ENDPOINT, queryThingRequest.getEndpointName(), THING, queryThingRequest.getThingName());
        this.fillInHeadAndBody(queryThingRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, QueryThingResponse.class);
    }

    public QueryThingResponse createThing(String endpointName, String thingName) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        Preconditions.checkNotNull((Object)thingName, (Object)"thingName should not be null");
        return this.createThing(new QueryThingRequest().withEndpointName(endpointName).withThingName(thingName));
    }

    public QueryThingResponse createThing(QueryThingRequest createThingRequest) {
        Preconditions.checkNotNull((Object)createThingRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)createThingRequest, HttpMethodName.POST, ENDPOINT, createThingRequest.getEndpointName(), THING);
        this.fillInHeadAndBody(createThingRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, QueryThingResponse.class);
    }

    public BaseResponse deleteThing(String endpointName, String thingName) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        Preconditions.checkNotNull((Object)thingName, (Object)"thingName should not be null");
        return this.deleteThing(new DeleteThingRequest().withEndpointName(endpointName).withThingName(thingName));
    }

    public BaseResponse deleteThing(DeleteThingRequest deleteThingRequest) {
        Preconditions.checkNotNull((Object)deleteThingRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)deleteThingRequest, HttpMethodName.DELETE, ENDPOINT, deleteThingRequest.getEndpointName(), THING, deleteThingRequest.getThingName());
        this.fillInHeadAndBody(deleteThingRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, BaseResponse.class);
    }

    public ListResponse listPrincipals(String endpointName) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        return this.listPrincipals(new ListPrincipalsRequest().withEndpointName(endpointName), null, null, null, null, null);
    }

    public ListResponse listPrincipals(String endpointName, String thingName) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        return this.listPrincipals(new ListPrincipalsRequest().withEndpointName(endpointName).withThingName(thingName), null, null, null, null, null);
    }

    public ListResponse listPrincipals(String endpointName, String thingName, String order, String orderBy, String pageNo, String pageSize, String q) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        return this.listPrincipals(new ListPrincipalsRequest().withEndpointName(endpointName).withThingName(thingName), order, orderBy, pageNo, pageSize, q);
    }

    public ListResponse listPrincipals(ListPrincipalsRequest listPrincipalsRequest, String order, String orderBy, String pageNo, String pageSize, String q) {
        Preconditions.checkNotNull((Object)listPrincipalsRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)listPrincipalsRequest, HttpMethodName.GET, ENDPOINT, listPrincipalsRequest.getEndpointName(), PRINCIPAL);
        this.orderAndPagination(internalRequest, order, orderBy, pageNo, pageSize, q);
        if (listPrincipalsRequest.getThingName() != null) {
            internalRequest.addParameter("thingName", listPrincipalsRequest.getThingName());
        }
        this.fillInHeadAndBody(listPrincipalsRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, ListResponse.class);
    }

    public QueryPrincipalResponse queryPrincipal(String endpointName, String principalName) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        return this.queryPrincipal(new QueryPrincipalRequest().withEndpointName(endpointName).withPrincipalName(principalName));
    }

    public QueryPrincipalResponse queryPrincipal(QueryPrincipalRequest queryPrincipalRequest) {
        Preconditions.checkNotNull((Object)queryPrincipalRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)queryPrincipalRequest, HttpMethodName.GET, ENDPOINT, queryPrincipalRequest.getEndpointName(), PRINCIPAL, queryPrincipalRequest.getPrincipalName());
        this.fillInHeadAndBody(queryPrincipalRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, QueryPrincipalResponse.class);
    }

    public CreatePrincipalResponse createPrincipal(String endpointName, String principalName) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        Preconditions.checkNotNull((Object)principalName, (Object)"principalName should not be null");
        return this.createPrincipal(new QueryPrincipalRequest().withEndpointName(endpointName).withPrincipalName(principalName));
    }

    public CreatePrincipalResponse createPrincipal(QueryPrincipalRequest createPrincipalRequest) {
        Preconditions.checkNotNull((Object)createPrincipalRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)createPrincipalRequest, HttpMethodName.POST, ENDPOINT, createPrincipalRequest.getEndpointName(), PRINCIPAL);
        this.fillInHeadAndBody(createPrincipalRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, CreatePrincipalResponse.class);
    }

    public CreatePrincipalResponse regenerateCert(String endpointName, String principalName) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        Preconditions.checkNotNull((Object)principalName, (Object)"principalName should not be null");
        return this.regenerateCert(new RegenerateCertRequest().withEndpointName(endpointName).withPrincipalName(principalName));
    }

    public CreatePrincipalResponse regenerateCert(String endpointName, String principalName, String target) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        Preconditions.checkNotNull((Object)principalName, (Object)"principalName should not be null");
        return this.regenerateCert(new RegenerateCertRequest().withEndpointName(endpointName).withPrincipalName(principalName).withTarget(target));
    }

    public CreatePrincipalResponse regenerateCert(RegenerateCertRequest regenerateCertRequest) {
        Preconditions.checkNotNull((Object)regenerateCertRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)regenerateCertRequest, HttpMethodName.POST, ENDPOINT, regenerateCertRequest.getEndpointName(), PRINCIPAL, regenerateCertRequest.getPrincipalName());
        this.fillInHeadAndBody(regenerateCertRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, CreatePrincipalResponse.class);
    }

    public BaseResponse deletePrincipal(String endpointName, String principalName) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        Preconditions.checkNotNull((Object)principalName, (Object)"principalName should not be null");
        return this.deletePrincipal(new QueryPrincipalRequest().withEndpointName(endpointName).withPrincipalName(principalName));
    }

    public BaseResponse deletePrincipal(QueryPrincipalRequest deletePrincipalRequest) {
        Preconditions.checkNotNull((Object)deletePrincipalRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)deletePrincipalRequest, HttpMethodName.DELETE, ENDPOINT, deletePrincipalRequest.getEndpointName(), PRINCIPAL, deletePrincipalRequest.getPrincipalName());
        this.fillInHeadAndBody(deletePrincipalRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, BaseResponse.class);
    }

    public ListResponse listPolicy(String endpointName) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        return this.listPolicy(new ListPolicyRequest().withEndpointName(endpointName), null, null, null, null, null);
    }

    public ListResponse listPolicy(String endpointName, String principalName) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        return this.listPolicy(new ListPolicyRequest().withEndpointName(endpointName).withPrincipalName(principalName), null, null, null, null, null);
    }

    public ListResponse listPolicy(String endpointName, String principalName, String order, String orderBy, String pageNo, String pageSize, String q) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        return this.listPolicy(new ListPolicyRequest().withEndpointName(endpointName).withPrincipalName(principalName), order, orderBy, pageNo, pageSize, q);
    }

    public ListResponse listPolicy(ListPolicyRequest listPolicyRequest, String order, String orderBy, String pageNo, String pageSize, String q) {
        Preconditions.checkNotNull((Object)listPolicyRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)listPolicyRequest, HttpMethodName.GET, ENDPOINT, listPolicyRequest.getEndpointName(), POLICY);
        this.orderAndPagination(internalRequest, order, orderBy, pageNo, pageSize, q);
        if (listPolicyRequest.getPrincipalName() != null) {
            internalRequest.addParameter("principalName", listPolicyRequest.getPrincipalName());
        }
        this.fillInHeadAndBody(listPolicyRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, ListResponse.class);
    }

    public QueryPolicyResponse queryPolicy(String endpointName, String policyName) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        return this.queryPolicy(new QueryPolicyRequest().withEndpointName(endpointName).withPolicyName(policyName));
    }

    public QueryPolicyResponse queryPolicy(QueryPolicyRequest queryPolicyRequest) {
        Preconditions.checkNotNull((Object)queryPolicyRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)queryPolicyRequest, HttpMethodName.GET, ENDPOINT, queryPolicyRequest.getEndpointName(), POLICY, queryPolicyRequest.getPolicyName());
        this.fillInHeadAndBody(queryPolicyRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, QueryPolicyResponse.class);
    }

    public QueryPolicyResponse createPolicy(String endpointName, String policyName) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        Preconditions.checkNotNull((Object)policyName, (Object)"policyName should not be null");
        return this.createPolicy(new QueryPolicyRequest().withEndpointName(endpointName).withPolicyName(policyName));
    }

    public QueryPolicyResponse createPolicy(QueryPolicyRequest createPolicyRequest) {
        Preconditions.checkNotNull((Object)createPolicyRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)createPolicyRequest, HttpMethodName.POST, ENDPOINT, createPolicyRequest.getEndpointName(), POLICY);
        this.fillInHeadAndBody(createPolicyRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, QueryPolicyResponse.class);
    }

    public BaseResponse deletePolicy(String endpointName, String policyName) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        Preconditions.checkNotNull((Object)policyName, (Object)"policyName should not be null");
        return this.deletePolicy(new QueryPolicyRequest().withEndpointName(endpointName).withPolicyName(policyName));
    }

    public BaseResponse deletePolicy(QueryPolicyRequest deletePolicyRequest) {
        Preconditions.checkNotNull((Object)deletePolicyRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)deletePolicyRequest, HttpMethodName.DELETE, ENDPOINT, deletePolicyRequest.getEndpointName(), POLICY, deletePolicyRequest.getPolicyName());
        this.fillInHeadAndBody(deletePolicyRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, BaseResponse.class);
    }

    public ListPermissionResponse listPermission(String endpointName, String policyName) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        Preconditions.checkNotNull((Object)policyName, (Object)"policyName should not be null");
        return this.listPermission(new QueryPolicyRequest().withEndpointName(endpointName).withPolicyName(policyName), null, null, null, null, null);
    }

    public ListPermissionResponse listPermission(String endpointName, String policyName, String order, String orderBy, String pageNo, String pageSize, String q) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        Preconditions.checkNotNull((Object)policyName, (Object)"policyName should not be null");
        return this.listPermission(new QueryPolicyRequest().withEndpointName(endpointName).withPolicyName(policyName), order, orderBy, pageNo, pageSize, q);
    }

    public ListPermissionResponse listPermission(QueryPolicyRequest listPermissonRequest, String order, String orderBy, String pageNo, String pageSize, String q) {
        Preconditions.checkNotNull((Object)listPermissonRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)listPermissonRequest, HttpMethodName.GET, ENDPOINT, listPermissonRequest.getEndpointName(), PERMISSION);
        this.orderAndPagination(internalRequest, order, orderBy, pageNo, pageSize, q);
        internalRequest.addParameter("policyName", listPermissonRequest.getPolicyName());
        this.fillInHeadAndBody(listPermissonRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, ListPermissionResponse.class);
    }

    public QueryPermissionResponse queryPermission(String endpointName, String permissionUuid) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        Preconditions.checkNotNull((Object)permissionUuid, (Object)"permissionUuid should not be null");
        return this.queryPermission(new QueryPermissionRequest().withEndpointName(endpointName).withPermissionUuid(permissionUuid));
    }

    public QueryPermissionResponse queryPermission(QueryPermissionRequest queryPermissionRequest) {
        Preconditions.checkNotNull((Object)queryPermissionRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)queryPermissionRequest, HttpMethodName.GET, ENDPOINT, queryPermissionRequest.getEndpointName(), PERMISSION, queryPermissionRequest.getPermissionUuid());
        this.fillInHeadAndBody(queryPermissionRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, QueryPermissionResponse.class);
    }

    public QueryPermissionResponse createPermission(String endpointName, String policyName, List<Operation> operations, String topic) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        Preconditions.checkNotNull((Object)policyName, (Object)"policyName should not be null");
        Preconditions.checkNotNull(operations, (Object)"operations should not be null");
        Preconditions.checkNotNull((Object)topic, (Object)"topic should not be null");
        return this.createPermission(new CreatePermissionRequest().withEndpointName(endpointName).withPolicyName(policyName).withOperations(operations).withTopic(topic));
    }

    public QueryPermissionResponse createPermission(CreatePermissionRequest createPermissionRequest) {
        Preconditions.checkNotNull((Object)createPermissionRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)createPermissionRequest, HttpMethodName.POST, ENDPOINT, createPermissionRequest.getEndpointName(), PERMISSION);
        this.fillInHeadAndBody(createPermissionRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, QueryPermissionResponse.class);
    }

    public QueryPermissionResponse updatePermission(String endpointName, String permissionUuid, List<Operation> operations, String topic) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        Preconditions.checkNotNull((Object)permissionUuid, (Object)"permissionUuid should not be null");
        return this.updatePermission(new UpdatePermissionRequest().withEndpointName(endpointName).withPermissionUuid(permissionUuid).withOperations(operations).withTopic(topic));
    }

    public QueryPermissionResponse updatePermission(UpdatePermissionRequest updatePermissionRequest) {
        Preconditions.checkNotNull((Object)updatePermissionRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)updatePermissionRequest, HttpMethodName.PUT, ENDPOINT, updatePermissionRequest.getEndpointName(), PERMISSION, updatePermissionRequest.getPermissionUuid());
        this.fillInHeadAndBody(updatePermissionRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, QueryPermissionResponse.class);
    }

    public BaseResponse deletePermission(String endpointName, String permissionUuid) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        return this.deletePermission(new BaseRequest().withEndpointName(endpointName), permissionUuid);
    }

    public BaseResponse deletePermission(BaseRequest deletePolicyRequest, String permissionUuid) {
        Preconditions.checkNotNull((Object)deletePolicyRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)permissionUuid, (Object)"permissionUuid should not be null");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)deletePolicyRequest, HttpMethodName.DELETE, ENDPOINT, deletePolicyRequest.getEndpointName(), PERMISSION, permissionUuid);
        this.fillInHeadAndBody(deletePolicyRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, BaseResponse.class);
    }

    public BaseResponse attachThingToPrincipal(String endpointName, String thingName, String principaName) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        Preconditions.checkNotNull((Object)thingName, (Object)"thingName should not be null");
        Preconditions.checkNotNull((Object)principaName, (Object)"principaName should not be null");
        return this.attachThingToPrincipal(new AttachThingToPrincipalRequest().withEndpointName(endpointName).withThingName(thingName).withPrincipalName(principaName));
    }

    public BaseResponse attachThingToPrincipal(AttachThingToPrincipalRequest attachThingToPrincipalRequest) {
        Preconditions.checkNotNull((Object)attachThingToPrincipalRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)attachThingToPrincipalRequest, HttpMethodName.POST, ACTION, ATTACHTHINGPRINCIPAL);
        this.fillInHeadAndBody(attachThingToPrincipalRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, BaseResponse.class);
    }

    public BaseResponse removeThingToPrincipal(String endpointName, String thingName, String principaName) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        Preconditions.checkNotNull((Object)thingName, (Object)"thingName should not be null");
        Preconditions.checkNotNull((Object)principaName, (Object)"principaName should not be null");
        return this.removeThingToPrincipal(new AttachThingToPrincipalRequest().withEndpointName(endpointName).withThingName(thingName).withPrincipalName(principaName));
    }

    public BaseResponse removeThingToPrincipal(AttachThingToPrincipalRequest attachThingToPrincipalRequest) {
        Preconditions.checkNotNull((Object)attachThingToPrincipalRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)attachThingToPrincipalRequest, HttpMethodName.POST, ACTION, REMOVETHINGPRINCIPAL);
        this.fillInHeadAndBody(attachThingToPrincipalRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, BaseResponse.class);
    }

    public BaseResponse attachPrincipalToPolicy(String endpointName, String principaName, String policyName) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        Preconditions.checkNotNull((Object)policyName, (Object)"policyName should not be null");
        Preconditions.checkNotNull((Object)principaName, (Object)"principaName should not be null");
        return this.attachPrincipalToPolicy(new AttachPrincipalToPolicyRequest().withEndpointName(endpointName).withPolicyName(policyName).withPrincipalName(principaName));
    }

    public BaseResponse attachPrincipalToPolicy(AttachPrincipalToPolicyRequest attachPrincipalToPolicyRequest) {
        Preconditions.checkNotNull((Object)attachPrincipalToPolicyRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)attachPrincipalToPolicyRequest, HttpMethodName.POST, ACTION, ATTACHPRINCIPALPOLICY);
        this.fillInHeadAndBody(attachPrincipalToPolicyRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, BaseResponse.class);
    }

    public BaseResponse removePrincipalToPolicy(String endpointName, String principaName, String policyName) {
        Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName should not be null");
        Preconditions.checkNotNull((Object)policyName, (Object)"policyName should not be null");
        Preconditions.checkNotNull((Object)principaName, (Object)"principaName should not be null");
        return this.removePrincipalToPolicy(new AttachPrincipalToPolicyRequest().withEndpointName(endpointName).withPolicyName(policyName).withPrincipalName(principaName));
    }

    public BaseResponse removePrincipalToPolicy(AttachPrincipalToPolicyRequest attachPrincipalToPolicyRequest) {
        Preconditions.checkNotNull((Object)attachPrincipalToPolicyRequest, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)attachPrincipalToPolicyRequest, HttpMethodName.POST, ACTION, REMOVEPRINCIPALPOLICY);
        this.fillInHeadAndBody(attachPrincipalToPolicyRequest, internalRequest);
        return this.invokeHttpClient(internalRequest, BaseResponse.class);
    }

    public MqttClientStatusResponse getClientStatus(MqttClientStatusRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)request.getEndpointName(), (Object)"endpointName should not be null.");
        Preconditions.checkNotNull((Object)request.getClientId(), (Object)"clientId should not be null.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)request, HttpMethodName.GET, ENDPOINT, request.getEndpointName(), CLIENT, request.getClientId(), STATUS);
        return this.invokeHttpClient(internalRequest, MqttClientStatusResponse.class);
    }

    public BatchGetMqttClientStatusResponse batchGetClientStatus(BatchGetMqttClientStatusRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)request.getEndpointName(), (Object)"endpointName should not be null.");
        Preconditions.checkNotNull(request.getClientIdList(), (Object)"clientIdList should not be null.");
        Preconditions.checkArgument((!request.getClientIdList().isEmpty() ? 1 : 0) != 0, (Object)"clientIdList should not be empty.");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)request, HttpMethodName.POST, ENDPOINT, request.getEndpointName(), BATCH_CLIENT, STATUS);
        this.fillInHeadAndBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, BatchGetMqttClientStatusResponse.class);
    }

    public MqttUsageResponse getAccountMqttUsageOfCurrentBillingMonth(AccountMqttUsageRequest request) {
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)request, HttpMethodName.GET, USAGE);
        return this.invokeHttpClient(internalRequest, MqttUsageResponse.class);
    }

    public MqttUsageResponse getEndpointMqttUsageOfCurrentBillingMonth(BaseRequest request) {
        Preconditions.checkNotNull((Object)request.getEndpointName(), (Object)"endpointName should not be null");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)request, HttpMethodName.GET, ENDPOINT, request.getEndpointName(), USAGE);
        return this.invokeHttpClient(internalRequest, MqttUsageResponse.class);
    }

    public QueryEndpointDailyMqttUsageResponse queryEndpointDailyMqttUsage(QueryEndpointDailyMqttUsageRequest request) {
        Preconditions.checkNotNull((Object)request.getEndpointName(), (Object)"endpointName should not be null");
        Preconditions.checkNotNull((Object)request.getStart(), (Object)"start should not be null");
        Preconditions.checkNotNull((Object)request.getEnd(), (Object)"end should not be null");
        InternalRequest internalRequest = this.createRequest((AbstractBceRequest)request, HttpMethodName.POST, ENDPOINT, request.getEndpointName(), USAGE_QUERY);
        internalRequest.addParameter(START, ISODateTimeFormat.date().print((ReadablePartial)request.getStart()));
        internalRequest.addParameter(END, ISODateTimeFormat.date().print((ReadablePartial)request.getEnd()));
        return this.invokeHttpClient(internalRequest, QueryEndpointDailyMqttUsageResponse.class);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        return this.createRequest(bceRequest, httpMethod, (SignOptions)null, pathVariables);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, SignOptions signOptions, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        if (signOptions == null) {
            signOptions = new SignOptions();
            signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        }
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillInHeadAndBody(AbstractBceRequest bceRequest, InternalRequest request) {
        byte[] content = this.toJson(bceRequest);
        request.addHeader("Content-Length", Integer.toString(content.length));
        request.addHeader("Content-Type", CONTENT_TYPE);
        request.setContent(RestartableInputStream.wrap(content));
    }

    private byte[] toJson(AbstractBceRequest bceRequest) {
        String jsonStr = JsonUtils.toJsonString(bceRequest);
        try {
            return jsonStr.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
    }

    private void orderAndPagination(InternalRequest internalRequest, String order, String orderBy, String pageNo, String pageSize, String q) {
        if (order != null) {
            internalRequest.addParameter("order", order);
        }
        if (orderBy != null) {
            internalRequest.addParameter("orderBy", orderBy);
        }
        if (pageNo != null) {
            internalRequest.addParameter("pageNo", pageNo);
        }
        if (pageSize != null) {
            internalRequest.addParameter("pageSize", pageSize);
        }
        if (q != null) {
            internalRequest.addParameter("q", q);
        }
    }
}

