/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client;

import com.basho.riak.client.IRiakObject;
import com.basho.riak.client.RiakLink;
import com.basho.riak.client.cap.VClock;
import com.basho.riak.client.convert.RiakKey;
import com.basho.riak.client.query.indexes.BinIndex;
import com.basho.riak.client.query.indexes.IntIndex;
import com.basho.riak.client.query.indexes.RiakIndexes;
import com.basho.riak.client.util.CharsetUtils;
import com.basho.riak.client.util.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRiakObject
implements IRiakObject {
    public static String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private final String bucket;
    @RiakKey
    private final String key;
    private final VClock vclock;
    private final String vtag;
    private final long lastModified;
    private final Object linksLock = new Object();
    private final Collection<RiakLink> links;
    private final Object userMetaLock = new Object();
    private final Map<String, String> userMeta;
    private final RiakIndexes indexes;
    private volatile String contentType;
    private volatile byte[] value;

    public DefaultRiakObject(String bucket, String key, VClock vclock, String vtag, Date lastModified, String contentType, byte[] value, Collection<RiakLink> links, Map<String, String> userMeta, RiakIndexes indexes) {
        if (bucket == null) {
            throw new IllegalArgumentException("Bucket cannot be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        this.bucket = bucket;
        this.key = key;
        this.vclock = vclock;
        this.vtag = vtag;
        this.lastModified = lastModified == null ? 0L : lastModified.getTime();
        this.safeSetContentType(contentType);
        this.value = this.copy(value);
        this.links = this.copy(links);
        this.userMeta = this.copy(userMeta);
        this.indexes = RiakIndexes.from(indexes);
    }

    private byte[] copy(byte[] value) {
        if (value == null) {
            return null;
        }
        return (byte[])value.clone();
    }

    private Map<String, String> copy(Map<String, String> userMeta) {
        HashMap<Object, Object> copy = userMeta == null ? new HashMap() : new HashMap<String, String>(userMeta);
        return copy;
    }

    private <T> Collection<T> copy(Collection<T> l) {
        ArrayList<Object> copy = l == null ? new ArrayList() : new ArrayList<T>(l);
        return copy;
    }

    private void safeSetContentType(String contentType) {
        this.contentType = contentType == null ? DEFAULT_CONTENT_TYPE : contentType;
    }

    @Override
    public String getBucket() {
        return this.bucket;
    }

    @Override
    public VClock getVClock() {
        return this.vclock;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getVtag() {
        return this.vtag;
    }

    @Override
    public Date getLastModified() {
        Date lastModified = null;
        if (this.lastModified != 0L) {
            lastModified = new Date(this.lastModified);
        }
        return lastModified;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public Map<String, String> getMeta() {
        return new HashMap<String, String>(this.userMeta);
    }

    @Override
    public byte[] getValue() {
        return this.copy(this.value);
    }

    @Override
    public void setValue(byte[] value) {
        this.value = this.copy(value);
    }

    @Override
    public void setValue(String value) {
        this.value = CharsetUtils.utf8StringToBytes(value);
        this.contentType = CharsetUtils.addUtf8Charset(this.contentType);
    }

    @Override
    public void setContentType(String contentType) {
        this.safeSetContentType(contentType);
    }

    @Override
    public Iterator<RiakLink> iterator() {
        return new UnmodifiableIterator<RiakLink>(this.getLinks().iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRiakObject addLink(RiakLink link) {
        if (link != null) {
            Object object = this.linksLock;
            synchronized (object) {
                this.links.add(link);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRiakObject removeLink(RiakLink link) {
        Object object = this.linksLock;
        synchronized (object) {
            this.links.remove(link);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasLinks() {
        Object object = this.linksLock;
        synchronized (object) {
            return !this.links.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int numLinks() {
        Object object = this.linksLock;
        synchronized (object) {
            return this.links.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RiakLink> getLinks() {
        Object object = this.linksLock;
        synchronized (object) {
            return new ArrayList<RiakLink>(this.links);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasLink(RiakLink riakLink) {
        Object object = this.linksLock;
        synchronized (object) {
            return this.links.contains(riakLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRiakObject addUsermeta(String key, String value) {
        Object object = this.userMetaLock;
        synchronized (object) {
            this.userMeta.put(key, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasUsermeta() {
        Object object = this.userMetaLock;
        synchronized (object) {
            return !this.userMeta.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasUsermeta(String key) {
        Object object = this.userMetaLock;
        synchronized (object) {
            return this.userMeta.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUsermeta(String key) {
        Object object = this.userMetaLock;
        synchronized (object) {
            return this.userMeta.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRiakObject removeUsermeta(String key) {
        Object object = this.userMetaLock;
        synchronized (object) {
            this.userMeta.remove(key);
        }
        return this;
    }

    @Override
    public Iterable<Map.Entry<String, String>> userMetaEntries() {
        return Collections.unmodifiableCollection(this.userMeta.entrySet());
    }

    @Override
    public String getVClockAsString() {
        if (this.vclock != null) {
            return this.vclock.asString();
        }
        return null;
    }

    @Override
    public String getValueAsString() {
        return CharsetUtils.asString(this.value, CharsetUtils.getCharset(this.contentType));
    }

    @Override
    public Map<BinIndex, Set<String>> allBinIndexes() {
        return this.indexes.getBinIndexes();
    }

    @Override
    public Set<String> getBinIndex(String name) {
        return this.indexes.getBinIndex(name);
    }

    @Override
    public Map<IntIndex, Set<Integer>> allIntIndexes() {
        return this.indexes.getIntIndexes();
    }

    @Override
    public Set<Integer> getIntIndex(String name) {
        return this.indexes.getIntIndex(name);
    }

    @Override
    public IRiakObject addIndex(String index, String value) {
        this.indexes.add(index, value);
        return this;
    }

    @Override
    public IRiakObject addIndex(String index, int value) {
        this.indexes.add(index, value);
        return this;
    }

    @Override
    public IRiakObject removeBinIndex(String index) {
        this.indexes.removeAll(BinIndex.named(index));
        return this;
    }

    @Override
    public IRiakObject removeIntIndex(String index) {
        this.indexes.removeAll(IntIndex.named(index));
        return this;
    }
}

