/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.cap;

import com.basho.riak.client.RiakRetryFailedException;
import com.basho.riak.client.cap.Retrier;
import com.basho.riak.client.convert.ConversionException;
import com.basho.riak.client.raw.MatchFoundException;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRetrier
implements Retrier {
    private final int attempts;

    public DefaultRetrier(int attempts) {
        this.attempts = attempts;
    }

    @Override
    public <T> T attempt(Callable<T> command) throws RiakRetryFailedException {
        return DefaultRetrier.attempt(command, this.attempts);
    }

    public static <T> T attempt(Callable<T> command, int times) throws RiakRetryFailedException {
        try {
            return command.call();
        }
        catch (MatchFoundException e) {
            throw e;
        }
        catch (ConversionException e) {
            throw e;
        }
        catch (Exception e) {
            if (times == 0) {
                throw new RiakRetryFailedException(e);
            }
            return DefaultRetrier.attempt(command, --times);
        }
    }

    public static Retrier attempts(int attempts) {
        return new DefaultRetrier(attempts);
    }
}

